/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.HandlerParameter;
import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CommandInserter
extends AbstractHandler {
    public CommandInserter() {
    }

    public CommandInserter(IHandlerConfiguration conf) {
        super(conf);
    }

    @Override
    public IMessage postProcess(IMessage msg) throws HandlerException {
        return msg;
    }

    @Override
    public IMessage process(IMessage msg) throws HandlerException {
        MessageImpl result = null;
        try {
            Document document = XMLDocumentUtility.loadXml(msg.getPayload().getContent());
            Element e = document.createElement("Command");
            e.setAttribute("Name", this.getConfiguration().getParameterValue(HandlerParameter.COMMAND));
            String selector = this.getConfiguration().getParameterValue(HandlerParameter.SELECTOR);
            if (selector != null) {
                Element parameter = document.createElement("CommandParameter");
                parameter.setAttribute("Name", "selector");
                parameter.setAttribute("Value", selector);
                e.appendChild(parameter);
            }
            document.getDocumentElement().appendChild(e);
            String content = XMLDocumentUtility.convertToString(document);
            result = new MessageImpl(new StringPayload(content), msg.getAttachment());
        }
        catch (Exception e) {
            throw new HandlerException("Failed to insert the command", e);
        }
        return result;
    }
}

