/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.webservice;

import com.tandbergtv.workflow.adaptor.AdaptorManager;
import com.tandbergtv.workflow.adaptor.AdaptorRequestFactory;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.message.IPayload;
import java.io.StringReader;
import javax.servlet.ServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class SOAPFacade
implements ServiceLifecycle {
    private static final Logger logger = Logger.getLogger(SOAPFacade.class);

    public void init(Object arg0) throws ServiceException {
        logger.info((Object)"Initialized");
    }

    public void destroy() {
        logger.info((Object)"Destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SOAPEnvelope req, SOAPEnvelope res) {
        logger.debug((Object)"Processing message...");
        MessageContext context = MessageContext.getCurrentContext();
        Message msg = (Message)context.getMessage();
        try {
            ServletRequest servlet = (ServletRequest)context.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            IAdaptorRequest request = AdaptorRequestFactory.newInstance().createRequest((SOAPMessage)msg, servlet.getRemoteHost());
            IAdaptor adaptor = AdaptorManager.getInstance().getAdaptor(request);
            IAdaptorResponse response = adaptor.transmit(request);
            IPayload payload = response.getMessage().getPayload();
            Document ret = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(payload.getContent())), new DOMResult(ret));
            res.getBody().addDocument(ret);
        }
        catch (Throwable e) {
            logger.error((Object)"An error occured while processing the message", e);
            this.addSOAPFault(res, e);
        }
        finally {
            logger.info((Object)"Done processing message");
        }
    }

    private void addSOAPFault(SOAPEnvelope envelope, Throwable e) {
        try {
            envelope.getBody().addFault();
            envelope.getBody().getFault().setFaultString(e.getMessage());
        }
        catch (SOAPException se) {
            logger.error((Object)se.getMessage(), (Throwable)se);
        }
    }
}

