/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.auth;

import com.tandbergtv.workflow.auth.AuthorizationException;
import com.tandbergtv.workflow.auth.Credentials;
import com.tandbergtv.workflow.auth.IAuthorizationManager;
import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.auth.Permission;
import com.tandbergtv.workflow.auth.ProtectionKey;
import com.tandbergtv.workflow.auth.Role;
import com.tandbergtv.workflow.dao.HibernateContext;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public final class AuthorizationManager
implements IAuthorizationManager {
    private static IAuthorizationManager instance;
    private static final Logger logger;
    private Cache cache = new Cache("module-cache", 64, false, true, 0L, 0L, false, 0L);
    private static final String CACHE_NAME = "module-cache";
    private static final int MAX_CACHE_SIZE = 64;
    private static final Lock lock;

    private AuthorizationManager() {
        CacheManager.getInstance().addCache(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAuthorizationManager getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new AuthorizationManager();
            }
        }
        finally {
            lock.unlock();
        }
        return instance;
    }

    @Override
    public void init() {
        List<Module> modules = this.getModulesImpl();
        for (Module module : modules) {
            this.cache.put(new Element((Serializable)Long.valueOf(module.getId()), (Serializable)module));
        }
        logger.info((Object)("Authorization manager initialized, cached " + this.cache.getSize() + " elements"));
    }

    @Override
    public void destroy() {
        logger.debug((Object)"Authorization manager destroyed");
    }

    @Override
    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        List list = this.cache.getKeys();
        for (Object obj : list) {
            modules.add((Module)this.cache.get(obj).getValue());
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Module> getModulesImpl() {
        ArrayList<Module> modules = new ArrayList<Module>();
        Session session = this.getSession();
        try {
            List list = session.createCriteria(Module.class).addOrder(Order.asc((String)"id")).list();
            for (Object obj : list) {
                modules.add((Module)obj);
            }
        }
        finally {
            this.closeSession(session);
        }
        return modules;
    }

    @Override
    public Permission getPermission(Serializable key) {
        List list = this.cache.getKeys();
        for (Object obj : list) {
            Module module = (Module)this.cache.get(obj).getValue();
            for (Permission permission : module.getPermissions()) {
                if (permission.getId() != ((Long)key).longValue()) continue;
                return permission;
            }
        }
        return null;
    }

    @Override
    public Credentials getCredentials(Principal principal) throws AuthorizationException {
        Credentials credentials = null;
        try {
            List<Role> roles = this.getRoles(principal);
            credentials = new Credentials(principal, roles);
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to get credentials", e);
        }
        return credentials;
    }

    @Override
    public List<Role> getRoles() throws AuthorizationException {
        Session session = this.getSession();
        ArrayList<Role> roles = new ArrayList<Role>();
        try {
            List list = session.createCriteria(Role.class).list();
            for (Object obj : list) {
                roles.add((Role)obj);
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to get list of roles", e);
        }
        finally {
            this.closeSession(session);
        }
        return roles;
    }

    @Override
    public Role createRole(Role role) throws AuthorizationException {
        try {
            this.save(role);
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to save role: " + role, e);
        }
        return role;
    }

    @Override
    public Role getRole(Serializable key) throws AuthorizationException {
        Session session = this.getSession();
        Role role = null;
        try {
            role = (Role)session.load(Role.class, key);
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to get role: " + key, e);
        }
        finally {
            this.closeSession(session);
        }
        return role;
    }

    @Override
    public Role updateRole(Role role) throws AuthorizationException {
        try {
            this.update(role);
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to update role: " + role, e);
        }
        return role;
    }

    @Override
    public void deleteRole(Role role) throws AuthorizationException {
        Session session = this.getSession();
        Transaction t = session.beginTransaction();
        try {
            session.delete((Object)role);
            t.commit();
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new AuthorizationException("Failed to delete role: " + role, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private List<Role> getRoles(Principal principal) throws Exception {
        String[] names = ((GenericPrincipal)principal).getRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        for (String name : names) {
            roles.add(this.getRole((Serializable)((Object)name)));
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProtectionKey> getAllProtectionKeys() {
        Session session = this.getSession();
        ArrayList<ProtectionKey> protectionKeys = new ArrayList<ProtectionKey>();
        try {
            List list = session.createCriteria(ProtectionKey.class).addOrder(Order.asc((String)"name")).list();
            for (Object obj : list) {
                protectionKeys.add((ProtectionKey)obj);
            }
        }
        finally {
            this.closeSession(session);
        }
        return protectionKeys;
    }

    @Override
    public ProtectionKey getProtectionKey(int protKeyID) {
        List<ProtectionKey> protKeys = this.getAllProtectionKeys();
        for (ProtectionKey protKey : protKeys) {
            if (protKeyID != protKey.getId()) continue;
            return protKey;
        }
        return null;
    }

    @Override
    public ProtectionKey getProtectionKey(String name) {
        for (ProtectionKey key : this.getAllProtectionKeys()) {
            if (!name.equals(key.getName())) continue;
            return key;
        }
        return null;
    }

    @Override
    public void addProtectionKey(ProtectionKey key) {
        this.save(key);
    }

    @Override
    public int getProtectionKeyIDForName(String protKeyName, boolean createIfNotExists) {
        for (ProtectionKey protectionKey : this.getAllProtectionKeys()) {
            if (protectionKey == null || protectionKey.getName() == null || !protectionKey.getName().equals(protKeyName)) continue;
            return protectionKey.getId();
        }
        if (createIfNotExists) {
            logger.info((Object)("Creating a new protection key in database | Protection Key Name: " + protKeyName));
            ProtectionKey protectionKey = new ProtectionKey();
            protectionKey.setName(protKeyName);
            this.save(protectionKey);
            return this.getProtectionKeyIDForName(protKeyName, false);
        }
        return -1;
    }

    private Object save(Object entity) {
        Session session = this.getSession();
        Transaction t = session.beginTransaction();
        try {
            session.save(entity);
            t.commit();
        }
        catch (RuntimeException e) {
            if (t != null) {
                t.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
        return entity;
    }

    private Object update(Object entity) {
        Session session = this.getSession();
        Transaction t = session.beginTransaction();
        try {
            session.update(entity);
            t.commit();
        }
        catch (RuntimeException e) {
            if (t != null) {
                t.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
        return entity;
    }

    private Session getSession() {
        return HibernateContext.getContext().openSession();
    }

    private void closeSession(Session session) {
        session.close();
    }

    static {
        logger = Logger.getLogger(AuthorizationManager.class);
        lock = new ReentrantLock();
    }
}

