/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.auth;

import com.tandbergtv.workflow.auth.ACLEntry;
import com.tandbergtv.workflow.auth.Action;
import com.tandbergtv.workflow.auth.Permission;
import com.tandbergtv.workflow.auth.Role;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Credentials {
    private Principal principal;
    private Collection<Role> roles;
    private Set<String> actions = new HashSet<String>();
    private Set<String> sections = new HashSet<String>();

    private Credentials() {
    }

    public Credentials(Principal principal, Collection<Role> roles) {
        this();
        this.principal = principal;
        this.roles = roles;
        for (Role role : roles) {
            Set<ACLEntry> acl = role.getACL();
            for (ACLEntry entry : acl) {
                Permission permission = entry.getPermission();
                for (Action action : permission.getActions()) {
                    this.actions.add(action.getPath());
                }
                this.sections.add(permission.getSectionName());
            }
        }
    }

    public Set<String> getActions() {
        return this.actions;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Set<String> getSections() {
        return this.sections;
    }

    public String getName() {
        return this.principal.getName();
    }

    public Collection<Role> getRoles() {
        return this.roles;
    }

    public Collection<Permission> getPermissions() {
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (Role role : this.roles) {
            Set<ACLEntry> acl = role.getACL();
            for (ACLEntry entry : acl) {
                permissions.add(entry.getPermission());
            }
        }
        return permissions;
    }
}

