/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.util.FileUtility;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class ProductInfo {
    private static final String VERSION_FILE = "/version.properties";
    private static final String PRODUCT_NAME = "WatchPoint Workflow System";
    private static ProductInfo instance = new ProductInfo();
    private static final Logger logger = Logger.getLogger(ProductInfo.class);
    private String versionNumber = null;

    private ProductInfo() {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(VERSION_FILE);
        String contents = null;
        try {
            contents = FileUtility.readStreamContents(inStream);
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to read the Workflow System version file: /version.properties", (Throwable)ex);
        }
        this.versionNumber = contents != null ? contents.trim() : "";
    }

    public static ProductInfo getInstance() {
        return instance;
    }

    public String getVersion() {
        return this.versionNumber;
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getVersionedProductName() {
        String name = PRODUCT_NAME;
        if (this.versionNumber != null) {
            name = name + " v" + this.versionNumber;
        }
        return name;
    }
}

