/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.event;

import com.tandbergtv.workflow.core.event.ColleagueComparator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractMediator
implements IMediator {
    private Collection<WeakReference<IColleague>> references = new PriorityQueue<WeakReference<IColleague>>(10, new ColleagueComparator());
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final Logger logger = Logger.getLogger(AbstractMediator.class);

    protected AbstractMediator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(IColleague colleague) {
        Collection<WeakReference<IColleague>> collection = this.references;
        synchronized (collection) {
            this.references.add(new WeakReference<IColleague>(colleague));
        }
        logger.debug((Object)("Added " + colleague.getColleagueName() + " [" + this.references.size() + "]"));
        for (WeakReference<IColleague> reference : this.references) {
            IColleague c = (IColleague)reference.get();
            if (c == null) continue;
            logger.debug((Object)("Colleague " + c.getColleagueName() + ", priority " + (Object)((Object)c.getColleaguePriority())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(IColleague colleague) {
        Collection<WeakReference<IColleague>> collection = this.references;
        synchronized (collection) {
            Iterator<WeakReference<IColleague>> i = this.references.iterator();
            while (i.hasNext()) {
                WeakReference<IColleague> reference = i.next();
                IColleague c = (IColleague)reference.get();
                if (c != null && c != colleague) continue;
                i.remove();
                logger.debug((Object)("Removed colleague " + colleague.getColleagueName()));
            }
        }
    }

    @Override
    public void sendAsync(WorkflowEvent event) {
        this.send(event, true);
    }

    @Override
    public void send(WorkflowEvent event) {
        this.send(event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(final WorkflowEvent event, boolean isAsync) {
        ArrayList<WeakReference<IColleague>> copy = null;
        Iterator<WeakReference<IColleague>> i = null;
        Collection<WeakReference<IColleague>> collection = this.references;
        synchronized (collection) {
            copy = new ArrayList<WeakReference<IColleague>>();
            i = this.references.iterator();
            while (i.hasNext()) {
                WeakReference<IColleague> reference = i.next();
                IColleague colleague = (IColleague)reference.get();
                if (colleague == null) {
                    i.remove();
                    logger.debug((Object)"Removed colleague");
                    continue;
                }
                copy.add(reference);
            }
        }
        for (WeakReference<IColleague> reference : copy) {
            final IColleague colleague = (IColleague)reference.get();
            if (colleague == null) continue;
            if (isAsync) {
                this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        colleague.receive(event);
                    }
                }, 0L, TimeUnit.MILLISECONDS);
                continue;
            }
            colleague.receive(event);
        }
    }
}

