/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.graph.node.Fork;
import org.jbpm.logging.log.ProcessLog;

public class ExtendedFork
extends Fork {
    private static final long serialVersionUID = 2146745869571244953L;
    private static final Logger logger = Logger.getLogger(ExtendedFork.class);
    public static final String TOKEN_NAME_SEPARATOR = "|";

    public ExtendedFork() {
    }

    public ExtendedFork(String name) {
        super(name);
    }

    public void execute(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        logger.info((Object)(token + " (" + this.name + ")"));
        ArrayList<CustomToken> childTokens = new ArrayList<CustomToken>();
        for (String transitionName : this.getLeavingTransitionsMap().keySet()) {
            logger.debug((Object)(token + " creating token for transition " + transitionName));
            String name = transitionName + TOKEN_NAME_SEPARATOR + System.currentTimeMillis();
            childTokens.add(new CustomToken(token, name));
        }
        token.fork();
        token.addLog((ProcessLog)new NodeLog((Node)this, token.getNodeEnter(), new Date()));
        for (CustomToken childToken : childTokens) {
            childToken.start();
        }
    }

    public Transition addLeavingTransition(Transition leavingTransition) {
        if (leavingTransition.getName() == null) {
            throw new RuntimeException("Fork (" + this.name + ") must have named transitions");
        }
        return super.addLeavingTransition(leavingTransition);
    }
}

