/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DefaultProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.IEngineDriver;
import com.tandbergtv.workflow.driver.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.event.MessageRejectedEvent;
import com.tandbergtv.workflow.driver.event.TaskCompleteEvent;
import com.tandbergtv.workflow.driver.event.TaskCreatedEvent;
import com.tandbergtv.workflow.driver.event.TaskUpdateEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.search.SearchService;
import com.tandbergtv.workflow.driver.search.TokenSearchService;
import com.tandbergtv.workflow.driver.service.CacheService;
import com.tandbergtv.workflow.driver.service.HibernatePersistenceService;
import com.tandbergtv.workflow.driver.service.ICacheService;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.service.ITimerService;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.driver.service.ProcessManager;
import com.tandbergtv.workflow.driver.service.TimerManager;
import com.tandbergtv.workflow.driver.template.TemplateLoaderService;
import com.tandbergtv.workflow.resourcemanager.event.QueueOrderChangedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAcquiredEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAllocationFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceRequestRejectedEvent;
import java.lang.management.ManagementFactory;
import java.util.ResourceBundle;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.management.ManagementService;
import org.apache.log4j.Logger;

public final class EngineDriver
implements IEngineDriver,
IColleague {
    private static EngineDriver instance;
    private boolean initialized;
    private static final String SERVICE_NAME = "Engine Driver";
    private static final Logger logger;

    private EngineDriver() {
        DefaultMediator.getInstance().register(this);
    }

    public static synchronized EngineDriver getInstance() {
        if (instance == null) {
            instance = new EngineDriver();
        }
        return instance;
    }

    @Override
    public void init() {
        if (this.initialized) {
            logger.warn((Object)"Engine driver has already initialized");
            return;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".driver");
        ManagementService.registerMBeans((CacheManager)CacheManager.getInstance(), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.addService(new CacheService(bundle.getString("driver.cache.name")));
        this.addService(new SearchService());
        this.addService(new TemplateLoaderService());
        this.addService(new TimerManager());
        this.addService(new TokenSearchService());
        this.addService(new HibernatePersistenceService());
        this.initialized = true;
        logger.info((Object)"Driver initialized");
    }

    @Override
    public void postInit() {
        this.addService(new ProcessManager());
    }

    @Override
    public void destroy() {
        if (!this.initialized) {
            logger.warn((Object)"But I haven't been inited!");
            return;
        }
        DefaultMediator.getInstance().unregister(this);
        this.removeService(IPersistenceService.class);
        this.removeService(ITimerService.class);
        this.removeService(ITokenSearchService.class);
        this.removeService(IProcessSearchService.class);
        this.removeService(IProcessManagerService.class);
        this.removeService(ICacheService.class);
        this.removeService(ITemplateLoaderService.class);
        CacheManager.getInstance().shutdown();
        logger.info((Object)"Driver destroyed");
    }

    @Override
    public void start() {
        this.init();
    }

    @Override
    public void stop() {
        this.destroy();
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    public void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    @Override
    public IProgressTrackingStrategy getProgressTrackingStrategy() {
        return DefaultProgressTrackingStrategy.getInstance();
    }

    private IProcessManagerService getProcessManagerService() {
        return ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    private void save(WorkflowProcess process) {
        ServiceRegistry.getDefault().lookup(IPersistenceService.class).save(process);
    }

    @Override
    public String getColleagueName() {
        return this.getClass().getName();
    }

    @Override
    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    @Override
    public void receive(WorkflowEvent event) {
        Object source = event.getSource();
        if (source == this) {
            return;
        }
        IProgressTrackingStrategy progressTracker = DefaultProgressTrackingStrategy.getInstance();
        if (event instanceof WorkflowProcessEvent) {
            WorkflowProcessEvent e = (WorkflowProcessEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            WorkflowProcess process = token.getProcessInstance();
            logger.debug((Object)(token + ", event " + (Object)((Object)e.getType())));
            switch (e.getType()) {
                case RESUMED: {
                    if (token.isRoot()) {
                        this.cache(process);
                    }
                    this.save(process);
                    break;
                }
                case STARTED: {
                    if (token.isRoot()) {
                        this.cache(process);
                    }
                    this.save(process);
                    break;
                }
                case BRANCHED: 
                case JOINED: 
                case DEQUEUED: 
                case ACQUIRED: 
                case RELEASED: 
                case DELETED: {
                    this.save(process);
                    break;
                }
                case QUEUED: {
                    progressTracker.setComplete(token);
                    this.save(process);
                    break;
                }
                case STOPPED: {
                    this.save(process);
                    if (!token.isRoot()) break;
                    this.remove(process);
                    break;
                }
                case PAUSING: 
                case CANCELLING: {
                    if (!token.isRoot()) break;
                    this.save(process);
                    break;
                }
                case PAUSED: 
                case CANCELLED: {
                    this.getTimerService().deleteTimer(token);
                    this.save(process);
                    if (!token.isRoot()) break;
                    this.remove(process);
                    break;
                }
                case FAILED: {
                    this.getTimerService().deleteTimer(token);
                    this.save(process);
                    if (token.isRoot()) {
                        this.remove(process);
                    }
                    try {
                        if (token.isResumeAfterFail()) {
                            logger.debug((Object)(token + " indicates that it wants to be retried"));
                            token.setResumeAfterFail(false);
                            this.getProcessManagerService().resume(token);
                        }
                    }
                    catch (DriverException t) {
                        logger.warn((Object)(process + " failed to resume"), (Throwable)t);
                    }
                    break;
                }
            }
        } else if (event instanceof TaskUpdateEvent) {
            TaskUpdateEvent e = (TaskUpdateEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            if (token.getStatus() == ProcessStatus.BUSY || token.getStatus() == ProcessStatus.RUNNING) {
                String percent = e.getPercentComplete();
                String name = token.getNode().getName();
                logger.info((Object)(token + " (" + name + ") " + percent + "% complete"));
                progressTracker.setPercentComplete(token, percent);
            }
        } else if (event instanceof TaskCreatedEvent) {
            TaskCreatedEvent e = (TaskCreatedEvent)event;
            WorkflowProcess process = e.getProcess();
            this.save(process);
        } else if (event instanceof TaskCompleteEvent) {
            TaskCompleteEvent e = (TaskCompleteEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            String name = token.getNode().getName();
            if (token.getStatus() == ProcessStatus.QUEUED && e.hasFailed()) {
                logger.info((Object)(token + " has failed at (" + name + ")"));
                token.fail();
            } else {
                logger.info((Object)(token + " (" + name + ") completed"));
            }
        } else if (event instanceof ResourceAcquiredEvent) {
            ResourceAcquiredEvent e = (ResourceAcquiredEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            if (token.getStatus() == ProcessStatus.QUEUED) {
                logger.debug((Object)(token + " got resource"));
                this.getProcessManagerService().dequeue(token);
            } else {
                logger.warn((Object)(token + " spurious resource grant"));
            }
        } else if (event instanceof ResourceRequestRejectedEvent) {
            ResourceRequestRejectedEvent e = (ResourceRequestRejectedEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            WorkflowProcess process = token.getProcessInstance();
            if (token.getStatus() == ProcessStatus.QUEUED) {
                logger.warn((Object)("Failing workorder [" + process.getId() + "] due to mismatching protection keys"));
                token.fail();
            } else {
                logger.warn((Object)(token + " - resource request was rejected"));
            }
        } else if (event instanceof QueueOrderChangedEvent) {
            QueueOrderChangedEvent e = (QueueOrderChangedEvent)event;
            CustomToken token = e.getToken();
            WorkflowProcess process = token.getProcessInstance();
            ProcessPriority priority = e.getPriority();
            logger.debug((Object)(token + ", event QUEUE REORDER " + (Object)((Object)priority)));
            if (process.getPriority().equals((Object)priority)) {
                return;
            }
            process.setPriority(priority);
            this.save(process);
            for (CustomToken t : process.findAllTokens()) {
                if (t.equals(token)) continue;
                DefaultMediator.getInstance().sendAsync(new WorkflowProcessEvent(this, process, t, WorkflowProcessEventType.PRIORITY_CHANGED));
            }
        } else if (event instanceof ResourceFailedEvent) {
            ResourceFailedEvent e = (ResourceFailedEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            WorkflowProcess process = token.getProcessInstance();
            logger.debug((Object)("[" + process.getId() + "] event RESOURCE FAILURE (" + token.getNode().getName() + ")"));
            token.setResumeAfterFail(true);
            token.abort();
        } else if (event instanceof ResourceAllocationFailedEvent) {
            ResourceAllocationFailedEvent e = (ResourceAllocationFailedEvent)event;
            DefaultMediator.getInstance().sendAsync(new MessageRejectedEvent(this, e.getToken(), e.getMessage()));
        }
    }

    public ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private void cache(WorkflowProcess process) {
        this.getCache().add(Long.valueOf(process.getId()), process);
        logger.debug((Object)(process.getRootToken() + ", added to cache"));
    }

    private void remove(WorkflowProcess process) {
        this.getCache().remove(Long.valueOf(process.getId()));
        logger.debug((Object)(process.getRootToken() + ", removed from cache"));
    }

    private ITimerService getTimerService() {
        return ServiceRegistry.getDefault().lookup(ITimerService.class);
    }

    static {
        logger = Logger.getLogger(EngineDriver.class);
    }
}

