/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSInvisibleTemplate;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.HibernateContext;
import com.tandbergtv.workflow.driver.search.ISearchHelper;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.TemplateParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.search.WorkflowProcessSearchHelper;
import com.tandbergtv.workflow.driver.service.ICacheService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class SearchService
implements IProcessSearchService {
    public static final String SERVICE_NAME = "Process Search Service";

    @Override
    public int count(SearchCriteria criteria) {
        return this.getSearchHelper().count(criteria);
    }

    @Override
    public int count(final ProcessStatus status) {
        return this.count(new SearchCriteria(){
            {
                this.addParameter(new ValueParameter("status", SearchType.PROCESSSTATUS, (Object)status));
            }
        });
    }

    @Override
    public int count(ProcessStatus status, Date cutOffDate) {
        SearchCriteria criteria = new SearchCriteria();
        ValueParameter parameter = new ValueParameter("status", SearchType.PROCESSSTATUS, (Object)status);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(cutOffDate);
        RangeParameter rangeParam = new RangeParameter("start", SearchType.DATE, false);
        rangeParam.setFrom(date);
        criteria.addParameter(parameter);
        criteria.addParameter(rangeParam);
        return this.count(criteria);
    }

    @Override
    public int count(List<ProcessStatus> statuslist) {
        final ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        for (ProcessStatus status : statuslist) {
            parameter.addValue((Object)status);
        }
        return this.count(new SearchCriteria(){
            {
                this.addParameter(parameter);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(WorkflowTemplate template, ProcessStatus ... status) {
        Session session = null;
        int count = 0;
        try {
            session = HibernateContext.getContext().openSession();
            Criteria criteria = session.createCriteria(WorkflowProcess.class).add(Restrictions.in((String)"status", (Object[])status)).add((Criterion)Restrictions.eq((String)"active", (Object)true)).add((Criterion)Restrictions.eq((String)"processDefinition.id", (Object)template.getId())).setProjection(Projections.rowCount()).createCriteria("processDefinition").add(Restrictions.sqlRestriction((String)"processDefinitionTypeId=2"));
            count = (Integer)criteria.uniqueResult();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return count;
    }

    @Override
    public List<WorkflowProcess> findAllByStatus(final ProcessStatus status) {
        return this.findAllByStatus((List<ProcessStatus>)new ArrayList<ProcessStatus>(){
            {
                this.add(status);
            }
        });
    }

    @Override
    public List<WorkflowProcess> findAllByStatus(List<ProcessStatus> statuslist) {
        SearchCriteria criteria = new SearchCriteria();
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        for (ProcessStatus status : statuslist) {
            parameter.addValue((Object)status);
        }
        criteria.addParameter(parameter);
        List<WorkflowProcess> list = this.search(criteria);
        criteria.addParameter(new TemplateParameter(WFSInvisibleTemplate.class.getName()));
        list.addAll(this.search(criteria));
        return list;
    }

    @Override
    public List<WorkflowProcess> findAllByStatus(ProcessStatus ... statuslist) {
        ArrayList<ProcessStatus> list = new ArrayList<ProcessStatus>();
        for (ProcessStatus status : statuslist) {
            list.add(status);
        }
        return this.findAllByStatus(list);
    }

    @Override
    public List<WorkflowProcess> search(SearchCriteria searchCriteria) {
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
        ArrayList<WorkflowProcess> processes = new ArrayList<WorkflowProcess>();
        for (WorkflowProcess process : this.getSearchHelper().search(searchCriteria)) {
            Long key = process.getId();
            WorkflowProcess cached = (WorkflowProcess)cache.get(key);
            if (cached != null) {
                processes.add(cached);
                continue;
            }
            processes.add(process);
        }
        return processes;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private ISearchHelper getSearchHelper() {
        return new WorkflowProcessSearchHelper();
    }
}

