/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.dao.HibernateContext;
import com.tandbergtv.workflow.driver.search.ISearchHelper;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.TemplateParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class WorkflowProcessSearchHelper
implements ISearchHelper {
    private static final Logger logger = Logger.getLogger(WorkflowProcessSearchHelper.class);
    public static final String PROCESS_ALIAS = "process";
    public static final String WORKFLOW_TEMPLATE_ALIAS = "template";
    public static final String TOKEN_ALIAS = "token";
    public static final String RESOURCEUSER_ALIAS = "resourceuser";
    public static final String RESOURCE_ALIAS = "resource";
    private static final String ORDER_BY = " ORDER BY ";
    private static final String NON_ARCHIVED_WHERE_CLAUSE = " AND process.active = true";
    private static final String WORKORDER_TEMPLATE_WHERE_CLAUSE = "process.processDefinition.id = template.id";
    private static final String BASIC_COUNT_CLAUSE = "Select Count(Distinct process) from WorkflowProcess process";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkflowProcess> search(SearchCriteria searchCriteria) {
        List<WorkflowProcess> processes = null;
        Session session = HibernateContext.getContext().openSession();
        try {
            String queryString = null;
            queryString = searchCriteria.count() == 0 ? this.getSearchAllQuery(searchCriteria) : this.buildQuery(searchCriteria);
            logger.debug((Object)("Executing Query:" + queryString));
            if (queryString != null) {
                Query query = session.createQuery(queryString);
                if (searchCriteria.getStartingRecordNumber() != 0) {
                    query.setFirstResult(searchCriteria.getStartingRecordNumber());
                }
                if (searchCriteria.getRecordsCount() != 0) {
                    query.setMaxResults(searchCriteria.getRecordsCount());
                }
                List queryResult = query.list();
                processes = this.getProcessListFromQueryResult(queryResult);
            }
            logger.debug((Object)("Search Result:" + processes.size() + " Processes"));
        }
        finally {
            session.close();
        }
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(SearchCriteria searchCriteria) {
        int count = 0;
        Session session = HibernateContext.getContext().openSession();
        try {
            String queryString = this.buildCountQuery(searchCriteria);
            if (queryString != null) {
                logger.debug((Object)("Executing Query:" + queryString));
                List queryResult = session.createQuery(queryString).list();
                count = Integer.parseInt(queryResult.get(0).toString());
                logger.debug((Object)("Received count:" + count));
            }
        }
        finally {
            session.close();
        }
        return count;
    }

    private List<WorkflowProcess> getProcessListFromQueryResult(List queryResult) {
        ArrayList<WorkflowProcess> processes = new ArrayList<WorkflowProcess>();
        for (Object objects : queryResult) {
            WorkflowProcess process = null;
            process = objects instanceof WorkflowProcess ? (WorkflowProcess)objects : (WorkflowProcess)((Object[])objects)[0];
            processes.add(process);
        }
        return processes;
    }

    private String buildCountQuery(SearchCriteria searchCriteria) {
        if (searchCriteria.count() == 0) {
            return this.getFromClause(searchCriteria, true) + " WHERE " + this.getBasicWhereClause();
        }
        return this.getFromClause(searchCriteria, true) + this.getWhereClause(searchCriteria);
    }

    private String getSearchAllQuery(SearchCriteria searchCriteria) {
        String orderClause = this.getOrderClause(searchCriteria);
        String fromClause = this.getFromClause(searchCriteria, false);
        return fromClause + " WHERE " + this.getBasicWhereClause() + (orderClause == null ? "" : orderClause);
    }

    private String buildQuery(SearchCriteria searchCriteria) {
        String orderClause;
        String query = this.getFromClause(searchCriteria, false);
        if (query != null) {
            query = query + this.getWhereClause(searchCriteria);
        }
        if ((orderClause = this.getOrderClause(searchCriteria)) != null) {
            query = query + orderClause;
        }
        return query;
    }

    private String getSelectClause(SearchCriteria searchCriteria) {
        String selectClause = "Select Distinct process";
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.getSortingOrder() == null) continue;
            if (param.isVarInstance()) {
                selectClause = selectClause + ", " + param.alias;
                continue;
            }
            if (param.getFieldName().indexOf(".") == -1) continue;
            selectClause = selectClause + ", " + param.alias + "." + param.fieldName;
        }
        return selectClause;
    }

    private String getFromClause(SearchCriteria searchCriteria, boolean countQuery) {
        String fromPart;
        String fromClause = !countQuery ? " from WorkflowProcess process" : BASIC_COUNT_CLAUSE;
        String templateClassName = null;
        int objectCount = 1;
        if (!countQuery) {
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (!param.isVarInstance() || !(param instanceof SortParameter)) continue;
                fromPart = param.getPartialFromClause(objectCount++);
                fromClause = fromClause + (fromPart.equals("") ? "" : fromPart);
            }
        }
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.isVarInstance() && param instanceof SortParameter) continue;
            if (param instanceof TemplateParameter) {
                templateClassName = ((TemplateParameter)param).getClassName();
                continue;
            }
            fromPart = param.getPartialFromClause(objectCount++);
            fromClause = fromClause + (fromPart.equals("") ? "" : "," + fromPart);
        }
        if (templateClassName == null) {
            templateClassName = this.getDefaultTemplateClass().getName();
        }
        fromClause = fromClause + ", " + templateClassName + " " + WORKFLOW_TEMPLATE_ALIAS;
        if (!countQuery) {
            return this.getSelectClause(searchCriteria) + fromClause;
        }
        return fromClause;
    }

    private Class getDefaultTemplateClass() {
        return WorkflowTemplate.class;
    }

    private String getWhereClause(SearchCriteria searchCriteria) {
        String whereClause = "";
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            String partialWhere;
            if (param instanceof TemplateParameter || (partialWhere = param.getPartialWhereClause()).equals("")) continue;
            whereClause = whereClause + (whereClause.trim() == "" ? " WHERE " : " AND ");
            whereClause = whereClause + partialWhere;
        }
        whereClause = whereClause + (whereClause.trim() == "" ? " WHERE " : " AND ");
        whereClause = whereClause + this.getBasicWhereClause();
        return whereClause;
    }

    private String getBasicWhereClause() {
        String whereClause = WORKORDER_TEMPLATE_WHERE_CLAUSE;
        whereClause = whereClause + NON_ARCHIVED_WHERE_CLAUSE;
        return whereClause;
    }

    private String getOrderClause(SearchCriteria searchCriteria) {
        String orderClause = "";
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.getSortingOrder() == null) continue;
            orderClause = !orderClause.equals("") ? orderClause + "," : ORDER_BY;
            orderClause = orderClause + param.getAlias() + "." + param.getSortingColumn();
            orderClause = orderClause + (param.getSortingOrder() == SortingOrder.ASCENDING ? " ASC" : " DESC");
        }
        return orderClause;
    }
}

