/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.service;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.HibernateContext;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.service.ICacheService;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class HibernatePersistenceService
implements IPersistenceService {
    private ICacheService<WorkflowProcess> cache = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    private static final Logger logger = Logger.getLogger(HibernatePersistenceService.class);
    private static final String SERVICE_NAME = "Process Persistence";

    public ICacheService<WorkflowProcess> getCache() {
        return this.cache;
    }

    public void setCache(ICacheService<WorkflowProcess> cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowProcess get(Serializable id) {
        WorkflowProcess process = this.cache.get(id);
        if (process != null) {
            return process;
        }
        Session session = this.getSession();
        try {
            process = (WorkflowProcess)session.load(WorkflowProcess.class, id);
        }
        finally {
            this.closeSession(session);
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomToken getToken(Serializable id) {
        CustomToken token = null;
        for (Serializable key : this.cache.getKeys()) {
            WorkflowProcess process = this.cache.get(key);
            if (process == null) continue;
            for (CustomToken t : process.findAllTokens()) {
                if (t.getId() != ((Long)id).longValue()) continue;
                return t;
            }
        }
        Session session = this.getSession();
        try {
            token = (CustomToken)session.load(CustomToken.class, id);
        }
        finally {
            this.closeSession(session);
        }
        return token;
    }

    @Override
    public Serializable create(WorkflowProcess process) {
        this.save(process);
        return Long.valueOf(process.getId());
    }

    @Override
    public void save(WorkflowProcess process) {
        Session session = this.getSession();
        Transaction t = null;
        process.lock();
        try {
            t = session.beginTransaction();
            session.saveOrUpdate((Object)process);
            t.commit();
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            logger.error((Object)("Failed to save the process " + process), (Throwable)e);
            throw new DriverRuntimeException("Failed to save the process", e);
        }
        finally {
            this.closeSession(session);
            process.unlock();
        }
    }

    @Override
    public void save(CustomToken token) {
        this.save(token.getProcessInstance());
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private Session getSession() {
        return HibernateContext.getContext().openSession();
    }

    private void closeSession(Session session) {
        if (session != null) {
            session.close();
        }
    }
}

