/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.service;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.EngineDriverProperties;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.plugin.ICreateDelegate;
import com.tandbergtv.workflow.driver.service.ICacheService;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ISchedulerService;
import com.tandbergtv.workflow.driver.service.Scheduler;
import com.tandbergtv.workflow.util.DatatypeConverter;
import com.tandbergtv.workflow.util.TypeConversionException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.taskmgmt.def.Task;

public class ProcessManager
implements IProcessManagerService {
    private ISchedulerService<CustomToken> scheduler;
    private ISchedulerService<Void> globalScheduler = new Scheduler<Void>("Global Scheduler", 1, 1);
    private static final String SERVICE_NAME = "Process Manager";
    private static final Logger logger = Logger.getLogger(ProcessManager.class);

    public ProcessManager() {
        this.scheduler = new Scheduler<CustomToken>("Token Scheduler");
    }

    @Override
    public CustomToken create(ProcessDefinition template, Map<String, Object> parameters) throws DriverException {
        return this.create(template, ProcessPriority.NORMAL, parameters);
    }

    @Override
    public CustomToken create(ProcessDefinition template, ProcessPriority priority, Map<String, Object> parameters) throws DriverException {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        DatatypeConverter converter = DatatypeConverter.getInstance();
        for (TaskVariable variable : this.getStartTaskVariables(template)) {
            Datatype datatype = variable.getDatatype();
            String key = variable.getVariableName();
            Object value = parameters.get(key);
            if (value == null || value instanceof String && ((String)value).trim().length() == 0) {
                if (variable.isRequired()) {
                    throw new DriverException("Required variable (" + key + ") is not defined");
                }
                value = this.getDefaultValue(datatype);
            }
            if (value == null) continue;
            try {
                copy.put(key, converter.convert(value, datatype));
            }
            catch (TypeConversionException e) {
                throw new DriverException("Input value data type mismatch", e);
            }
        }
        ICreateDelegate delegate = (ICreateDelegate)this.getCallback("driver.create.delegate");
        delegate.create(template, parameters);
        WorkflowProcess process = new WorkflowProcess(template, priority);
        for (String name : copy.keySet()) {
            process.getContextInstance().setVariable(name, copy.get(name));
        }
        ServiceRegistry.getDefault().lookup(IPersistenceService.class).create(process);
        return process.getRootToken();
    }

    @Override
    public Future<CustomToken> start(final CustomToken token) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    if (ProcessManager.this.getIsHalted()) {
                        token.suspend();
                    } else {
                        token.start();
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)token, t);
                }
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> pause(final CustomToken token) {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                token.suspend();
                return token;
            }
        });
    }

    @Override
    public Collection<Future<CustomToken>> pause(Collection<CustomToken> tokens) {
        ArrayList<Future<CustomToken>> futures = new ArrayList<Future<CustomToken>>();
        for (CustomToken token : tokens) {
            futures.add(this.pause(token));
        }
        return futures;
    }

    @Override
    public Future<CustomToken> resume(final CustomToken token) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    token.resume();
                }
                catch (Throwable t) {
                    logger.error((Object)token, t);
                }
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> restart(final Serializable id) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                ServiceRegistry registry = ServiceRegistry.getDefault();
                WorkflowProcess process = registry.lookup(IPersistenceService.class).get(id);
                WorkflowTemplate template = process.getProcessDefinition();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                for (TaskVariable variable : ProcessManager.this.getStartTaskVariables(template)) {
                    String name = variable.getVariableName();
                    Object value = process.getContextInstance().getVariable(name);
                    parameters.put(name, value);
                }
                CustomToken token = ProcessManager.this.create(template, process.getPriority(), parameters);
                ProcessManager.this.start(token);
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> dequeue(final CustomToken token) {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    token.dequeue();
                }
                catch (Throwable t) {
                    logger.error((Object)token, t);
                }
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> cancel(final CustomToken token) {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                token.cancel();
                return token;
            }
        });
    }

    @Override
    public Collection<Future<CustomToken>> cancel(Collection<CustomToken> tokens) {
        ArrayList<Future<CustomToken>> futures = new ArrayList<Future<CustomToken>>();
        for (CustomToken token : tokens) {
            futures.add(this.cancel(token));
        }
        return futures;
    }

    @Override
    public Future<CustomToken> delete(final WorkflowProcess process) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                process.delete();
                return process.getRootToken();
            }
        });
    }

    @Override
    public Future<Void> pause() throws DriverException {
        return this.globalScheduler.schedule(new Callable<Void>(){

            @Override
            public Void call() throws DriverException {
                ProcessManager.this.setIsHalted(true);
                IProcessSearchService service = ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
                for (WorkflowProcess process : service.findAllByStatus(ProcessStatus.ACTIVE, ProcessStatus.BRANCHED, ProcessStatus.QUEUED)) {
                    ProcessManager.this.pause(process.getRootToken());
                }
                return null;
            }
        });
    }

    @Override
    public Future<Void> resume() throws DriverException {
        return this.globalScheduler.schedule(new Callable<Void>(){

            @Override
            public Void call() throws DriverException {
                ProcessManager.this.setIsHalted(false);
                ServiceRegistry registry = ServiceRegistry.getDefault();
                List<WorkflowProcess> processes = registry.lookup(IProcessSearchService.class).findAllByStatus(ProcessStatus.PAUSED);
                Collections.sort(processes, new Comparator<WorkflowProcess>(){

                    @Override
                    public int compare(WorkflowProcess p1, WorkflowProcess p2) {
                        if (p1.getPriority() == p2.getPriority()) {
                            return p2.getStart().getTime() > p1.getStart().getTime() ? -1 : (p2.getStart().getTime() == p1.getStart().getTime() ? 0 : 1);
                        }
                        return p2.getPriority().compareTo(p1.getPriority());
                    }
                });
                for (WorkflowProcess process : processes) {
                    ProcessManager.this.resume(process.getRootToken());
                }
                return null;
            }
        });
    }

    @Override
    public void setPriority(WorkflowProcess process, ProcessPriority priority) {
        process.setPriority(priority);
        CustomToken rootToken = process.getRootToken();
        DefaultMediator.getInstance().sendAsync(new WorkflowProcessEvent(this, process, rootToken, WorkflowProcessEventType.PRIORITY_CHANGED));
        for (CustomToken token : rootToken.getActiveChildTokens()) {
            DefaultMediator.getInstance().sendAsync(new WorkflowProcessEvent(this, process, token, WorkflowProcessEventType.PRIORITY_CHANGED));
        }
    }

    @Override
    public void start() {
        logger.info((Object)"Starting process manager service...");
        final IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync(new ServiceEvent(this, ServiceEvents.STARTING));
        this.globalScheduler.start();
        this.scheduler.start();
        this.globalScheduler.schedule(new CrashRecoveryThread());
        this.globalScheduler.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                mediator.sendAsync(new ServiceEvent(ProcessManager.this, ServiceEvents.STARTED));
                logger.info((Object)"Process manager service started");
                return null;
            }
        });
    }

    @Override
    public void stop() {
        DefaultMediator.getInstance().sendAsync(new ServiceEvent(this, ServiceEvents.STOPPING));
        this.scheduler.stop();
        this.globalScheduler.stop();
        DefaultMediator.getInstance().sendAsync(new ServiceEvent(this, ServiceEvents.STOPPED));
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    private Future<CustomToken> schedule(Callable<CustomToken> callable) {
        Future<CustomToken> future = null;
        try {
            future = this.scheduler.schedule(callable);
        }
        catch (RejectedExecutionException e) {
            logger.warn((Object)("Could not add scheduled task to " + this.scheduler.getServiceName()), (Throwable)e);
        }
        return future;
    }

    private boolean getIsHalted() {
        EngineDriverProperties properties = EngineDriverProperties.getInstance();
        String haltedValue = properties.getProperty(EngineDriverProperties.DRIVER_HALTED_PROPERTY);
        return Boolean.parseBoolean(haltedValue);
    }

    private void setIsHalted(boolean isHalted) {
        EngineDriverProperties properties = EngineDriverProperties.getInstance();
        String value = Boolean.toString(isHalted);
        properties.setProperty(EngineDriverProperties.DRIVER_HALTED_PROPERTY, value);
        try {
            properties.save();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to save the halted state", (Throwable)e);
        }
    }

    private Object getDefaultValue(Datatype type) {
        Object value = null;
        switch (type) {
            case STRING: {
                value = "";
                break;
            }
            case BOOLEAN: {
                value = Boolean.FALSE;
                break;
            }
            case INT: {
                value = 0;
                break;
            }
            case FILE: {
                value = "";
                break;
            }
            case URL: {
                value = "";
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private List<TaskVariable> getStartTaskVariables(ProcessDefinition template) {
        Task t = template.getTaskMgmtDefinition().getStartTask();
        if (t == null) {
            return new ArrayList<TaskVariable>();
        }
        return t.getTaskController().getVariableAccesses();
    }

    private Object getCallback(String id) {
        Object callback = null;
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".service");
        String className = bundle.getString(id);
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            callback = clazz.newInstance();
        }
        catch (Exception e) {
            throw new DriverRuntimeException("Failed to load delegate", e);
        }
        return callback;
    }

    private final class CrashRecoveryThread
    implements Callable<Void> {
        private CrashRecoveryThread() {
        }

        @Override
        public Void call() throws Exception {
            IMediator mediator = DefaultMediator.getInstance();
            Collection<WorkflowProcess> processes = this.search();
            for (WorkflowProcess process : processes) {
                for (CustomToken token : process.findAllTokens()) {
                    if (token.getStatus() != ProcessStatus.QUEUED) continue;
                    this.cache(process);
                    mediator.sendAsync(new WorkflowProcessEvent(this, process, token, WorkflowProcessEventType.CACHE_INITED));
                }
            }
            for (WorkflowProcess process : processes) {
                ResourceGroupAware aware;
                final CustomToken token = process.getRootToken();
                if (token.getStatus() == ProcessStatus.BRANCHED) {
                    this.cache(process);
                }
                if (ResourceGroupAware.class.isAssignableFrom(token.getCurrentNode().getClass()) && (aware = (ResourceGroupAware)token.getCurrentNode()).getResourceGroupID() != null) {
                    token.recover();
                    continue;
                }
                ProcessManager.this.schedule(new Callable<CustomToken>(){

                    @Override
                    public CustomToken call() {
                        try {
                            token.recover();
                        }
                        catch (Throwable t) {
                            logger.warn((Object)(token + ", failed to recover"), t);
                        }
                        return token;
                    }
                });
            }
            return null;
        }

        private Collection<WorkflowProcess> search() {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IProcessSearchService service = registry.lookup(IProcessSearchService.class);
            return service.findAllByStatus(ProcessStatus.ACTIVE, ProcessStatus.BRANCHED, ProcessStatus.QUEUED);
        }

        private void cache(WorkflowProcess process) {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            ICacheService cache = (ICacheService)registry.lookup("Process Cache");
            cache.add(Long.valueOf(process.getId()), process);
        }
    }
}

