/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.service;

import com.tandbergtv.workflow.driver.TokenTimer;
import com.tandbergtv.workflow.driver.service.ISchedulerService;
import com.tandbergtv.workflow.driver.service.ITimerService;
import com.tandbergtv.workflow.driver.service.Scheduler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class TimerManager
implements ITimerService {
    private ISchedulerService<Void> scheduler = new Scheduler<Void>("Timer Pool", 1, 1);
    private Map<Token, Future<Void>> futures = new HashMap<Token, Future<Void>>();
    private static final String SERVICE_NAME = "Timer Manager";
    private static final Logger logger = Logger.getLogger(TimerManager.class);
    private static final Lock timerlock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimer(TokenTimer timer) {
        long delay = timer.getTimer().getDueDate().getTime() - System.currentTimeMillis();
        timerlock.lock();
        try {
            Future<Void> future = this.scheduler.schedule(timer, delay);
            this.futures.put(timer.getToken(), future);
        }
        finally {
            timerlock.unlock();
        }
        logger.info((Object)(timer.getToken() + " added timer, total " + this.scheduler.count()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTimer(Token token) {
        timerlock.lock();
        try {
            Future<Void> future = this.futures.get(token);
            if (future != null) {
                future.cancel(true);
                this.futures.remove(token);
                this.scheduler.purge();
            }
        }
        finally {
            timerlock.unlock();
        }
        logger.info((Object)(token + " deleted timer, total " + this.scheduler.count()));
    }

    @Override
    public void start() {
        this.scheduler.start();
    }

    @Override
    public void stop() {
        this.scheduler.stop();
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }
}

