/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ISchedulerService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.service.Scheduler;
import com.tandbergtv.workflow.driver.template.IArchivalService;
import com.tandbergtv.workflow.driver.template.VersionBasedArchivalStrategy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ArchivalService
implements IArchivalService {
    private ISchedulerService<Void> scheduler = new Scheduler<Void>("Version Service", 1, 1);
    private static final String SERVICE_NAME = "Version Service";
    private static final long ONE_MINUTE_MILLIS = 60000L;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private long period;
    private long delay;
    private long runs;
    private static final Logger logger = Logger.getLogger(ArchivalService.class);

    public ArchivalService() {
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".service");
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String timeofday = bundle.getString("version.service.timeofday");
        try {
            long time = formatter.parse(timeofday).getTime();
            long now = formatter.parse(formatter.format(new Date())).getTime();
            this.delay = time - now;
            if (this.delay < 0L) {
                this.delay += 86400000L;
            }
            logger.debug((Object)(time / 60000L + ", " + now / 60000L));
        }
        catch (ParseException e) {
            this.delay = 0L;
        }
        try {
            this.period = Long.parseLong(bundle.getString("version.service.period")) * 60000L;
        }
        catch (Exception e) {
            this.period = 86400000L;
        }
        logger.info((Object)("Starting at " + timeofday + ", period = " + this.period / 3600000L + " hours"));
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public void start() {
        this.scheduler.start();
        this.run();
    }

    @Override
    public void stop() {
        this.scheduler.stop();
    }

    @Override
    public void run() {
        ++this.runs;
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ServiceRegistry registry = ServiceRegistry.getDefault();
                ITemplateLoaderService loader = registry.lookup(ITemplateLoaderService.class);
                IProcessSearchService search = registry.lookup(IProcessSearchService.class);
                new VersionBasedArchivalStrategy(loader, search).archive();
            }
        }, this.delay, this.period);
    }

    @Override
    public void run(final WorkflowTemplate template) {
        this.scheduler.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServiceRegistry registry = ServiceRegistry.getDefault();
                ITemplateLoaderService loader = registry.lookup(ITemplateLoaderService.class);
                IProcessSearchService search = registry.lookup(IProcessSearchService.class);
                new VersionBasedArchivalStrategy(loader, search).archive(template);
                return null;
            }
        });
    }
}

