/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.licensing.LicenseKeyConstants;
import com.tandbergtv.workflow.core.licensing.LicenseManager;
import com.tandbergtv.workflow.dao.HibernateContext;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.service.CacheService;
import com.tandbergtv.workflow.driver.service.ICacheService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.ArchivalService;
import com.tandbergtv.workflow.driver.template.IArchivalService;
import com.tandbergtv.workflow.driver.template.SelectorExistsException;
import java.io.Serializable;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class TemplateLoaderService
implements ITemplateLoaderService {
    private static final String SERVICE_NAME = "Template Loader Service";
    private static final Logger logger = Logger.getLogger(TemplateLoaderService.class);
    private ICacheService<WorkflowTemplate> cache;
    private IArchivalService service;
    private static final ReadWriteLock cachelock = new ReentrantReadWriteLock();

    public TemplateLoaderService() {
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".service");
        int size = Integer.parseInt(bundle.getString("template.cache.size"));
        String name = bundle.getString("template.cache.name");
        this.cache = new CacheService<WorkflowTemplate>(name, size);
        this.service = new ArchivalService();
    }

    @Override
    public List<String> getAllProcessDefinitionNames() {
        List<WorkflowTemplate> templates = this.getAllProcessDefinitions();
        Collections.sort(templates, new TemplateComparator());
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (WorkflowTemplate template : templates) {
            String name = template.getName();
            if (map.containsKey(name)) continue;
            map.put(name, template.getVersion());
            names.add(template.getFullName());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkflowTemplate> getAllProcessDefinitions() {
        ArrayList<WorkflowTemplate> templates = new ArrayList<WorkflowTemplate>();
        cachelock.readLock().lock();
        try {
            for (Serializable key : this.getCache().getKeys()) {
                templates.add(this.getCache().get(key));
            }
        }
        finally {
            cachelock.readLock().unlock();
        }
        return templates;
    }

    @Override
    public WorkflowTemplate getProcessDefinition(Serializable id) {
        return this.getCache().get(id);
    }

    @Override
    public WorkflowTemplate getProcessDefinitionByName(String name) {
        List<WorkflowTemplate> templates = this.getAllProcessDefinitions();
        Collections.sort(templates, new TemplateComparator());
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getFullName())) continue;
            return template;
        }
        return null;
    }

    @Override
    public List<WorkflowTemplate> getLatestTemplates() {
        List<WorkflowTemplate> templates = this.getAllProcessDefinitions();
        Collections.sort(templates, new TemplateComparator());
        ArrayList<WorkflowTemplate> list = new ArrayList<WorkflowTemplate>();
        HashSet<String> names = new HashSet<String>();
        for (WorkflowTemplate template : templates) {
            String name = template.getName();
            if (names.contains(name)) continue;
            names.add(name);
            list.add(template);
        }
        return list;
    }

    @Override
    public List<WorkflowTemplate> getPreviousVersions(WorkflowTemplate template) {
        LinkedList<WorkflowTemplate> templates = new LinkedList<WorkflowTemplate>();
        int version = template.getVersion();
        for (WorkflowTemplate t : this.getAllProcessDefinitions()) {
            if (!t.getName().equals(template.getName()) || t.getVersion() >= version) continue;
            templates.add(t);
        }
        return templates;
    }

    @Override
    public WorkflowTemplate getTemplateBySelectorKey(String selectorKey) {
        for (WorkflowTemplate template : this.getLatestTemplates()) {
            for (Selector selector : template.getSelectorKeys()) {
                if (!selector.getSelectionKey().equals(selectorKey)) continue;
                return template;
            }
        }
        throw new DriverRuntimeException("Failed to find template for selector key " + selectorKey);
    }

    @Override
    public void save(WorkflowTemplate template) throws DriverException {
        this.checkVersion(template);
        this.checkLicense(template);
        WorkflowTemplate previous = this.getLatestTemplate(template.getName());
        Session session = null;
        Transaction t = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            if (previous != null) {
                for (Selector selector : previous.getSelectorKeys()) {
                    template.addSelectorKey(new Selector(selector.getSelectionKey(), template));
                }
                previous.removeSelectorKeys();
                session.saveOrUpdate((Object)previous);
                session.flush();
            }
            session.saveOrUpdate((Object)template);
            t.commit();
            this.cache(template);
            this.service.run(template);
            logger.info((Object)("Saved template " + template));
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to create template " + template, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void update(WorkflowTemplate template) throws DriverException {
        Session session = null;
        Transaction t = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            session.saveOrUpdate((Object)template);
            t.commit();
            logger.debug((Object)("Updated template " + template));
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to update template " + template, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void delete(WorkflowTemplate template) throws DriverException {
        logger.info((Object)("Deleting template " + template));
        Session session = null;
        Transaction t = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            Statement statement = session.connection().createStatement();
            statement.executeUpdate("update JBPM_PROCESSDEFINITION set PROCESSDEFINITIONTYPEID = 1 where ID_ = " + template.getId());
            t.commit();
            this.remove(template);
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to delete template " + template, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void addSelector(Serializable id, Selector selector) throws DriverException {
        for (WorkflowTemplate t : this.getAllProcessDefinitions()) {
            for (Selector s : t.getSelectorKeys()) {
                if (!s.getSelectionKey().equals(selector.getSelectionKey())) continue;
                throw new SelectorExistsException("Key " + selector.getSelectionKey() + " is mapped to template " + t.getFullName());
            }
        }
        WorkflowTemplate template = this.getProcessDefinition(id);
        if (template == null) {
            throw new DriverException("Failed to find template [" + id + "]");
        }
        template.addSelectorKey(selector);
        this.update(template);
    }

    @Override
    public void removeSelector(Serializable id, Selector selector) throws DriverException {
        WorkflowTemplate template = this.getProcessDefinition(id);
        selector.setTemplate(template);
        template.removeSelectorKey(selector);
        this.update(template);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.cache.start();
        logger.debug((Object)"Loading cache...");
        cachelock.writeLock().lock();
        try {
            Collection<WorkflowTemplate> templates = this.getAll();
            for (WorkflowTemplate template : templates) {
                this.cache(template);
            }
            logger.info((Object)("Loaded " + this.cache.count() + " templates"));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load templates", (Throwable)e);
        }
        finally {
            cachelock.writeLock().unlock();
        }
        this.service.start();
    }

    @Override
    public void stop() {
        this.cache.stop();
    }

    private void cache(WorkflowTemplate template) {
        logger.debug((Object)("Adding to cache " + template));
        this.getCache().add(Long.valueOf(template.getId()), template);
    }

    private void remove(WorkflowTemplate template) {
        logger.debug((Object)("Removing from cache " + template));
        this.getCache().remove(Long.valueOf(template.getId()));
    }

    private ICacheService<WorkflowTemplate> getCache() {
        return this.cache;
    }

    private void checkVersion(WorkflowTemplate template) throws DriverException {
        WorkflowTemplate latest = this.getLatestTemplate(template.getName());
        if (latest != null && latest.getVersion() >= template.getVersion()) {
            throw new DriverException("Template " + template + " - version must exceed " + latest.getVersion());
        }
    }

    private void checkLicense(WorkflowTemplate template) throws DriverException {
        int count = this.getLicenseCount();
        for (WorkflowTemplate t : this.getLatestTemplates()) {
            if (!t.getName().equals(template.getName())) continue;
            return;
        }
        if (this.getLatestTemplates().size() >= count) {
            throw new DriverException("License unavailable for template " + template.getFullName() + ", limit = " + count);
        }
    }

    private WorkflowTemplate getLatestTemplate(String name) {
        List<WorkflowTemplate> templates = this.getAllProcessDefinitions();
        Collections.sort(templates, new TemplateComparator());
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<WorkflowTemplate> getAll() {
        List list = new ArrayList();
        Session session = null;
        try {
            session = this.getSession();
            list = session.createCriteria(WorkflowTemplate.class).list();
        }
        finally {
            this.closeSession(session);
        }
        TreeSet<WorkflowTemplate> templates = new TreeSet<WorkflowTemplate>(new Comparator<WorkflowTemplate>(){

            @Override
            public int compare(WorkflowTemplate o1, WorkflowTemplate o2) {
                return o1.getCreateDate().compareTo(o2.getCreateDate());
            }
        });
        templates.addAll(list);
        return templates;
    }

    private int getLicenseCount() {
        int count = Integer.MAX_VALUE;
        try {
            String entry = LicenseManager.getInstance().getObject(LicenseKeyConstants.TEMPLATES);
            if (entry != null && entry.trim().length() > 0) {
                count = Integer.parseInt(entry.trim());
            }
        }
        catch (Exception e) {
            count = 0;
        }
        return count;
    }

    private Session getSession() {
        return HibernateContext.getContext().openSession();
    }

    private void closeSession(Session session) {
        if (session != null) {
            session.close();
        }
    }

    class TemplateComparator
    implements Comparator<WorkflowTemplate> {
        TemplateComparator() {
        }

        @Override
        public int compare(WorkflowTemplate t1, WorkflowTemplate t2) {
            if (t1.getName().equals(t2.getName())) {
                return t2.getVersion() - t1.getVersion();
            }
            return t2.getName().compareTo(t1.getName());
        }
    }
}

