/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.exe.IExecutable;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jbpm.graph.exe.ExecutionContext;

public abstract class AbstractAction
implements IExecutable {
    private boolean aborted;
    private Future<Void> future;

    @Override
    public final void abort() {
        this.aborted = true;
        this.future.cancel(true);
    }

    public void cleanup() {
    }

    public final void execute(final ExecutionContext context) throws Exception {
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() == ProcessStatus.ERROR || token.getRequestedStatus() == ProcessStatus.ERROR) {
            throw new ActionException(token + ", invalid status");
        }
        ExecutorService service = Executors.newFixedThreadPool(1);
        this.future = service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractAction.this.start(context);
                return null;
            }
        });
        try {
            this.future.get();
        }
        catch (CancellationException e) {
            if (this.aborted) {
                throw new ActionException(token + ", execution was aborted", e);
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ActionException) {
                throw (ActionException)e.getCause();
            }
            throw new ActionException(token + ", an error occured during execution", e);
        }
        finally {
            service.shutdownNow();
        }
    }

    protected abstract void start(ExecutionContext var1);
}

