/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.message;

import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.exe.message.AbstractMessageEmitter;
import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.util.FileUtility;
import java.util.Collection;
import org.jbpm.graph.exe.ExecutionContext;

public class AttachmentSender
extends AbstractMessageEmitter {
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private static final long serialVersionUID = 614697021863337951L;

    @Override
    protected WorkflowMessage createRequest(ExecutionContext context) {
        WorkflowMessage message = super.createRequest(context);
        String path = this.getAttachmentPath(context);
        if (path == null) {
            throw new ActionException("No attachment defined for " + context.getNode().getName());
        }
        String contentType = this.getContentType(context);
        if (contentType == null || contentType.length() == 0) {
            contentType = CONTENT_TYPE_TEXT_XML;
        }
        byte[] content = null;
        try {
            content = FileUtility.readByteContents(path);
        }
        catch (Exception e) {
            throw new ActionException("Cannot load attachment: " + path, e);
        }
        message.addAttachment(new HTTPAttachment(content, contentType));
        return message;
    }

    private String getAttachmentPath(ExecutionContext context) {
        Collection<TaskVariable> variables = this.getVariables(context);
        for (TaskVariable variable : variables) {
            if (!variable.isAttachment()) continue;
            return (String)context.getVariable(variable.getVariableName());
        }
        return null;
    }

    private String getContentType(ExecutionContext context) {
        Collection<TaskVariable> variables = this.getVariables(context);
        for (TaskVariable variable : variables) {
            if (!variable.getAccess().hasAccess("content-type")) continue;
            return (String)context.getVariable(variable.getVariableName());
        }
        return null;
    }
}

