/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.dao.HibernateContext;
import com.tandbergtv.workflow.log.AbstractDAOFactory;
import com.tandbergtv.workflow.log.IWorkflowMessageLogDAO;
import com.tandbergtv.workflow.log.IWorkflowNodeLogDAO;
import com.tandbergtv.workflow.log.LogQueueDrainer;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.entities.WorkflowNodeLog;
import com.tandbergtv.workflow.log.events.WorkflowLogEvent;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import com.tandbergtv.workflow.log.mgmt.EventQueue;
import com.tandbergtv.workflow.util.SortingOrder;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;

public class WorkflowLogManager
implements IColleague {
    private static final Logger logger = Logger.getLogger(WorkflowLogManager.class);
    private static WorkflowLogManager _instance;
    private boolean initialized = false;
    private Collection<LogQueueDrainer> drainers = new ArrayList<LogQueueDrainer>();

    private WorkflowLogManager() {
    }

    public static synchronized WorkflowLogManager getInstance() {
        if (_instance == null) {
            _instance = new WorkflowLogManager();
        }
        return _instance;
    }

    public synchronized void initialize() {
        if (this.initialized) {
            logger.info((Object)"Workflow Log Manager already initialized. Ignoring the initialize() call.");
            return;
        }
        logger.info((Object)"Initializing the Workflow Log Manager...");
        try {
            this.configure();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to create one or more loggers, events will not be saved", (Throwable)e);
        }
        DefaultMediator.getInstance().register(this);
        this.initialized = true;
    }

    public void destroy() {
        logger.info((Object)"Destroying the Workflow Log Manager...");
        DefaultMediator.getInstance().unregister(this);
        for (LogQueueDrainer drainer : this.drainers) {
            drainer.stop();
        }
    }

    @Override
    public String getColleagueName() {
        return this.getClass().getName();
    }

    @Override
    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    @Override
    public void receive(WorkflowEvent event) {
        if (event instanceof WorkflowLogEvent) {
            logger.debug((Object)("Adding to the drainer: " + event));
            for (LogQueueDrainer drainer : this.drainers) {
                drainer.drainEvent(event);
            }
            logger.debug((Object)"Added...");
        }
    }

    private void configure() throws Exception {
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".logger");
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            logger.debug((Object)("Key " + key));
            String[] classNames = bundle.getString(key).split(",");
            IWorkflowLogger[] loggers = new IWorkflowLogger[classNames.length];
            int i = 0;
            for (String className : classNames) {
                logger.debug((Object)("Class name " + className));
                loggers[i++] = (IWorkflowLogger)Class.forName(className.trim()).newInstance();
            }
            this.addLogger(key, loggers);
        }
    }

    private void addLogger(String name, IWorkflowLogger ... loggers) {
        LogQueueDrainer drainer = new LogQueueDrainer(loggers);
        this.drainers.add(drainer);
        this.registerMBean(new EventQueue(drainer), "com.tandbergtv.watchpoint:type=EventQueue,name=" + name);
        new Thread((Runnable)drainer, name).start();
    }

    private void registerMBean(Object obj, String name) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.registerMBean(obj, new ObjectName(name));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeLog> getHistoryTasks(List<CustomToken> tokens, int numRecords, int startingRecordNum) {
        List jbpmNodeLogs;
        Session session = HibernateContext.getContext().openSession();
        try {
            jbpmNodeLogs = session.createQuery(this.buildHistoryTasksQuery(tokens, false)).setMaxResults(numRecords).setFirstResult(startingRecordNum).list();
        }
        finally {
            session.close();
        }
        return jbpmNodeLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTasksCount(List<CustomToken> tokens) {
        Session session = HibernateContext.getContext().openSession();
        try {
            int n = (Integer)session.createQuery(this.buildHistoryTasksQuery(tokens, true)).uniqueResult();
            return n;
        }
        finally {
            session.close();
        }
    }

    private String buildHistoryTasksQuery(List<CustomToken> tokens, boolean count) {
        StringBuffer query = count ? new StringBuffer("select count(*) ") : new StringBuffer("select n ");
        query.append("from NodeLog n where n.token in (");
        for (int i = 0; i < tokens.size(); ++i) {
            query.append(tokens.get(i).getId());
            if (i == tokens.size() - 1) continue;
            query.append(", ");
        }
        query.append(") and n.node.superState is null order by date");
        return query.toString();
    }

    public List<WorkflowMessageLog> getHistoryTaskMessages(long historyTaskMessagesKey, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        IWorkflowMessageLogDAO messageLogDAO = AbstractDAOFactory.getDefaultFactory().getWorkflowMessageLogDAO();
        return messageLogDAO.findByJBPMNodeLogID(historyTaskMessagesKey, numRecords, startingRecordNum, sortColumn, sortOrder);
    }

    public int getHistoryTaskMessagesCount(long historyTaskMessagesKey) {
        IWorkflowMessageLogDAO messageLogDAO = AbstractDAOFactory.getDefaultFactory().getWorkflowMessageLogDAO();
        return messageLogDAO.countByJBPMNodeLogID(historyTaskMessagesKey);
    }

    public List<WorkflowMessageLog> getCurrentTaskMessages(long currentTaskMessagesKey, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        IWorkflowMessageLogDAO messageLogDAO = AbstractDAOFactory.getDefaultFactory().getWorkflowMessageLogDAO();
        return messageLogDAO.findByWorkflowNodeLogID(currentTaskMessagesKey, numRecords, startingRecordNum, sortColumn, sortOrder);
    }

    public int getCurrentTaskMessagesCount(long currentTaskMessagesKey) {
        IWorkflowMessageLogDAO messageLogDAO = AbstractDAOFactory.getDefaultFactory().getWorkflowMessageLogDAO();
        return messageLogDAO.countByWorkflowNodeLogID(currentTaskMessagesKey);
    }

    public long getCurrentTaskMessagesKey(Token token, Node node) {
        IWorkflowNodeLogDAO wfsNodeLogDAO = AbstractDAOFactory.getDefaultFactory().getWorkflowNodeLogDAO();
        WorkflowNodeLog workflowNodeLog = wfsNodeLogDAO.findCurrentByTokenAndNode(token, node);
        return workflowNodeLog != null ? workflowNodeLog.getId() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTaskIteration(long historyTaskID) {
        Session session = HibernateContext.getContext().openSession();
        try {
            String queryString = "select count(*) from NodeLog n where n.node.id = (select n1.node.id from NodeLog n1 where n1.id = " + historyTaskID + ") and n.token.processInstance = (select n2.token.processInstance from NodeLog n2 where n2.id = " + historyTaskID + ") and n.id <= " + historyTaskID;
            Query query = session.createQuery(queryString);
            int n = (Integer)query.uniqueResult();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get iteration number of history task | historyTaskID: " + historyTaskID), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTaskNumIterations(long historyTaskID) {
        Session session = HibernateContext.getContext().openSession();
        try {
            String queryString = "select count(wnl) from WorkflowNodeLog wnl, NodeLog nl where wnl.node = nl.node and wnl.token.processInstance = nl.token.processInstance and nl.id = " + historyTaskID;
            Query query = session.createQuery(queryString);
            int n = (Integer)query.uniqueResult();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get total # iterations of history task | historyTaskID: " + historyTaskID), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentTaskIteration(long currentTaskMessagesKey) {
        Session session = HibernateContext.getContext().openSession();
        try {
            String queryString = "select count(*) from WorkflowNodeLog wnl where wnl.node.id = (select wnl1.node.id from WorkflowNodeLog wnl1 where wnl1.id = " + currentTaskMessagesKey + ") and wnl.token.processInstance = (select wnl2.token.processInstance from WorkflowNodeLog wnl2 where wnl2.id = " + currentTaskMessagesKey + ") and wnl.id <= " + currentTaskMessagesKey;
            Query query = session.createQuery(queryString);
            int n = (Integer)query.uniqueResult();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get iteration number of current task | currentTaskMessagesKey: " + currentTaskMessagesKey), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }
}

