/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.loggers;

import com.tandbergtv.workflow.log.AbstractDAOFactory;
import com.tandbergtv.workflow.log.IWorkflowNodeLogDAO;
import com.tandbergtv.workflow.log.LogUtil;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.entities.WorkflowNodeLog;
import com.tandbergtv.workflow.log.events.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.w3c.dom.Document;

public class WorkflowMessageLogger
implements IWorkflowLogger {
    private static final Logger logger = Logger.getLogger(WorkflowMessageLogger.class);

    @Override
    public void execute(Object eventObj) {
        if (!(eventObj instanceof WorkflowMessageLogEvent)) {
            logger.debug((Object)"Not a WorkflowMessageLogEvent. Event ignored.");
            return;
        }
        WorkflowMessageLogEvent messageLogEvent = (WorkflowMessageLogEvent)eventObj;
        WorkflowMessageLog messageLog = null;
        try {
            messageLog = this.getMessageLog(messageLogEvent);
        }
        catch (Exception e) {
            logger.error((Object)("Exception while getting message log from message log event. Log event ignored. Message Log Event: " + messageLogEvent), (Throwable)e);
            return;
        }
        Node node = messageLog.getNode();
        Token token = messageLog.getToken();
        if (node.getSuperState() != null) {
            node = node.getSuperState();
        }
        long start = System.currentTimeMillis();
        WorkflowNodeLog workflowNodeLog = this.getCurrentWorkflowNodeLog(node, token);
        long read = System.currentTimeMillis() - start;
        if (workflowNodeLog == null) {
            workflowNodeLog = new WorkflowNodeLog(token, node);
            workflowNodeLog.setDate(messageLog.getTimestamp());
            logger.debug((Object)("Storing workflow node log to database. Workflow Node Log: " + (Object)((Object)workflowNodeLog)));
            workflowNodeLog = LogUtil.storeWorkflowNodeLog(workflowNodeLog);
        }
        messageLog.setNodeLog(workflowNodeLog);
        logger.debug((Object)("Storing message log to database. Message Log: " + messageLog));
        LogUtil.storeMessageLog(messageLog);
        long write = System.currentTimeMillis() - start;
        logger.debug((Object)("Read delay " + (double)read / 1000.0 + ", total delay " + (double)write / 1000.0));
    }

    @Override
    public boolean match(Object logEvent) {
        return logEvent instanceof WorkflowMessageLogEvent;
    }

    private WorkflowMessageLog getMessageLog(WorkflowMessageLogEvent messageLogEvent) throws Exception {
        WorkflowMessage wfsMessage = messageLogEvent.getWfsMessage();
        Document document = Marshaller.newMarshaller().marshal(wfsMessage);
        String content = XMLDocumentUtility.convertToString(document);
        IMessageUID messageUID = MessageRegistry.getInstance().getMessageUID(wfsMessage.getMessageUID().getUID());
        String name = messageUID != null ? messageUID.getName() : null;
        WorkflowMessageLog messageLog = new WorkflowMessageLog(wfsMessage.getMessageUID().getUID(), wfsMessage.getType().name(), name, content, messageLogEvent.isIncoming(), messageLogEvent.getTimestamp(), messageLogEvent.getResource());
        messageLog.setNode(messageLogEvent.getNode());
        messageLog.setToken(messageLogEvent.getToken());
        return messageLog;
    }

    private WorkflowNodeLog getCurrentWorkflowNodeLog(Node node, Token token) {
        IWorkflowNodeLogDAO workflowNodeLogDAO = AbstractDAOFactory.getDefaultFactory().getWorkflowNodeLogDAO();
        WorkflowNodeLog wnl = workflowNodeLogDAO.findCurrentByTokenAndNode(token, node);
        logger.debug((Object)("Corresponding workflow node log for node: [" + node + "] and token: [" + token + "] is: [" + (Object)((Object)wnl) + "]"));
        return wnl;
    }
}

