/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.messageprocessor.locate;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ICacheService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.messageprocessor.locate.AbstractTokenLocator;
import com.tandbergtv.workflow.messageprocessor.locate.TokenLocatorException;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompositeKeyMatcher
extends AbstractTokenLocator {
    private static final Logger logger = Logger.getLogger(CompositeKeyMatcher.class);

    @Override
    public Token locate(WorkflowMessage message) throws TokenLocatorException {
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
        for (Serializable id : cache.getKeys()) {
            WorkflowProcess process = (WorkflowProcess)cache.get(id);
            for (CustomToken token : process.findAllTokens()) {
                logger.debug((Object)(token + ", trying to match message " + message.getMessageUID()));
                boolean match = this.correlateToken(message, token);
                if (!match) continue;
                return token;
            }
        }
        return null;
    }

    protected boolean correlateToken(WorkflowMessage message, CustomToken token) throws TokenLocatorException {
        if (token.getStatus() != ProcessStatus.RUNNING && token.getStatus() != ProcessStatus.BUSY && token.getStatus() != ProcessStatus.QUEUED) {
            return false;
        }
        org.jbpm.graph.def.Node node = this.getNode(token);
        if (!this.needsMessage(node, message)) {
            return false;
        }
        Map<String, String> keys = this.getCorrelationKeys(node);
        boolean found = true;
        for (String key : keys.keySet()) {
            String name = keys.get(key);
            String value = token.getProcessInstance().getContextInstance().getVariable(key).toString();
            logger.debug((Object)("Variable " + key + " value " + value + " message parameter " + name + " value " + message.getValue(name)));
            found = found && value.equals(message.getValue(name));
        }
        return found;
    }

    private Map<String, String> getCorrelationKeys(org.jbpm.graph.def.Node node) throws TokenLocatorException {
        HashMap<String, String> keys = new HashMap<String, String>();
        XPath path = XPathFactory.newInstance().newXPath();
        String configuration = node.getAction().getActionDelegation().getConfiguration();
        int from = configuration.indexOf("<keys>");
        int to = configuration.indexOf("</keys>");
        if (from == -1 || to == -1) {
            return keys;
        }
        try {
            String tmp = configuration.substring(from, to + 7);
            Document document = XMLDocumentUtility.loadXml(tmp);
            NodeList nodes = (NodeList)path.evaluate("//keys/entry", document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                keys.put(n.getFirstChild().getTextContent(), n.getLastChild().getTextContent());
            }
        }
        catch (Exception e) {
            throw new TokenLocatorException("Failed to load composite key information", e);
        }
        return keys;
    }
}

