/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.n2bb.sysmonui.corba.CORBAManager;
import com.tandbergtv.workflow.core.health.ComponentHealthStatus;
import com.tandbergtv.workflow.core.health.IHealthAware;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.StringWriter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AlertSystemHealthManager
implements IHealthAware {
    private static final Logger logger = Logger.getLogger(AlertSystemHealthManager.class);
    private static final String OBJECT_XPATH_EXPRESSION = "//Object";
    private static final String OK_STATUS_VALUE = "up";
    private static final String NAME_ELEMENT = "Name";
    private static final String STATUS_ELEMENT = "Status";
    private static final long DEFAULT_POLL_FREQUENCY = 120L;
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static AlertSystemHealthManager instance = new AlertSystemHealthManager();
    private boolean initialized = false;
    private ComponentHealthStatus healthStatus = ComponentHealthStatus.ERROR;
    private ScheduledExecutorService service = null;
    private ScheduledFuture future = null;

    public static AlertSystemHealthManager getInstance() {
        return instance;
    }

    private AlertSystemHealthManager() {
    }

    public synchronized void initialize() {
        if (this.initialized) {
            logger.warn((Object)"The Alert System Health Manager has already been initialized, ignoring initialization request.");
            return;
        }
        this.service = Executors.newSingleThreadScheduledExecutor();
        long pollFrequency = this.getPollFrequency();
        logger.debug((Object)("Starting Alert System Health Status Poll Thread with frequency: " + pollFrequency + " seconds."));
        this.future = this.service.scheduleAtFixedRate(new HealthStatusPoller(), 0L, pollFrequency, TimeUnit.SECONDS);
        this.initialized = true;
        logger.info((Object)"Successfully initialized the AlertSystem Health Manager.");
    }

    public synchronized void shutdown() {
        if (!this.initialized) {
            logger.warn((Object)"The Alert System Health Manager has not been initialized, ignoring shutdown request.");
            return;
        }
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        this.service.shutdownNow();
        try {
            boolean isShutdown = this.service.awaitTermination(30L, TimeUnit.SECONDS);
            if (!isShutdown) {
                logger.warn((Object)"The AlertSystem Health Poll Thread did not terminate after wait period (30 seconds), shutting down anyway.");
            }
        }
        catch (InterruptedException ex) {
            logger.warn((Object)"Interrupted when waiting for the Alert System Health Poll thread to terminate.", (Throwable)ex);
        }
        this.service = null;
        this.initialized = false;
        logger.info((Object)"Successfully shutdown the AlertSystem Health Manager.");
    }

    @Override
    public synchronized ComponentHealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    protected synchronized void setHealthStatus(ComponentHealthStatus healthStatus) {
        this.healthStatus = healthStatus;
    }

    private long getPollFrequency() {
        long pollFrequency = 0L;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            String frequencyValue = properties.getProperty("AlertSystemHealthManager.HealthStatusPollFrequency");
            pollFrequency = Long.parseLong(frequencyValue);
        }
        catch (Exception ex) {
            logger.warn((Object)("Failed to read the Poll Frequency for the Alert System Health Manager, using default value: " + pollFrequency + " seconds."));
            pollFrequency = 120L;
        }
        return pollFrequency;
    }

    private String createXMLString(Source source) throws TransformerException {
        Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
        StringWriter writer = new StringWriter(1024);
        transformer.transform(source, new StreamResult(writer));
        transformer.transform(source, new DOMResult());
        return writer.toString();
    }

    private Document createXMLDocument(Source source) throws TransformerException, ParserConfigurationException {
        Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
        Document doc = DOC_BUILDER_FACTORY.newDocumentBuilder().newDocument();
        transformer.transform(source, new DOMResult(doc));
        return doc;
    }

    private ComponentHealthStatus getHealthStatusFromCorbaManager() {
        ComponentHealthStatus componentHealthStatus = ComponentHealthStatus.OK;
        try {
            CORBAManager corbaManager = new CORBAManager();
            Source contextXML = corbaManager.getContextXML();
            XPath xpath = XPathFactory.newInstance().newXPath();
            Document contextDoc = this.createXMLDocument(contextXML);
            NodeList nodes = (NodeList)xpath.evaluate(OBJECT_XPATH_EXPRESSION, contextDoc, XPathConstants.NODESET);
            if (nodes != null && nodes.getLength() > 0) {
                for (int index = 0; index < nodes.getLength(); ++index) {
                    Element objectElement = (Element)nodes.item(index);
                    Element nameElement = (Element)objectElement.getElementsByTagName(NAME_ELEMENT).item(0);
                    Element statusElement = (Element)objectElement.getElementsByTagName(STATUS_ELEMENT).item(0);
                    String name = nameElement.getTextContent();
                    String status = statusElement.getTextContent();
                    if (status != null && status.trim().equals(OK_STATUS_VALUE)) continue;
                    componentHealthStatus = ComponentHealthStatus.ERROR;
                    logger.error((Object)("The Alert Component: " + name + " has status: " + status + ", the Alert System is down."));
                }
            } else {
                componentHealthStatus = ComponentHealthStatus.ERROR;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get Health Status of the Alert System.", (Throwable)ex);
            componentHealthStatus = ComponentHealthStatus.ERROR;
        }
        return componentHealthStatus;
    }

    public void pollHealthStatus() {
        ComponentHealthStatus componentHealthStatus = this.getHealthStatusFromCorbaManager();
        this.setHealthStatus(componentHealthStatus);
    }

    private class HealthStatusPoller
    implements Runnable {
        private HealthStatusPoller() {
        }

        @Override
        public void run() {
            AlertSystemHealthManager.this.pollHealthStatus();
        }
    }
}

