/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.dao.HibernateContext;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerEventHandler;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerLifeCycleManager;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerValidator;
import com.tandbergtv.workflow.resourcemanager.ResourceQueueManager;
import com.tandbergtv.workflow.resourcemanager.ResourceStateManager;
import com.tandbergtv.workflow.resourcemanager.dataaccess.DataAccessObjectFactory;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jbpm.graph.exe.Token;

final class ResourceManagerContext {
    private static final Logger logger = Logger.getLogger(ResourceManagerContext.class);
    ResourceManager manager;
    IMediator mediator;
    HibernateContext persistContext;
    DataAccessObjectFactory daoFactory;
    PluginManagement pluginManager;
    Map<Long, ResourceContainer> resources = new HashMap<Long, ResourceContainer>();
    Map<Long, ResourceGroupContainer> resourceGroups = new HashMap<Long, ResourceGroupContainer>();
    Map<Long, ResourceType> resourceTypes = new HashMap<Long, ResourceType>();
    Map<Long, ResourceType> inactiveResourceTypes = new HashMap<Long, ResourceType>();
    Map<Long, Long> queuedTokenLookup = new HashMap<Long, Long>();
    int numOfActiveSystemResources = -1;
    int numOfActiveHumanResources = -1;
    ResourceManagerLifeCycleManager lifeCycleManager;
    ResourceStateManager stateManager;
    ResourceManagerValidator validator;
    ResourceQueueManager queueManager;
    ResourceManagerEventHandler eventHandler;

    ResourceManagerContext(ResourceManager manager) {
        this.manager = manager;
        this.lifeCycleManager = new ResourceManagerLifeCycleManager(this);
        this.stateManager = new ResourceStateManager(this);
        this.validator = new ResourceManagerValidator(this);
        this.queueManager = new ResourceQueueManager(this);
        this.eventHandler = new ResourceManagerEventHandler(this);
    }

    Session getCurrentSession() {
        return this.persistContext.getCurrentSession();
    }

    void rollbackTransaction(Transaction transaction) {
        try {
            transaction.rollback();
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Failed to roll back the transaction.", (Throwable)ex);
        }
    }

    ResourceContainer findResourceByToken(long tokenId) {
        ResourceContainer match = null;
        ResourceUser user = new ResourceUser(tokenId);
        for (ResourceContainer container : this.resources.values()) {
            Resource resource = container.getResource();
            if (!resource.getUsers().contains(user)) continue;
            match = container;
            break;
        }
        return match;
    }

    void storeResource(long resourceId) {
        Session currentSession = this.getCurrentSession();
        ResourceDAI resDAI = this.daoFactory.getResourceDAO();
        ResourceContainer container = this.resources.get(resourceId);
        Resource resource = container.getResource();
        try {
            currentSession.beginTransaction();
            Resource updatedResource = resDAI.update(resource);
            container.setResource(updatedResource);
            currentSession.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(currentSession.getTransaction());
            String msg = "Failed to internally update Resource[id=" + resource.getId() + "]: " + resource.getName() + ", the object in memory is different from the DB.";
            logger.error((Object)msg, (Throwable)ex);
        }
    }

    void storeResourceGroup(long resourceGroupId) {
        Session currentSession = this.getCurrentSession();
        ResourceGroupDAI rgDAI = this.daoFactory.getResourceGroupDAO();
        ResourceGroupContainer container = this.resourceGroups.get(resourceGroupId);
        ResourceGroup group = container.getResourceGroup();
        try {
            currentSession.beginTransaction();
            ResourceGroup updatedGroup = rgDAI.update(group);
            container.setResourceGroup(updatedGroup);
            currentSession.getTransaction().commit();
        }
        catch (Exception ex) {
            this.rollbackTransaction(currentSession.getTransaction());
            String msg = "Failed to internally update ResourceGroup[id=" + group.getId() + "]: " + group.getName() + ", the object in memory is different from the DB.";
            logger.error((Object)msg, (Throwable)ex);
        }
    }

    void storeResourceAndGroup(long resourceId, long resourceGroupId) {
        Session currentSession = this.getCurrentSession();
        ResourceGroupDAI rgDAI = this.daoFactory.getResourceGroupDAO();
        ResourceDAI resDAI = this.daoFactory.getResourceDAO();
        ResourceContainer container = this.resources.get(resourceId);
        Resource resource = container.getResource();
        ResourceGroupContainer rgContainer = this.resourceGroups.get(resourceGroupId);
        ResourceGroup group = rgContainer.getResourceGroup();
        try {
            currentSession.beginTransaction();
            Resource updatedResource = resDAI.update(resource);
            ResourceGroup updatedGroup = rgDAI.update(group);
            container.setResource(updatedResource);
            rgContainer.setResourceGroup(updatedGroup);
            currentSession.getTransaction().commit();
        }
        catch (Exception ex) {
            this.rollbackTransaction(currentSession.getTransaction());
            String msg = "Failed to internally update Resource[id=" + resource.getId() + "]: " + resource.getName() + " and ResourceGroup[id=" + group.getId() + "]: " + group.getName() + ", the object in memory is different from the DB.";
            logger.error((Object)msg, (Throwable)ex);
        }
    }

    public int getNumOfActiveHumanResources() {
        return this.numOfActiveHumanResources;
    }

    public void setNumOfActiveHumanResources(int numOfActiveHumanResources) {
        this.numOfActiveHumanResources = numOfActiveHumanResources;
    }

    public int getNumOfActiveSystemResources() {
        return this.numOfActiveSystemResources;
    }

    public void setNumOfActiveSystemResources(int numOfActiveSystemResources) {
        this.numOfActiveSystemResources = numOfActiveSystemResources;
    }

    ResourceGroupContainer getResourceGroupForToken(Token token) {
        ResourceGroupContainer container = null;
        Long resourceGroupId = this.queuedTokenLookup.get(token.getId());
        if (resourceGroupId != null) {
            container = this.resourceGroups.get(resourceGroupId);
        }
        return container;
    }
}

