/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.auth.IProtectionKeyAware;
import com.tandbergtv.workflow.auth.ProtectionKey;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.driver.event.NodeTimeoutEvent;
import com.tandbergtv.workflow.driver.event.TaskCompleteEvent;
import com.tandbergtv.workflow.driver.event.TaskStatusEvent;
import com.tandbergtv.workflow.driver.event.TaskUpdateEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerContext;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.event.AcquireResourceEvent;
import com.tandbergtv.workflow.resourcemanager.event.ReleaseResourceEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAllocationFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceRequestRejectedEvent;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

class ResourceManagerEventHandler {
    private static final Logger logger = Logger.getLogger(ResourceManagerEventHandler.class);
    private ResourceManagerContext context;

    ResourceManagerEventHandler(ResourceManagerContext context) {
        this.context = context;
    }

    void handleAcquireResourceEvent(AcquireResourceEvent event) {
        Token token = event.getToken();
        long tokenId = token.getId();
        Long resourceGroupId = event.getResourceGroupId();
        if (resourceGroupId == null || !this.context.resourceGroups.containsKey(resourceGroupId)) {
            logger.error((Object)("Recieved an Acquire Resource Event for Token[" + tokenId + "]" + " which is not mapped to a Resource Group or mapped to an invalid group."));
            this.context.mediator.sendAsync(new ResourceRequestRejectedEvent(token));
            return;
        }
        ResourceGroupContainer container = this.context.resourceGroups.get(resourceGroupId);
        ResourceGroup resourceGroup = container.getResourceGroup();
        int protectionKeyId = resourceGroup.getProtectionKeyId();
        Set<ProtectionKey> protectionKeys = null;
        if (token instanceof IProtectionKeyAware) {
            protectionKeys = ((IProtectionKeyAware)token).getProtectionKeys();
        }
        boolean isValid = false;
        if (protectionKeys != null) {
            boolean bl = isValid = protectionKeys.size() == 0 && protectionKeyId == -1;
            if (!isValid) {
                for (ProtectionKey protectionKey : protectionKeys) {
                    if (protectionKey.getId() != resourceGroup.getProtectionKeyId()) continue;
                    isValid = true;
                    break;
                }
            }
        }
        if (isValid) {
            this.context.queueManager.queueToken(resourceGroup.getId(), tokenId);
        } else {
            this.rejectRequest(token);
        }
    }

    private void rejectRequest(Token token) {
        logger.warn((Object)("Process [id=" + token.getProcessInstance().getId() + "]: " + token.getProcessInstance().getProcessDefinition().getName() + ", Node[id=" + token.getNode().getId() + "]: " + token.getNode().getName() + " and mapped Resource Group have different protection keys."));
        ResourceRequestRejectedEvent event = new ResourceRequestRejectedEvent(token);
        this.context.mediator.sendAsync(event);
    }

    void handleReleaseResourceEvent(ReleaseResourceEvent event) {
        CustomToken token = (CustomToken)event.getToken();
        this.context.queueManager.releaseToken(token, event.getNode());
    }

    void handlePauseWorkOrderEvent(WorkflowProcessEvent event) {
        this.handleWorkOrderNotRunning(event);
    }

    void handleCancelWorkOrderEvent(WorkflowProcessEvent event) {
        this.handleWorkOrderNotRunning(event);
    }

    void handleTokenFailedEvent(WorkflowProcessEvent event) {
        this.handleWorkOrderNotRunning(event);
    }

    private void handleWorkOrderNotRunning(WorkflowProcessEvent event) {
        CustomToken token = (CustomToken)event.getToken();
        ResourceGroupContainer container = this.getResourceGroupForToken(token);
        if (container != null) {
            long resourceGroupId = container.getResourceGroup().getId();
            this.context.queueManager.dequeueToken(resourceGroupId, token);
        }
        this.context.queueManager.releaseToken(token);
    }

    void handlePriorityChangedEvent(WorkflowProcessEvent event) {
        CustomToken token = (CustomToken)event.getToken();
        if (token.getStatus() != ProcessStatus.QUEUED) {
            return;
        }
        long tokenId = token.getId();
        ResourceGroupContainer container = this.getResourceGroupForToken(token);
        if (container == null) {
            return;
        }
        long resourceGroupId = container.getResourceGroup().getId();
        this.context.queueManager.repositionQueuedToken(resourceGroupId, tokenId);
    }

    void handleNodeTimeoutEvent(NodeTimeoutEvent event) {
        Token token = event.getToken();
        Node node = event.getNode();
        if (token == null) {
            logger.error((Object)"There is no token associated with the NodeTimeoutEvent.");
            return;
        }
        ResourceContainer container = this.context.findResourceByToken(token.getId());
        if (container != null) {
            Resource resource = container.getResource();
            boolean stateChanged = this.context.stateManager.failResource(container);
            if (stateChanged) {
                this.context.storeResource(resource.getId());
                long processId = token.getProcessInstance().getId();
                logger.info((Object)("Node Timeout for Process[" + processId + "], token " + token.getId() + " has triggered Resource[" + resource.getId() + "] Error State."));
            }
            Resource clone = this.context.manager.cloneResource(resource);
            this.context.mediator.sendAsync(new ResourceFailedEvent(this, token, node, clone));
        } else {
            long processId = token.getProcessInstance().getId();
            long nodeId = token.getNode().getId();
            logger.warn((Object)("There is no resource associated with Process[" + processId + "], Node[" + nodeId + "], ignoring the timeout event."));
        }
    }

    void handleTaskStatusEvent(TaskStatusEvent event) {
        String eventName = this.getEventName(event);
        if (eventName == null) {
            return;
        }
        CustomToken token = (CustomToken)event.getToken();
        ResourceGroupContainer container = this.getResourceGroupForToken(token);
        if (container == null) {
            return;
        }
        ResourceGroup resourceGroup = container.getResourceGroup();
        if (resourceGroup.isInternallyAcquired()) {
            return;
        }
        if (event.hasFailed()) {
            this.context.queueManager.dequeueToken(resourceGroup.getId(), token);
        } else {
            String connectionString = DeviceTypeUtil.getConnectionString(event.getExternalSource());
            boolean allocated = this.context.queueManager.tryToAllocate(resourceGroup.getId(), connectionString, token.getId());
            if (!allocated) {
                Resource resource = this.context.manager.getResourceByConnectionString(connectionString, resourceGroup.getId());
                this.context.mediator.sendAsync(new ResourceAllocationFailedEvent(this, resource, event.getMessage(), event.getToken()));
            }
        }
    }

    void handleServiceEvent(ServiceEvent e) {
        if (e.getService().getServiceName() == "Process Manager" && e.getEvent() == ServiceEvents.STARTED) {
            this.context.lifeCycleManager.initializeResourceGroups();
        }
    }

    private String getEventName(TaskStatusEvent event) {
        String eventName = null;
        if (event instanceof TaskUpdateEvent) {
            eventName = "Task Status Update Event";
        } else if (event instanceof TaskCompleteEvent) {
            eventName = "Task Complete Event";
        }
        return eventName;
    }

    private ResourceGroupContainer getResourceGroupForToken(Token token) {
        return this.context.getResourceGroupForToken(token);
    }
}

