/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import org.apache.log4j.Logger;

class WorkerThread
extends Thread {
    private boolean keepWorking;
    private ResourceGroupContainer rgContainer;
    private long groupId = -1L;
    private ResourceManager manager;
    private static final Logger logger = Logger.getLogger(WorkerThread.class);

    synchronized boolean isKeepWorking() {
        return this.keepWorking;
    }

    synchronized void setKeepWorking(boolean keepWorking) {
        this.keepWorking = keepWorking;
    }

    WorkerThread(ResourceGroupContainer container, ResourceManager manager) {
        this.rgContainer = container;
        this.keepWorking = true;
        this.groupId = this.rgContainer.getResourceGroup().getId();
        this.manager = manager;
        this.setName("Queue-Processor-" + this.groupId);
    }

    @Override
    public void run() {
        logger.debug((Object)("Starting Queue Processing Thread for Resource Group # " + this.groupId));
        while (this.isKeepWorking()) {
            try {
                boolean resourceAssigned = this.manager.tryToAllocate(this.groupId);
                if (resourceAssigned) {
                    WorkerThread.yield();
                    continue;
                }
                if (!this.isKeepWorking()) continue;
                this.waitForNotification();
            }
            catch (Exception ex) {
                logger.error((Object)("Error in the Queue Processing Thread for Resource Group #" + this.groupId + ", ignoring the error and continuing."), (Throwable)ex);
            }
        }
        logger.debug((Object)("Queue Processing Thread for Resource Group #" + this.groupId + " has ended."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNotification() {
        logger.debug((Object)("Waiting for notification of a new Resource / Queue Item becoming available for Resource Group #" + this.groupId));
        try {
            ResourceGroupContainer resourceGroupContainer = this.rgContainer;
            synchronized (resourceGroupContainer) {
                this.rgContainer.wait();
                logger.debug((Object)("Received notification to process the Queue for Resource Group #" + this.groupId));
            }
        }
        catch (InterruptedException ex) {
            logger.error((Object)("Resource Group Queue Processing Thread for Resource Group #" + this.groupId + " was interrupted while waiting for event notification from the ResourceManager."));
        }
    }
}

