/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.dataaccess.hibernate;

import com.tandbergtv.workflow.dao.HibernateDAO;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ResourceHDAO
extends HibernateDAO<Resource, Long>
implements ResourceDAI {
    private static final Logger log = Logger.getLogger(ResourceHDAO.class);

    public ResourceHDAO(Session session) {
        super(Resource.class, session);
    }

    @Override
    public List<Resource> findByResourceType(long resourceTypeId) {
        Criteria criteria = this.createCriteria(new Criterion[0]).createCriteria("resourceType");
        criteria = criteria.add(Restrictions.idEq((Object)resourceTypeId));
        return this.findByCriteria(criteria);
    }

    @Override
    public List<Resource> findByResourceGroup(long resourceGroupId) {
        Criteria criteria = this.createCriteria(new Criterion[0]);
        criteria = criteria.createCriteria("resourceGroups");
        criteria = criteria.add(Restrictions.idEq((Object)resourceGroupId));
        return this.findByCriteria(criteria);
    }

    @Override
    public List<Resource> findByActive(boolean isActive) {
        log.debug((Object)("Finding Resources where 'active' is " + isActive + "..."));
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"active", (Object)isActive)});
        criteria.addOrder(Order.asc((String)"createDate"));
        List<Resource> activeList = this.findByCriteria(criteria);
        log.debug((Object)("Found Resources(" + activeList.size() + ") where 'active' is " + isActive));
        return activeList;
    }

    @Override
    public List<Resource> findBySearchCriteria(SearchCriteria searchCriteria) {
        String logString = "Finding all active Resources by Search Criteria using Ordering: ";
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.getSortingOrder() == null) continue;
            logString = logString + (Object)((Object)param.getSortingOrder()) + " for property: ";
            logString = logString + param.getFieldName() + " ";
        }
        log.debug((Object)logString);
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"active", (Object)true)});
        criteria.setFirstResult(searchCriteria.getStartingRecordNumber());
        if (searchCriteria.getRecordsCount() > 0) {
            criteria.setMaxResults(searchCriteria.getRecordsCount());
        }
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.getSortingOrder() == null) continue;
            String orderProperty = param.getFieldName();
            if ("resourceType".equals(orderProperty)) {
                criteria = criteria.createCriteria("resourceType");
                orderProperty = "name";
            }
            switch (param.getSortingOrder()) {
                case ASCENDING: {
                    criteria.addOrder(Order.asc((String)orderProperty));
                    break;
                }
                case DESCENDING: {
                    criteria.addOrder(Order.desc((String)orderProperty));
                }
            }
        }
        List<Resource> activeList = this.findByCriteria(criteria);
        log.debug((Object)("Found the Resources(" + activeList.size() + ") for the given Search Criteria."));
        return activeList;
    }

    @Override
    public Resource findByUser(long tokenId) {
        Criteria criteria = this.createCriteria(new Criterion[0]).createCriteria("users");
        criteria = criteria.add(Restrictions.idEq((Object)tokenId));
        return (Resource)this.findUniqueByCriteria(criteria);
    }
}

