/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.health.ComponentHealthStatus;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.EngineDriver;
import com.tandbergtv.workflow.driver.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.monitor.AlertSystemHealthManager;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.sanmanager.SANManagement;
import com.tandbergtv.workflow.sanmanager.SANManager;
import com.tandbergtv.workflow.sanmanager.entities.SANDrive;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.entities.HealthStatusDisplay;
import com.tandbergtv.workflow.web.entities.QueuedWorkOrderDisplay;
import com.tandbergtv.workflow.web.entities.ResourceGroupDisplay;
import com.tandbergtv.workflow.web.entities.ResourceUsageDisplay;
import com.tandbergtv.workflow.web.entities.ResourceUsageDisplayComparator;
import com.tandbergtv.workflow.web.entities.SANDriveDisplay;
import com.tandbergtv.workflow.web.entities.TokenStatistics;
import com.tandbergtv.workflow.web.formbeans.DashBoardForm;
import com.tandbergtv.workflow.web.formbeans.ResourceUsageForm;
import com.tandbergtv.workflow.web.table.TableConfig;
import com.tandbergtv.workflow.web.util.CommonUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class DashBoardAction
extends BaseDispatchAction {
    private static final Logger logger = Logger.getLogger(DashBoardAction.class);
    private static final String DASHBOARD_CUT_OFF_DURATION = "dashboard.CutOffDuration";
    private static final String QUEUE_TABLE_ID = "DashboardQueueTable";
    private Date DASHBOARD_CUT_OFF_DATE;
    private static final String DASHBOARD_CUT_OFF_DATE_FORMAT = "MMMM dd yyyy";
    private static final int MAX_RESOURCE_QUEUE_LIST_SIZE = 5;
    private static final ProcessStatus[] statuslist = new ProcessStatus[]{ProcessStatus.ACTIVE, ProcessStatus.COMPLETED, ProcessStatus.ERROR, ProcessStatus.CANCELLED, ProcessStatus.QUEUED, ProcessStatus.PAUSED};

    public ActionForward getDashBoard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SortingOrder sortType;
        Resource resource;
        String strForward = "ToDashBoard";
        DashBoardForm dashBoardStatus = (DashBoardForm)form;
        int taskCount = 0;
        String userName = null;
        if (request.getUserPrincipal() != null) {
            userName = request.getUserPrincipal().getName();
        }
        logger.debug((Object)("The User Name from the User Principal in the Request!! : " + userName));
        if (userName != null && userName.trim().length() > 0 && (resource = ResourceManager.getInstance().getResourceByUser(userName)) != null) {
            taskCount = resource.getUserCount();
        }
        dashBoardStatus.setUserTaskCount(taskCount);
        logger.debug((Object)"Creating work order display section");
        this.createProcessStatisticsDisplay(dashBoardStatus);
        this.createTokenStatisticsDisplay(dashBoardStatus);
        logger.debug((Object)"Creating drive status display");
        SANManagement sanManager = SANManager.getInstance();
        List<SANDrive> driveList = sanManager.getAllSANDrives();
        ArrayList<SANDriveDisplay> displayDriveList = new ArrayList<SANDriveDisplay>();
        if (driveList != null) {
            for (SANDrive drive : driveList) {
                displayDriveList.add(new SANDriveDisplay(drive));
            }
        }
        dashBoardStatus.setSANDrives(displayDriveList);
        logger.debug((Object)"Getting health status of system components");
        ResourceManagement resourceManager = ResourceManager.getInstance();
        ComponentHealthStatus rmStatus = resourceManager.getHealthStatus();
        dashBoardStatus.setResourceManagerHealthStatus(new HealthStatusDisplay(rmStatus));
        AlertSystemHealthManager alertManager = AlertSystemHealthManager.getInstance();
        ComponentHealthStatus systemHealthStatus = alertManager.getHealthStatus();
        dashBoardStatus.setSystemHealthStatus(new HealthStatusDisplay(systemHealthStatus));
        logger.debug((Object)"Creating resource group display");
        List<ResourceGroup> groupList = this.getVisibleResourceGroups();
        dashBoardStatus.setConfiguredResourceGroupCount(groupList.size());
        TableConfig tableConfig = TableConfig.getInstance();
        dashBoardStatus.setQueueTable(tableConfig.getTable(QUEUE_TABLE_ID));
        ArrayList<ResourceGroupDisplay> groupDisplayList = new ArrayList<ResourceGroupDisplay>();
        ArrayList<ResourceUsageDisplay> resourceUsageList = new ArrayList<ResourceUsageDisplay>();
        for (ResourceGroup group : groupList) {
            ResourceGroupDisplay rgDisplay = this.createResourceUsageDisplay(group);
            groupDisplayList.add(rgDisplay);
            resourceUsageList.addAll(rgDisplay.getResourceUsageList());
        }
        dashBoardStatus.setResourceGroupDisplayList(groupDisplayList);
        ResourceUsageForm usageForm = new ResourceUsageForm();
        ResourceUsageDisplayComparator comparator = new ResourceUsageDisplayComparator();
        String sortKey = dashBoardStatus.getSortingColumnName();
        if (sortKey == null || sortKey.trim().length() == 0) {
            sortKey = usageForm.getTable().getDefaultSortingColumn();
        }
        if ((sortType = this.getSortingOrder(dashBoardStatus.getSortingOrder())) == null) {
            sortType = this.getSortingOrder(usageForm.getTable().getDefaultSortingOrder());
        }
        comparator.setSortKey(sortKey);
        comparator.setSortType(sortType);
        Collections.sort(resourceUsageList, comparator);
        usageForm.setTotalRecords(resourceUsageList.size());
        usageForm.setSortingColumnName(sortKey);
        usageForm.setSortingOrder(sortType.toString());
        usageForm.setResourceUsageDisplayList(resourceUsageList);
        dashBoardStatus.setResourceUsageForm(usageForm);
        request.setAttribute("Search_Criteria", (Object)usageForm);
        return mapping.findForward(strForward);
    }

    private void createProcessStatisticsDisplay(DashBoardForm dashBoardStatus) {
        IProcessSearchService service = ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
        this.DASHBOARD_CUT_OFF_DATE = DashBoardAction.getCutOffDate();
        if (this.DASHBOARD_CUT_OFF_DATE == null) {
            dashBoardStatus.setCancelled(service.count(ProcessStatus.CANCELLED));
            dashBoardStatus.setStopped(service.count(ProcessStatus.COMPLETED));
            dashBoardStatus.setError(service.count(ProcessStatus.ERROR));
            dashBoardStatus.setPaused(service.count(ProcessStatus.PAUSED));
            dashBoardStatus.setQueued(service.count(ProcessStatus.QUEUED));
            dashBoardStatus.setActive(service.count(ProcessStatus.ACTIVE));
            dashBoardStatus.setBranched(service.count(ProcessStatus.BRANCHED));
        } else {
            dashBoardStatus.setCutOffDate(new SimpleDateFormat(DASHBOARD_CUT_OFF_DATE_FORMAT).format(this.DASHBOARD_CUT_OFF_DATE));
            dashBoardStatus.setCancelled(service.count(ProcessStatus.CANCELLED, this.DASHBOARD_CUT_OFF_DATE));
            dashBoardStatus.setStopped(service.count(ProcessStatus.COMPLETED, this.DASHBOARD_CUT_OFF_DATE));
            dashBoardStatus.setError(service.count(ProcessStatus.ERROR, this.DASHBOARD_CUT_OFF_DATE));
            dashBoardStatus.setPaused(service.count(ProcessStatus.PAUSED, this.DASHBOARD_CUT_OFF_DATE));
            dashBoardStatus.setQueued(service.count(ProcessStatus.QUEUED, this.DASHBOARD_CUT_OFF_DATE));
            dashBoardStatus.setActive(service.count(ProcessStatus.ACTIVE, this.DASHBOARD_CUT_OFF_DATE));
            dashBoardStatus.setBranched(service.count(ProcessStatus.BRANCHED, this.DASHBOARD_CUT_OFF_DATE));
        }
    }

    private void createTokenStatisticsDisplay(DashBoardForm form) {
        ITokenSearchService service = ServiceRegistry.getDefault().lookup(ITokenSearchService.class);
        SearchCriteria criteria = new SearchCriteria();
        criteria.addParameter(new ValueParameter("child", SearchType.STRING, Boolean.TRUE));
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        parameter.addValue((Object)ProcessStatus.BRANCHED);
        criteria.addParameter(parameter);
        Date cutOffDate = DashBoardAction.getCutOffDate();
        if (cutOffDate != null) {
            String date = new SimpleDateFormat("yyyy-MM-dd").format(cutOffDate);
            criteria.addParameter(new RangeParameter("start", SearchType.DATE, date));
        }
        for (ProcessStatus status : statuslist) {
            criteria.removeParameter("tokenstatus");
            parameter = new ListParameter("tokenstatus", SearchType.PROCESSSTATUS);
            if (status == ProcessStatus.ACTIVE) {
                parameter.addValues(new Object[]{ProcessStatus.CREATED, ProcessStatus.RUNNING, ProcessStatus.BUSY});
            } else {
                parameter.addValue((Object)status);
            }
            criteria.addParameter(parameter);
            form.addTokenStatistics(new TokenStatistics(status, service.count(criteria)));
        }
    }

    private ComponentHealthStatus getWeakestStatus(ComponentHealthStatus ... statusList) {
        if (statusList == null || statusList.length == 0) {
            return null;
        }
        ComponentHealthStatus weakestStatus = ComponentHealthStatus.OK;
        for (ComponentHealthStatus status : statusList) {
            if (status == null) continue;
            int weakestOrdinalValue = weakestStatus.ordinal();
            int statusOrdinalValue = status.ordinal();
            if (statusOrdinalValue <= weakestOrdinalValue) continue;
            weakestStatus = status;
        }
        return weakestStatus;
    }

    private ResourceGroupDisplay createResourceUsageDisplay(ResourceGroup group) {
        CustomToken token;
        EngineDriver engineDriver = EngineDriver.getInstance();
        IProgressTrackingStrategy progressTracker = engineDriver.getProgressTrackingStrategy();
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        ResourceGroupDisplay rgDisplay = new ResourceGroupDisplay(group);
        ArrayList<QueuedWorkOrderDisplay> queuedItems = new ArrayList<QueuedWorkOrderDisplay>();
        ArrayList<ResourceUsageDisplay> usageList = new ArrayList<ResourceUsageDisplay>();
        int queueSize = 0;
        for (ResourceGroupQueueItem queueItem : group.getQueue()) {
            long tokenId = queueItem.getTokenId();
            token = service.getToken(Long.valueOf(tokenId));
            if (token.getStatus() != ProcessStatus.QUEUED) continue;
            ++queueSize;
            if (queuedItems.size() >= 5) continue;
            queuedItems.add(new QueuedWorkOrderDisplay(queueItem, token));
        }
        rgDisplay.setQueueSize(Integer.toString(queueSize));
        rgDisplay.setQueuedItemList(queuedItems);
        for (Resource resource : group.getResources()) {
            for (ResourceUser user : resource.getUsers()) {
                if (user.getResourceGroupId() != group.getId() || (token = service.getToken(Long.valueOf(user.getId()))).getStatus() != ProcessStatus.BUSY && token.getStatus() != ProcessStatus.RUNNING) continue;
                String percentComplete = progressTracker.calculatePercentComplete(token);
                ResourceUsageDisplay ruDisplay = new ResourceUsageDisplay(resource, token);
                ruDisplay.setProgressStatus(percentComplete);
                usageList.add(ruDisplay);
            }
        }
        rgDisplay.setResourceUsageList(usageList);
        return rgDisplay;
    }

    private static Date getCutOffDate() {
        Date cutOffDate = null;
        int cutOffDuration = 0;
        ResourceBundle bundle = CommonUtils.getApplicationUIResourceBundle();
        try {
            cutOffDuration = Integer.parseInt(bundle.getString(DASHBOARD_CUT_OFF_DURATION));
            GregorianCalendar gregCal = new GregorianCalendar();
            gregCal.setTime(new Date());
            gregCal.add(5, -1 * cutOffDuration);
            cutOffDate = gregCal.getTime();
        }
        catch (Exception e) {
            logger.debug((Object)("Could not evaluate cut off date from duration " + cutOffDuration));
        }
        return cutOffDate;
    }

    private List<ResourceGroup> getVisibleResourceGroups() {
        ArrayList<ResourceGroup> visibleResourceGroups = new ArrayList<ResourceGroup>();
        List<ResourceGroup> resGrpList = ResourceManager.getInstance().getAllResourceGroups();
        if (resGrpList != null) {
            for (ResourceGroup resGrp : resGrpList) {
                if (resGrp == null || !resGrp.isVisible()) continue;
                logger.debug((Object)("Visible Resource Group Name: " + resGrp.getName()));
                visibleResourceGroups.add(resGrp);
            }
        }
        return visibleResourceGroups;
    }

    private SortingOrder getSortingOrder(String sortingOrder) {
        SortingOrder result;
        try {
            result = SortingOrder.valueOf(sortingOrder);
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }
}

