/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.util.SortingOrder;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.entities.PluginDTO;
import com.tandbergtv.workflow.web.formbeans.PluginForm;
import com.tandbergtv.workflow.web.util.PluginInfoHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PluginDispatchAction
extends BaseDispatchAction {
    private static final String DEFAULT_SORTING_COLUMN = "pluginsTable.columnname.PluginName";
    private static final String PLUGINS_CATEGORY_VAR = "pluginsCategory";
    private static final String PLUGINS_CATEGORY_RESOURCE_TYPE = "resourceType";
    private static final String PLUGINS_CATEGORY_RESOURCE_GROUP = "resourceGroup";
    private static final Logger logger = Logger.getLogger(PluginDispatchAction.class);
    private PluginDTOComparator dtoComparator = new PluginDTOComparator();
    private List<PluginDTO> resourceTypePlugins;
    private List<PluginDTO> resourceGroupPlugins;

    public ActionForward getResourceTypePlugins(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.resourceTypePlugins = PluginInfoHelper.getResourceTypePlugins();
        request.setAttribute(PLUGINS_CATEGORY_VAR, (Object)PLUGINS_CATEGORY_RESOURCE_TYPE);
        return this.processGetPlugins(this.resourceTypePlugins, mapping, form, request, response);
    }

    public ActionForward getResourceGroupPlugins(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.resourceGroupPlugins = PluginInfoHelper.getResourceGroupPlugins();
        request.setAttribute(PLUGINS_CATEGORY_VAR, (Object)PLUGINS_CATEGORY_RESOURCE_GROUP);
        return this.processGetPlugins(this.resourceGroupPlugins, mapping, form, request, response);
    }

    public ActionForward sortResourceTypePlugins(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute(PLUGINS_CATEGORY_VAR, (Object)PLUGINS_CATEGORY_RESOURCE_TYPE);
        return this.processSortPlugins(this.resourceTypePlugins, mapping, form, request, response);
    }

    public ActionForward sortResourceGroupPlugins(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute(PLUGINS_CATEGORY_VAR, (Object)PLUGINS_CATEGORY_RESOURCE_GROUP);
        return this.processSortPlugins(this.resourceGroupPlugins, mapping, form, request, response);
    }

    private ActionForward processGetPlugins(List<PluginDTO> plugins, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PluginForm pluginForm = (PluginForm)form;
        for (PluginDTO plugin : plugins) {
            if (plugin.getErrorMessages().size() != 0 || plugin.getErrorSummary() == null) continue;
            plugin.getErrorMessages().add(plugin.getErrorSummary());
        }
        pluginForm.setSortingColumnName(this.dtoComparator.getProperty(DEFAULT_SORTING_COLUMN));
        pluginForm.setSortingOrder(SortingOrder.ASCENDING.toString());
        this.dtoComparator.setColumnName(pluginForm.getSortingColumnName());
        Collections.sort(plugins, this.dtoComparator);
        pluginForm.setPlugins(plugins);
        return mapping.findForward("plugins");
    }

    private ActionForward processSortPlugins(List<PluginDTO> plugins, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PluginForm pluginForm = (PluginForm)form;
        String sortColumn = pluginForm.getSortingColumnName();
        this.dtoComparator.setColumnName(sortColumn);
        if (pluginForm.getSortingOrder().equals(SortingOrder.ASCENDING.toString())) {
            Collections.sort(plugins, this.dtoComparator);
        } else {
            Collections.sort(plugins, Collections.reverseOrder(this.dtoComparator));
        }
        pluginForm.setPlugins(plugins);
        return mapping.findForward("plugins");
    }

    class PluginDTOComparator
    implements Comparator {
        private static final String MESSAGE_RESOURCES_FILE = "./WorkFlowMessageResources.properties";
        private Properties PROPERTIES;
        String columnName;

        public int compare(Object o1, Object o2) {
            PluginDTO p1 = (PluginDTO)o1;
            PluginDTO p2 = (PluginDTO)o2;
            if (this.columnName.equals(this.getProperty(PluginDispatchAction.DEFAULT_SORTING_COLUMN))) {
                return p1.getPluginName().compareTo(p2.getPluginName());
            }
            if (this.columnName.equals(this.getProperty("pluginsTable.columnname.SystemID"))) {
                return p1.getSystemId().compareTo(p2.getSystemId());
            }
            if (this.columnName.equals(this.getProperty("pluginsTable.columnname.Status"))) {
                return p1.getStatus().compareTo(p2.getStatus());
            }
            if (this.columnName.equals(this.getProperty("pluginsTable.columnname.ErrorMessages"))) {
                if (p1.getErrorMessages().size() > 0 && p2.getErrorMessages().size() > 0) {
                    return p1.getErrorMessages().get(0).compareTo(p2.getErrorMessages().get(0));
                }
                if (p1.getErrorMessages().size() > 0) {
                    return p1.getErrorMessages().get(0).compareTo("");
                }
                if (p2.getErrorMessages().size() > 0) {
                    return p2.getErrorMessages().get(0).compareTo("");
                }
            }
            return 0;
        }

        public String getProperty(String key) {
            if (this.PROPERTIES == null) {
                try {
                    this.PROPERTIES = new Properties();
                    this.PROPERTIES.load(this.getClass().getClassLoader().getResourceAsStream(MESSAGE_RESOURCES_FILE));
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)"Could not find properties file ./WorkFlowMessageResources.properties", (Throwable)e);
                }
                catch (IOException e) {
                    logger.error((Object)"Error reading from ./WorkFlowMessageResources.properties", (Throwable)e);
                }
            }
            return this.PROPERTIES.getProperty(key);
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }
    }
}

