/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.formbeans.TaskForm;
import com.tandbergtv.workflow.web.util.ProcessHelper;
import com.tandbergtv.workflow.web.util.TaskFormParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class TaskDispatchAction
extends BaseDispatchAction {
    private static final Logger logger = Logger.getLogger(TaskDispatchAction.class);
    private static final String MULTIPLE_VALUES = "Multiple Values";
    private static final String EMPTY_STRING = "";
    private static final String NO_TASK_EXCEPTION = "No Task specified to show task details";
    private static final String TASKS_NOT_HOMOGENEOUS = "Selected tasks are not homogeneous";
    private static final String ERROR_NO_TASKS_SELECTED = "error.userTasks.noTaskSelected";
    private static final String ERROR_NOT_HOMOGENEOUS = "error.userTasks.notHomogeneous";
    private static final String ERROR_TASK_NOT_FOUND = "error.userTasks.noTask";
    private static final String TRUE = "true";

    public ActionForward selectTaskInstance(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.saveToken(request);
        TaskForm taskForm = (TaskForm)form;
        String[] tasks = taskForm.getTask();
        taskForm.reset();
        if (tasks == null) {
            logger.error((Object)new Exception(NO_TASK_EXCEPTION));
            return this.handleException(request, mapping, ERROR_NO_TASKS_SELECTED);
        }
        if (tasks.length == 1) {
            taskForm.setMultipleSelected(false);
            TaskIdentifier taskIdentifier = new TaskIdentifier(tasks[0]);
            try {
                TaskInstance taskInstance = ProcessHelper.getActiveTaskInstance(taskIdentifier.getProcessID(), taskIdentifier.getTaskInstanceID());
                taskForm.setName(taskInstance.getName());
                taskForm.setDescription(taskInstance.getDescription());
                taskForm.setTaskFormParameters(ProcessHelper.getTaskInstanceVariables(taskInstance));
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get task " + tasks[0]), (Throwable)e);
                return this.handleException(request, mapping, ERROR_TASK_NOT_FOUND);
            }
            return mapping.findForward("success");
        }
        Collection<TaskIdentifier> taskIdentifierList = this.getTaskIdentifiers(tasks);
        if (!this.isHomogeneous(taskIdentifierList)) {
            logger.error((Object)new Exception(TASKS_NOT_HOMOGENEOUS));
            return this.handleException(request, mapping, ERROR_NOT_HOMOGENEOUS);
        }
        taskForm.setMultipleSelected(true);
        boolean firstIteration = true;
        HashMap<String, Object> allTaskInstancesVariablesMap = new HashMap<String, Object>();
        List<TaskFormParameter> taskInstanceVariables = null;
        for (TaskIdentifier taskIdentifier : taskIdentifierList) {
            TaskInstance taskInstance = ProcessHelper.getActiveTaskInstance(taskIdentifier.getProcessID(), taskIdentifier.getTaskInstanceID());
            if (firstIteration) {
                taskForm.setName(taskInstance.getName());
                taskForm.setDescription(taskInstance.getDescription());
                firstIteration = false;
            }
            taskInstanceVariables = ProcessHelper.getTaskInstanceVariables(taskInstance);
            for (TaskFormParameter taskInstanceVariable : taskInstanceVariables) {
                String varName = taskInstanceVariable.getName();
                Object varValue = taskInstanceVariable.getParamValue();
                if (allTaskInstancesVariablesMap.containsKey(varName)) {
                    Object lastVarValue = allTaskInstancesVariablesMap.get(varName);
                    if (varValue != null && lastVarValue != null) {
                        if (varValue.equals(lastVarValue)) continue;
                        allTaskInstancesVariablesMap.put(varName, taskInstanceVariable.isWritable() ? EMPTY_STRING : MULTIPLE_VALUES);
                        continue;
                    }
                    if (varValue == null && lastVarValue == null) continue;
                    allTaskInstancesVariablesMap.put(varName, taskInstanceVariable.isWritable() ? EMPTY_STRING : MULTIPLE_VALUES);
                    continue;
                }
                allTaskInstancesVariablesMap.put(varName, varValue);
            }
        }
        for (TaskFormParameter taskInstanceVariable : taskInstanceVariables) {
            taskInstanceVariable.setParamValue(allTaskInstancesVariablesMap.get(taskInstanceVariable.getName()));
        }
        taskForm.setTaskFormParameters(taskInstanceVariables);
        return mapping.findForward("success");
    }

    public ActionForward saveTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse arg3) throws Exception {
        if (!this.isTokenValid(request, true)) {
            logger.debug((Object)"Duplicate form submission - redirecting to tasks list page...");
            return mapping.findForward("tasksList");
        }
        TaskForm taskForm = (TaskForm)form;
        logger.debug((Object)("saving the task parameters " + taskForm.getTaskFormParameters()));
        String[] tasks = taskForm.getTask();
        if (tasks == null) {
            logger.error((Object)new Exception(NO_TASK_EXCEPTION));
            return this.handleException(request, mapping, ERROR_NO_TASKS_SELECTED);
        }
        if (tasks.length == 1) {
            TaskIdentifier taskIdentifier = new TaskIdentifier(tasks[0]);
            logger.debug((Object)("Task: " + taskIdentifier));
            logger.debug((Object)("Task Form Parameters: " + taskForm.getTaskFormParameters()));
            Map<String, String> values = this.getValues(taskForm.getTaskFormParameters());
            logger.debug((Object)("Values: " + values));
            TaskInstance taskInstance = ProcessHelper.setVariables(taskIdentifier.getProcessID(), taskIdentifier.getTaskInstanceID(), values, true);
            ProcessHelper.saveProcess(taskInstance);
        } else {
            logger.debug((Object)("Task Form Parameters: " + taskForm.getTaskFormParameters()));
            Map<String, String> selectedValues = this.getSelectedValues(taskForm.getTaskFormParameters(), taskForm.getApplyToAll());
            for (TaskIdentifier taskIdentifier : this.getTaskIdentifiers(tasks)) {
                logger.debug((Object)("Task: " + taskIdentifier));
                logger.debug((Object)("Selected Values: " + selectedValues));
                TaskInstance taskInstance = ProcessHelper.setVariables(taskIdentifier.getProcessID(), taskIdentifier.getTaskInstanceID(), selectedValues, true);
                ProcessHelper.saveProcess(taskInstance);
            }
        }
        return mapping.findForward("tasksList");
    }

    public ActionForward saveAndCloseTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse arg3) throws Exception {
        if (!this.isTokenValid(request, true)) {
            logger.debug((Object)"Duplicate form submission - redirecting to tasks list page...");
            return mapping.findForward("tasksList");
        }
        TaskForm taskForm = (TaskForm)form;
        String[] tasks = taskForm.getTask();
        if (tasks == null) {
            logger.error((Object)new Exception(NO_TASK_EXCEPTION));
            return this.handleException(request, mapping, ERROR_NO_TASKS_SELECTED);
        }
        if (tasks.length == 1) {
            TaskIdentifier taskIdentifier = new TaskIdentifier(tasks[0]);
            TaskInstance taskInstance = ProcessHelper.setVariables(taskIdentifier.getProcessID(), taskIdentifier.getTaskInstanceID(), this.getValues(taskForm.getTaskFormParameters()), false);
            taskInstance.end();
        } else {
            Map<String, String> selectedValues = this.getSelectedValues(taskForm.getTaskFormParameters(), taskForm.getApplyToAll());
            for (TaskIdentifier taskIdentifier : this.getTaskIdentifiers(tasks)) {
                TaskInstance taskInstance = ProcessHelper.setVariables(taskIdentifier.getProcessID(), taskIdentifier.getTaskInstanceID(), selectedValues, false);
                taskInstance.end();
            }
        }
        return mapping.findForward("tasksList");
    }

    private Collection<TaskIdentifier> getTaskIdentifiers(String[] tasks) {
        ArrayList<TaskIdentifier> taskIdentifierList = new ArrayList<TaskIdentifier>();
        for (String task : tasks) {
            taskIdentifierList.add(new TaskIdentifier(task));
        }
        return taskIdentifierList;
    }

    private boolean isHomogeneous(Collection<TaskIdentifier> taskIdentifiers) throws Exception {
        String prevTemplateNodeID = null;
        for (TaskIdentifier taskIdentifier : taskIdentifiers) {
            String templateNodeID = ProcessHelper.getTemplateNodeID(taskIdentifier.getProcessID(), taskIdentifier.getTaskInstanceID());
            if (templateNodeID == null) {
                throw new Exception("No Task Instance found for ProcessID: " + taskIdentifier.getProcessID() + " | Task Instance ID: " + taskIdentifier.getTaskInstanceID());
            }
            if (prevTemplateNodeID == null) {
                prevTemplateNodeID = templateNodeID;
                continue;
            }
            if (templateNodeID.equals(prevTemplateNodeID)) continue;
            return false;
        }
        return true;
    }

    private Map<String, String> getValues(List<TaskFormParameter> params) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (TaskFormParameter tfp : params) {
            if (!tfp.isWritable()) continue;
            values.put(tfp.getLabel(), (String)tfp.getParamValue());
        }
        return values;
    }

    private Map<String, String> getSelectedValues(List<TaskFormParameter> taskFormParameters, String[] applyToAll) {
        HashMap<String, String> selectedValues = new HashMap<String, String>();
        int j = 0;
        for (TaskFormParameter tfp : taskFormParameters) {
            if (!tfp.isWritable() || !applyToAll[j++].equalsIgnoreCase(TRUE)) continue;
            selectedValues.put(tfp.getLabel(), (String)tfp.getParamValue());
        }
        return selectedValues;
    }

    private ActionForward handleException(HttpServletRequest request, ActionMapping mapping, String exception) {
        ActionMessages actionMessages = new ActionMessages();
        actionMessages.add("infoMessages", new ActionMessage(exception));
        this.saveMessages(request, actionMessages);
        return mapping.findForward("tasksList");
    }

    private static class TaskIdentifier {
        private long processID;
        private long taskInstanceID;

        public TaskIdentifier(String task) {
            StringTokenizer st = new StringTokenizer(task, ":");
            this.processID = Long.parseLong(st.nextToken());
            this.taskInstanceID = Long.parseLong(st.nextToken());
        }

        public long getProcessID() {
            return this.processID;
        }

        public long getTaskInstanceID() {
            return this.taskInstanceID;
        }

        public String toString() {
            return "PROCESS ID: " + this.processID + " | TASK INSTANCE ID: " + this.taskInstanceID;
        }
    }
}

