/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.EngineDriver;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.formbeans.WorkOrderTemplateForm;
import com.tandbergtv.workflow.web.util.TaskFormParameter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.taskmgmt.def.Task;

public class WorkOrderDispatchAction
extends BaseDispatchAction {
    private static final Logger logger = Logger.getLogger(WorkOrderDispatchAction.class);
    private final String noTemplateError = "Please select a template.";
    private static final String ERROR_MESSAGE = "error.templates.msg";
    private static final String INFO_MESSAGE = "infoMessages";

    public ActionForward createWorkOrderSetup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"Inside createWorkOrderSetup.");
        WorkOrderTemplateForm workOrderForm = (WorkOrderTemplateForm)form;
        workOrderForm.setTemplateName("");
        workOrderForm.setPriority(ProcessPriority.NORMAL.toString());
        return mapping.findForward("CreateWO");
    }

    public ActionForward selectTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"Inside selectTemplate.");
        WorkOrderTemplateForm workOrderForm = (WorkOrderTemplateForm)form;
        ITemplateLoaderService service = ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        String name = workOrderForm.getTemplateName();
        ActionMessages errors = new ActionMessages();
        if (name == null || name.length() == 0) {
            return this.handleInvalidateTemplateId(mapping, request);
        }
        WorkflowTemplate processTemplate = service.getProcessDefinitionByName(name);
        if (processTemplate != null) {
            workOrderForm.setWorkOrderParams(this.getProcessVariables(processTemplate));
        } else {
            workOrderForm.setTemplateName("");
            errors.add(INFO_MESSAGE, new ActionMessage(ERROR_MESSAGE, (Object)name));
            this.saveErrors(request, errors);
        }
        logger.debug((Object)"Saving token...");
        this.saveToken(request);
        return mapping.findForward("CreateWO");
    }

    public ActionForward createWorkOrder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkOrderTemplateForm workOrderForm = (WorkOrderTemplateForm)form;
        String name = workOrderForm.getTemplateName();
        if (!this.isTokenValid(request, true)) {
            workOrderForm.setTemplateName("");
            if (name == null || name.length() == 0) {
                return this.handleInvalidateTemplateId(mapping, request);
            }
            this.saveToken(request);
            return mapping.findForward("CreateWO");
        }
        if (name == null || name.length() == 0) {
            return this.handleInvalidateTemplateId(mapping, request);
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IProcessManagerService service = registry.lookup(IProcessManagerService.class);
        try {
            WorkflowTemplate template = registry.lookup(ITemplateLoaderService.class).getProcessDefinitionByName(name);
            ProcessPriority priority = ProcessPriority.valueOf(workOrderForm.getPriority());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            List<TaskFormParameter> parameters = this.getProcessVariables(template);
            String[] values = workOrderForm.getParamValue();
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    variables.put(parameters.get(i).getName(), values[i]);
                }
            }
            WorkflowProcess process = service.create(template, priority, variables).getProcessInstance();
            logger.info((Object)(process + ", template " + template.getName()));
            request.setAttribute("workOrderNumber", (Object)process.getId());
            Date duration = EngineDriver.getInstance().getProgressTrackingStrategy().calculateTime(process);
            String time = this.getEstimatedTime(duration);
            request.setAttribute("duration", (Object)time);
            service.start(process.getRootToken());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create workorder", (Throwable)e);
        }
        return mapping.findForward("WOCreated");
    }

    private ActionForward handleInvalidateTemplateId(ActionMapping mapping, HttpServletRequest request) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("Please select a template.", false));
        logger.debug((Object)"Adding error:Please select a template.");
        this.saveErrors(request, errors);
        return mapping.getInputForward();
    }

    private String getEstimatedTime(Date duration) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(duration);
        long hours = duration.getTime() / 3600000L;
        String time = hours + " hour(s) and " + c.get(12) + " minute(s)";
        return time;
    }

    private List<TaskFormParameter> getProcessVariables(ProcessDefinition processDef) {
        ArrayList<TaskFormParameter> processParams = new ArrayList<TaskFormParameter>();
        Task startTask = processDef.getTaskMgmtDefinition().getStartTask();
        if (startTask != null) {
            List taskVarList = startTask.getTaskController().getVariableAccesses();
            for (Object obj : taskVarList) {
                VariableAccess var = (VariableAccess)obj;
                TaskFormParameter parameter = new TaskFormParameter(var);
                processParams.add(parameter);
            }
        }
        return processParams;
    }
}

