/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.EngineDriver;
import com.tandbergtv.workflow.driver.IEngineDriver;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.log.WorkflowLogManager;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.formbeans.WorkOrderTaskDetailsForm;
import com.tandbergtv.workflow.web.formbeans.WorkOrderTaskForm;
import com.tandbergtv.workflow.web.formbeans.WorkflowMessageLogForm;
import com.tandbergtv.workflow.web.util.ExportUtility;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.graph.node.EndState;
import org.jbpm.graph.node.StartState;
import org.w3c.dom.Document;

public class WorkOrderTaskAction
extends BaseDispatchAction {
    private static final String FORWARD = "workOrderTaskView";
    private static final String FORWARD_TO_TASK_DETAILS = "workOrderTaskDetails";
    private static final Logger logger = Logger.getLogger(WorkOrderTaskAction.class);
    private static final String PROCESS_STATUS_ACTIVE_BUSY = "IN PROCESS";
    private static final String PROCESS_STATUS_PENDING = "PENDING";
    private static final String PERCENT_COMPLETE_0 = "0";
    private static final String PERCENT_COMPLETE_100 = "100";
    private IEngineDriver driver;
    private Map<String, List<WorkOrderTaskForm>> tokenTasksMap = new HashMap<String, List<WorkOrderTaskForm>>();

    public WorkOrderTaskAction() {
        this.driver = EngineDriver.getInstance();
    }

    public ActionForward getWorkOrderTask(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkOrderTaskForm form = (WorkOrderTaskForm)actionForm;
        long id = Long.parseLong(form.getWorkOrderNo());
        logger.debug((Object)("Receiving the WorkOrder ID " + id + " From WorkOrderForm"));
        WorkflowLogManager logger = WorkflowLogManager.getInstance();
        WorkflowProcess process = ServiceRegistry.getDefault().lookup(IPersistenceService.class).get(Long.valueOf(id));
        form.setProcess(process);
        Collection<WorkOrderTaskForm> currentTasks = this.getCurrentTasks(process);
        request.setAttribute("currTasks", currentTasks);
        List<CustomToken> tokens = process.findAllTokens();
        SearchCriteria criteria = form.getSearchCriteria();
        List<NodeLog> logs = logger.getHistoryTasks(tokens, criteria.getRecordsCount(), criteria.getStartingRecordNumber());
        List<WorkOrderTaskForm> forms = this.getWOTForms(logs);
        request.setAttribute("col", forms);
        form.setTotalRecords(logger.getHistoryTasksCount(tokens));
        request.setAttribute("Search_Criteria", (Object)form);
        if ("export".equals(request.getParameter("exportData"))) {
            ArrayList<WorkOrderTaskForm> allTasks = new ArrayList<WorkOrderTaskForm>();
            allTasks.addAll(currentTasks);
            allTasks.addAll(forms);
            new ExportUtility().exportDataToExcel(request, response, form, allTasks);
            return null;
        }
        return mapping.findForward(FORWARD);
    }

    private Collection<WorkOrderTaskForm> getCurrentTasks(WorkflowProcess process) {
        ArrayList<WorkOrderTaskForm> tasks = new ArrayList<WorkOrderTaskForm>();
        for (CustomToken token : process.findAllTokens()) {
            WorkOrderTaskForm taskForm;
            ProcessStatus status = token.getStatus();
            if (!token.isRoot() && status == ProcessStatus.COMPLETED) continue;
            tasks.add(this.getCurrentTask(token));
            if (token.hasActiveChildren() || status == ProcessStatus.CANCELLED || status == ProcessStatus.COMPLETED || (taskForm = this.getNextTask(token)) == null) continue;
            tasks.add(taskForm);
        }
        return tasks;
    }

    private WorkOrderTaskForm getCurrentTask(CustomToken token) {
        Node node = token.getCurrentNode();
        WorkOrderTaskForm currentTask = this.getWOTForm(node, token);
        logger.debug((Object)("Current Task: " + (Object)((Object)currentTask)));
        return currentTask;
    }

    private WorkOrderTaskForm getNextTask(CustomToken token) {
        if (token.getNode() instanceof EndState) {
            return null;
        }
        Node next = this.getNextNode(token);
        logger.debug((Object)("Next Node " + next.getName()));
        WorkOrderTaskForm nextTask = new WorkOrderTaskForm(next);
        nextTask.setResourceGroupName(this.getResourceGroupName(next));
        nextTask.setTaskStatus(PERCENT_COMPLETE_0);
        nextTask.setNodeOperationalStatus(PROCESS_STATUS_PENDING);
        nextTask.setBranchName(token.getName());
        return nextTask;
    }

    private Node getNextNode(CustomToken token) {
        Node nextNode = null;
        Node from = token.getNode();
        logger.debug((Object)("Node " + from.getName()));
        if (from.getSuperState() != null) {
            for (Object obj : from.getSuperState().getNodes()) {
                List transitions;
                Node node = (Node)obj;
                nextNode = this.getNextNode(node, transitions = node.getLeavingTransitions());
                if (nextNode == null) continue;
                return nextNode;
            }
        } else {
            List transitions = from.getLeavingTransitions();
            nextNode = this.getNextNode(from, transitions);
            if (nextNode != null) {
                return nextNode;
            }
        }
        throw new RuntimeException("Failed to find the next node after " + from.getName() + " of template " + from.getProcessDefinition().getName());
    }

    private Node getNextNode(Node from, Collection<Transition> transitions) {
        if (transitions == null || transitions.isEmpty()) {
            throw new RuntimeException("Node " + from.getName() + " of template " + from.getProcessDefinition().getName() + " does not have any leaving transitions");
        }
        for (Transition transition : transitions) {
            Node to = transition.getTo();
            logger.debug((Object)("Next " + to.getName() + " parent " + to.getSuperState()));
            if (to.getSuperState() != null) {
                if (from.getSuperState() == to.getSuperState()) continue;
                to = to.getSuperState();
            }
            return to;
        }
        return null;
    }

    private WorkOrderTaskForm getWOTForm(Node node, Token token) {
        long currentTaskMessagesKey;
        WorkOrderTaskForm form = new WorkOrderTaskForm(node, token);
        form.setResourceGroupName(this.getResourceGroupName(node));
        form.setTaskName(node.getName());
        form.setVisited(false);
        if (this.isShowLink(node) && (currentTaskMessagesKey = WorkflowLogManager.getInstance().getCurrentTaskMessagesKey(token, node)) != -1L) {
            form.setVisited(true);
            form.setCurrentTaskMessagesKey(currentTaskMessagesKey);
        }
        ProcessStatus status = ((CustomToken)token).getStatus();
        String percent = null;
        if (status == ProcessStatus.RUNNING || status == ProcessStatus.BUSY) {
            percent = this.driver.getProgressTrackingStrategy().calculatePercentComplete(token);
        } else if (status == ProcessStatus.COMPLETED) {
            percent = PERCENT_COMPLETE_100;
        }
        form.setTaskStatus(percent == null ? PERCENT_COMPLETE_0 : percent);
        Date startDate = node instanceof NodeGroup ? ((CustomToken)token).getSuperStateEnter() : (node instanceof StartState ? token.getStart() : token.getNodeEnter());
        form.setStartDate(startDate);
        String nodeOperationalStatus = status == ProcessStatus.RUNNING || status == ProcessStatus.BUSY ? PROCESS_STATUS_ACTIVE_BUSY : status.toString();
        form.setNodeOperationalStatus(nodeOperationalStatus);
        form.setBranchName(token.getName());
        return form;
    }

    private List<WorkOrderTaskForm> getWOTForms(List<NodeLog> jbpmNodeLogs) {
        ArrayList<WorkOrderTaskForm> forms = new ArrayList<WorkOrderTaskForm>();
        for (int i = 0; i < jbpmNodeLogs.size(); ++i) {
            NodeLog jbpmNodeLog = jbpmNodeLogs.get(i);
            WorkOrderTaskForm form = new WorkOrderTaskForm(jbpmNodeLog.getNode(), jbpmNodeLog.getToken());
            form.setResourceGroupName(this.getResourceGroupName(jbpmNodeLog.getNode()));
            form.setTaskName(jbpmNodeLog.getNode().getName());
            if (this.isShowLink(jbpmNodeLog.getNode())) {
                form.setVisited(true);
                form.setHistoryTaskMessagesKey(jbpmNodeLog.getId());
            } else {
                form.setVisited(false);
            }
            form.setTaskStatus(PERCENT_COMPLETE_100);
            form.setStartDate(jbpmNodeLog.getEnter());
            form.setEndDate(jbpmNodeLog.getLeave());
            form.setNodeOperationalStatus(ProcessStatus.COMPLETED.toString());
            if (form.getToken().getParent() != null) {
                form.setDepth(1);
                form.setBranchName(form.getToken().getName());
                this.categorizeAndHold(form);
                continue;
            }
            forms.addAll(this.getAndClearLists());
            forms.add(form);
        }
        forms.addAll(this.getAndClearLists());
        return forms;
    }

    private List<WorkOrderTaskForm> getAndClearLists() {
        ArrayList<WorkOrderTaskForm> tasks = new ArrayList<WorkOrderTaskForm>();
        Iterator<List<WorkOrderTaskForm>> iter = this.tokenTasksMap.values().iterator();
        while (iter.hasNext()) {
            tasks.addAll((Collection<WorkOrderTaskForm>)iter.next());
            iter.remove();
        }
        return tasks;
    }

    private void categorizeAndHold(WorkOrderTaskForm taskForm) {
        String tokenID = Long.toString(taskForm.getToken().getId());
        if (!this.tokenTasksMap.containsKey(tokenID)) {
            this.tokenTasksMap.put(tokenID, new ArrayList());
        }
        this.tokenTasksMap.get(tokenID).add(taskForm);
    }

    private boolean isShowLink(Node node) {
        if (node instanceof AutomaticTaskNode && ((AutomaticTaskNode)node).getResourceGroupID() != null) {
            return true;
        }
        if (node instanceof NodeGroup && ((NodeGroup)node).getResourceGroupID() != null) {
            return true;
        }
        return node instanceof StartState;
    }

    private String getResourceGroupName(Node node) {
        if (node instanceof ResourceGroupAware) {
            ResourceGroupAware aware = (ResourceGroupAware)node;
            ResourceGroup group = null;
            if (aware.getResourceGroupID() != null) {
                try {
                    group = ResourceManager.getInstance().getResourceGroup(aware.getResourceGroupID());
                }
                catch (FinderException e) {
                    logger.warn((Object)("Exception in finding resource group for id: " + aware.getResourceGroupID()), (Throwable)e);
                }
                if (group != null) {
                    logger.debug((Object)("Resource Group Name: " + group.getName()));
                    return group.getName();
                }
            }
        }
        return null;
    }

    public ActionForward getWorkOrderTaskDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<WorkflowMessageLog> listMessageLogs;
        WorkOrderTaskDetailsForm workOrderTaskDetailsForm = (WorkOrderTaskDetailsForm)form;
        SearchCriteria criteria = workOrderTaskDetailsForm.getSearchCriteria();
        String sortColumn = null;
        SortingOrder sortOrder = SortingOrder.DESCENDING;
        for (SearchParameterBase param : criteria.getSearchList()) {
            if (param.getSortingOrder() == null || param.isVarInstance()) continue;
            sortColumn = param.getFieldName();
            sortOrder = param.getSortingOrder();
        }
        int iteration = -1;
        int totalIterations = -1;
        if (workOrderTaskDetailsForm.getCurrentTaskMessagesKey() != -1L) {
            listMessageLogs = WorkflowLogManager.getInstance().getCurrentTaskMessages(workOrderTaskDetailsForm.getCurrentTaskMessagesKey(), criteria.getRecordsCount(), criteria.getStartingRecordNumber(), sortColumn, sortOrder);
            totalIterations = iteration = WorkflowLogManager.getInstance().getCurrentTaskIteration(workOrderTaskDetailsForm.getCurrentTaskMessagesKey());
        } else {
            listMessageLogs = WorkflowLogManager.getInstance().getHistoryTaskMessages(workOrderTaskDetailsForm.getHistoryTaskMessagesKey(), criteria.getRecordsCount(), criteria.getStartingRecordNumber(), sortColumn, sortOrder);
            totalIterations = WorkflowLogManager.getInstance().getHistoryTaskNumIterations(workOrderTaskDetailsForm.getHistoryTaskMessagesKey());
            if (totalIterations > 1) {
                iteration = WorkflowLogManager.getInstance().getHistoryTaskIteration(workOrderTaskDetailsForm.getHistoryTaskMessagesKey());
            }
        }
        if (iteration != -1 && totalIterations > 1) {
            workOrderTaskDetailsForm.setTaskName(workOrderTaskDetailsForm.getTaskName() + " [" + iteration + "/" + totalIterations + "]");
        }
        ArrayList<WorkflowMessageLogForm> logForms = new ArrayList<WorkflowMessageLogForm>();
        for (WorkflowMessageLog workflowMessageLog : listMessageLogs) {
            this.formatMessage(workflowMessageLog);
            WorkflowMessageLogForm workflowMessageLogForm = new WorkflowMessageLogForm(workflowMessageLog);
            String resourceName = "";
            if (workflowMessageLog.getResource() != null && workflowMessageLog.getResource().getName() != null) {
                resourceName = workflowMessageLog.getResource().getName();
            }
            workflowMessageLogForm.setResourceName(resourceName);
            String resourceGroupName = workOrderTaskDetailsForm.getResourceGroupName() != null ? workOrderTaskDetailsForm.getResourceGroupName() : "";
            workflowMessageLogForm.setResourceGroupName(resourceGroupName);
            logForms.add(workflowMessageLogForm);
        }
        workOrderTaskDetailsForm.setWorkflowMessageLogs(logForms);
        int iTotalRecords = workOrderTaskDetailsForm.getCurrentTaskMessagesKey() != -1L ? WorkflowLogManager.getInstance().getCurrentTaskMessagesCount(workOrderTaskDetailsForm.getCurrentTaskMessagesKey()) : WorkflowLogManager.getInstance().getHistoryTaskMessagesCount(workOrderTaskDetailsForm.getHistoryTaskMessagesKey());
        logger.debug((Object)("Total number of records -->" + iTotalRecords));
        workOrderTaskDetailsForm.setTotalRecords(iTotalRecords);
        WorkOrderTaskDetailsForm paginationAndSortingForm = workOrderTaskDetailsForm;
        request.setAttribute("Search_Criteria", (Object)paginationAndSortingForm);
        return mapping.findForward(FORWARD_TO_TASK_DETAILS);
    }

    private void formatMessage(WorkflowMessageLog messageLog) {
        String msg = messageLog.getMessage();
        if (msg != null) {
            try {
                Document xmlDoc = XMLDocumentUtility.loadXml(msg);
                StringWriter stringWriter = new StringWriter();
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                DOMSource source = new DOMSource(xmlDoc.getDocumentElement());
                StreamResult result = new StreamResult(stringWriter);
                transformer.transform(source, result);
                msg = stringWriter.getBuffer().toString();
                messageLog.setMessage(msg);
            }
            catch (Exception ex) {
                logger.warn((Object)"Failed to load the Message XML into a document.", (Throwable)ex);
            }
        }
    }
}

