/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.entities;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import com.tandbergtv.workflow.web.util.CommonUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class QueuedWorkOrderDisplay
implements Serializable {
    private static final long serialVersionUID = 4801516802050336824L;
    private String queueItemId;
    private String neighborItemUpId;
    private String neighborItemDownId;
    private String queueItemOrderNumber;
    private String processId;
    private String tokenId;
    private String processStatus;
    private String processAdminStatus;
    private String processTemplateName;
    private String workOrderPriority;
    private String workOrderPriorityId;
    private Map<String, Object> workOrderParameters;
    private static final String MISSING_PARAMETER_VALUE = "";

    public QueuedWorkOrderDisplay() {
    }

    public QueuedWorkOrderDisplay(ResourceGroupQueueItem queuedItem, CustomToken token) {
        this.queueItemId = Long.toString(queuedItem.getId());
        this.queueItemOrderNumber = Integer.toString(queuedItem.getOrderNumber());
        this.tokenId = Long.toString(token.getId());
        WorkflowProcess process = token.getProcessInstance();
        this.processId = Long.toString(process.getId());
        this.processTemplateName = process.getProcessDefinition().getFullName();
        ProcessPriority priority = process.getPriority();
        this.workOrderPriorityId = String.valueOf(priority.ordinal());
        this.workOrderPriority = priority.toString();
        this.processStatus = token.getStatus().toString();
        this.processAdminStatus = token.getRequestedStatus().toString();
        this.workOrderParameters = new HashMap<String, Object>();
        this.workOrderParameters.putAll(process.getContextInstance().getVariables());
    }

    public String getNeighborItemDownId() {
        return this.neighborItemDownId;
    }

    public void setNeighborItemDownId(String neighborItemDownId) {
        this.neighborItemDownId = neighborItemDownId;
    }

    public String getNeighborItemUpId() {
        return this.neighborItemUpId;
    }

    public void setNeighborItemUpId(String neighborItemUpId) {
        this.neighborItemUpId = neighborItemUpId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getQueueItemId() {
        return this.queueItemId;
    }

    public void setQueueItemId(String queueItemId) {
        this.queueItemId = queueItemId;
    }

    public String getQueueItemOrderNumber() {
        return this.queueItemOrderNumber;
    }

    public void setQueueItemOrderNumber(String queueItemOrderNumber) {
        this.queueItemOrderNumber = queueItemOrderNumber;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public Map<String, Object> getWorkOrderParameters() {
        return this.workOrderParameters;
    }

    public void setWorkOrderParameters(Map<String, Object> workOrderParameters) {
        this.workOrderParameters = workOrderParameters;
    }

    public String getWorkOrderPriority() {
        return this.workOrderPriority;
    }

    public void setWorkOrderPriority(String workOrderPriority) {
        this.workOrderPriority = workOrderPriority;
    }

    public String getWorkOrderPriorityId() {
        return this.workOrderPriorityId;
    }

    public void setWorkOrderPriorityId(String workOrderPriorityId) {
        this.workOrderPriorityId = workOrderPriorityId;
    }

    public String getProcessAdminStatus() {
        return this.processAdminStatus;
    }

    public void setProcessAdminStatus(String processAdminStatus) {
        this.processAdminStatus = processAdminStatus;
    }

    public String getProcessStatus() {
        return this.processStatus;
    }

    public void setProcessStatus(String processStatus) {
        this.processStatus = processStatus;
    }

    public String getProcessTemplateName() {
        return this.processTemplateName;
    }

    public void setProcessTemplateName(String processTemplateName) {
        this.processTemplateName = processTemplateName;
    }

    public String getParameterValue(String key) {
        Object paramValue;
        String value = MISSING_PARAMETER_VALUE;
        if (this.workOrderParameters != null && (paramValue = this.workOrderParameters.get(key)) != null) {
            if (paramValue instanceof Date) {
                String format = CommonUtils.getApplicationUIResourceBundle().getString("dateFormat");
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                value = dateFormat.format(paramValue);
            } else {
                value = paramValue.toString();
            }
        }
        return value;
    }

    public String toString() {
        return this.queueItemId;
    }
}

