/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.entities;

import com.tandbergtv.workflow.util.SortingOrder;
import com.tandbergtv.workflow.web.formbeans.ResourceForm;
import java.util.Comparator;

public class ResourceFormComparator
implements Comparator<ResourceForm> {
    private SortingOrder sortType = SortingOrder.ASCENDING;
    private String sortKey = null;
    public static final String RESOURCE_NAME_SORT_KEY = "name";
    public static final String CONNECTION_STRING_SORT_KEY = "connectionString";
    public static final String OPERATIONAL_STATUS_SORT_KEY = "operationalStatus";
    public static final String ADMIN_STATUS_SORT_KEY = "adminStatus";

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public SortingOrder getSortType() {
        if (this.sortType == null) {
            this.sortType = SortingOrder.ASCENDING;
        }
        return this.sortType;
    }

    public void setSortType(SortingOrder sortType) {
        this.sortType = sortType;
    }

    @Override
    public int compare(ResourceForm o1, ResourceForm o2) {
        int result = 0;
        if (o1 == o2) {
            result = 0;
        } else if (o1 == null) {
            result = 1;
        } else if (o2 == null) {
            result = -1;
        } else if (this.sortKey == null) {
            result = 0;
        } else if (this.sortKey.equals(RESOURCE_NAME_SORT_KEY)) {
            result = this.compareStringValues(o1.getName(), o2.getName());
        } else if (this.sortKey.equals(CONNECTION_STRING_SORT_KEY)) {
            result = this.compareStringValues(o1.getConnectionString(), o2.getConnectionString());
        } else if (this.sortKey.equals(OPERATIONAL_STATUS_SORT_KEY)) {
            result = this.compareStringValues(o1.getOperationalStatus(), o2.getOperationalStatus());
        } else if (this.sortKey.equals(ADMIN_STATUS_SORT_KEY)) {
            result = this.compareStringValues(o1.getAdminStatus(), o2.getAdminStatus());
        }
        if (this.getSortType() == SortingOrder.DESCENDING) {
            result *= -1;
        }
        return result;
    }

    private int compareStringValues(String o1, String o2) {
        int result = 0;
        result = o1 == o2 ? 0 : (o1 == null ? 1 : (o2 == null ? -1 : o1.compareTo(o2)));
        return result;
    }
}

