/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.entities;

import com.tandbergtv.workflow.util.SortingOrder;
import com.tandbergtv.workflow.web.entities.ResourceUsageDisplay;
import java.util.Comparator;

public class ResourceUsageDisplayComparator
implements Comparator<ResourceUsageDisplay> {
    private SortingOrder sortType = SortingOrder.ASCENDING;
    private String sortKey = null;
    public static final String RESOURCE_NAME_SORT_KEY = "resourceName";
    public static final String RESOURCE_ID_SORT_KEY = "resourceId";
    public static final String WORK_ORDER_ID_SORT_KEY = "workOrderId";
    public static final String TOKEN_ID_SORT_KEY = "tokenId";
    public static final String PROCESS_STATUS_SORT_KEY = "processStatus";
    public static final String PROCESS_ADMIN_STATUS_SORT_KEY = "processAdminStatus";
    public static final String PROGRESS_STATUS_SORT_KEY = "progressStatus";
    public static final String CURRENT_TASK_SORT_KEY = "task";

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public SortingOrder getSortType() {
        if (this.sortType == null) {
            this.sortType = SortingOrder.ASCENDING;
        }
        return this.sortType;
    }

    public void setSortType(SortingOrder sortType) {
        this.sortType = sortType;
    }

    @Override
    public int compare(ResourceUsageDisplay o1, ResourceUsageDisplay o2) {
        int result = 0;
        if (o1 == o2) {
            result = 0;
        } else if (o1 == null) {
            result = 1;
        } else if (o2 == null) {
            result = -1;
        } else if (this.sortKey == null) {
            result = 0;
        } else if (this.sortKey.equals(RESOURCE_NAME_SORT_KEY)) {
            result = this.compareStringValues(o1.getResourceName(), o2.getResourceName());
        } else if (this.sortKey.equals(RESOURCE_ID_SORT_KEY)) {
            result = this.compareStringNumericValues(o1.getResourceId(), o2.getResourceId());
        } else if (this.sortKey.equals(WORK_ORDER_ID_SORT_KEY)) {
            result = this.compareStringNumericValues(o1.getWorkOrderId(), o2.getWorkOrderId());
        } else if (this.sortKey.equals(TOKEN_ID_SORT_KEY)) {
            result = this.compareStringNumericValues(o1.getTokenId(), o2.getTokenId());
        } else if (this.sortKey.equals(PROCESS_STATUS_SORT_KEY)) {
            result = this.compareStringValues(o1.getProcessStatus(), o2.getProcessStatus());
        } else if (this.sortKey.equals(PROCESS_ADMIN_STATUS_SORT_KEY)) {
            result = this.compareStringValues(o1.getProcessAdminStatus(), o2.getProcessAdminStatus());
        } else if (this.sortKey.equals(PROGRESS_STATUS_SORT_KEY)) {
            result = this.compareStringNumericValues(o1.getProgressStatus(), o2.getProgressStatus());
        } else if (this.sortKey.equals(CURRENT_TASK_SORT_KEY)) {
            result = this.compareStringValues(o1.getTask(), o2.getTask());
        } else {
            Object param1 = o1.getWorkOrderParameters().get(this.sortKey);
            Object param2 = o2.getWorkOrderParameters().get(this.sortKey);
            result = this.compareObjects(param1, param2);
        }
        if (this.getSortType() == SortingOrder.DESCENDING) {
            result *= -1;
        }
        return result;
    }

    private int compareStringValues(String o1, String o2) {
        int result = 0;
        result = o1 == o2 ? 0 : (o1 == null ? 1 : (o2 == null ? -1 : o1.compareTo(o2)));
        return result;
    }

    private int compareStringNumericValues(String o1, String o2) {
        int result = 0;
        if (o1 == o2) {
            result = 0;
        } else if (o1 == null) {
            result = 1;
        } else if (o2 == null) {
            result = -1;
        } else {
            Long v1 = null;
            Long v2 = null;
            try {
                v1 = new Long(o1.trim());
            }
            catch (NumberFormatException nfe) {
                v1 = null;
            }
            try {
                v2 = new Long(o2.trim());
            }
            catch (NumberFormatException nfe) {
                v2 = null;
            }
            result = this.compareLongValues(v1, v2);
        }
        return result;
    }

    private int compareLongValues(Long v1, Long v2) {
        int result = 0;
        result = v1 == v2 ? 0 : (v1 == null ? 1 : (v2 == null ? -1 : v1.compareTo(v2)));
        return result;
    }

    private int compareObjects(Object o1, Object o2) {
        int result = 0;
        if (o1 == o2) {
            result = 0;
        } else if (o1 == null) {
            result = 1;
        } else if (o2 == null) {
            result = -1;
        } else if (o1 instanceof Comparable) {
            Comparable comparableObject = (Comparable)o1;
            result = comparableObject.compareTo(o2);
        } else {
            String s1 = o1.toString();
            String s2 = o2.toString();
            result = s1.compareTo(s2);
        }
        return result;
    }
}

