/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.entities;

import com.tandbergtv.workflow.sanmanager.entities.DriveCapacityUnit;
import com.tandbergtv.workflow.sanmanager.entities.DriveStatus;
import com.tandbergtv.workflow.sanmanager.entities.SANDrive;
import java.text.NumberFormat;

public class SANDriveDisplay {
    private String driveId;
    private String name;
    private String status;
    private String capacity;
    private String freePercentage;
    private String usedSpace;
    private static final String DRIVE_STATUS_PREFIX = "DriveStatus.";
    private static final String IMAGE_KEY_SUFFIX = ".img";
    private static final String TITLE_KEY_SUFFIX = ".title";
    private static final NumberFormat CAPACITY_FORMAT = SANDriveDisplay.createCapacityFormat();
    private static final NumberFormat FREE_PERCENT_FORMAT = SANDriveDisplay.createFreePercentFormat();
    private static final String ERROR_VALUE = "--";

    public SANDriveDisplay() {
    }

    public SANDriveDisplay(SANDrive drive) {
        if (drive == null) {
            return;
        }
        this.driveId = Long.toString(drive.getId());
        this.name = drive.getName();
        this.setStatus(drive.getStatus());
        this.setCapacity(drive.getDisplayCapacity(), drive.getDisplayUnit());
        this.setFormattedUsedSpace(drive.getUsedSpace());
        String percentage = SANDriveDisplay.calculateFreePercentage(drive);
        this.setFreePercentage(percentage);
    }

    public String getDriveId() {
        return this.driveId;
    }

    public void setDriveId(String driveId) {
        this.driveId = driveId;
    }

    public String getFreePercentage() {
        return this.freePercentage;
    }

    public void setFreePercentage(String freePercentage) {
        this.freePercentage = freePercentage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public String getUsedSpace() {
        return this.usedSpace;
    }

    public void setUsedSpace(String usedSpace) {
        this.usedSpace = usedSpace;
    }

    public String getStatusImageKey() {
        String key = this.status != null ? DRIVE_STATUS_PREFIX + this.status + IMAGE_KEY_SUFFIX : "";
        return key;
    }

    public String getStatusImageTitleKey() {
        String key = this.status != null ? DRIVE_STATUS_PREFIX + this.status + TITLE_KEY_SUFFIX : "";
        return key;
    }

    public void setStatus(DriveStatus driveStatus) {
        String statusValue = driveStatus != null ? driveStatus.toString() : null;
        this.setStatus(statusValue);
    }

    public void setCapacity(double driveCapacity, DriveCapacityUnit unit) {
        this.capacity = CAPACITY_FORMAT.format(driveCapacity);
        this.capacity = this.capacity + SANDriveDisplay.formatUnit(unit);
    }

    public void setFormattedUsedSpace(long usedSpace) {
        if (usedSpace < 0L) {
            this.usedSpace = ERROR_VALUE;
        } else {
            DriveCapacityUnit unit = DriveCapacityUnit.getBestDisplayUnit(usedSpace);
            double value = DriveCapacityUnit.convert(usedSpace, DriveCapacityUnit.BYTE, unit);
            this.usedSpace = CAPACITY_FORMAT.format(value);
            this.usedSpace = this.usedSpace + SANDriveDisplay.formatUnit(unit);
        }
    }

    public static String calculateFreePercentage(SANDrive drive) {
        String result = ERROR_VALUE;
        if (drive == null) {
            return result;
        }
        long capacity = drive.getCapacity();
        long usedSpace = drive.getUsedSpace();
        if (usedSpace < 0L) {
            return result;
        }
        double percentage = capacity > 0L ? (double)usedSpace / (double)capacity : 1.0;
        percentage = percentage > 1.0 ? 0.0 : 1.0 - percentage;
        percentage = Math.floor(percentage * 100.0);
        result = FREE_PERCENT_FORMAT.format(percentage) + "%";
        return result;
    }

    private static NumberFormat createCapacityFormat() {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(0);
        return format;
    }

    private static NumberFormat createFreePercentFormat() {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(0);
        format.setMinimumFractionDigits(0);
        return format;
    }

    private static String formatUnit(DriveCapacityUnit unit) {
        String result = "";
        switch (unit) {
            case BYTE: {
                result = "B";
                break;
            }
            case KILOBYTE: {
                result = "K";
                break;
            }
            case MEGABYTE: {
                result = "M";
                break;
            }
            case GIGABYTE: {
                result = "G";
                break;
            }
            case TERABYTE: {
                result = "T";
            }
        }
        return result;
    }
}

