/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.entities.santree;

import com.tandbergtv.workflow.web.entities.santree.ISANTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.webtree.TreeNode;
import org.webtree.data.BaseTreeNode;

public class SANTreeNode
extends BaseTreeNode
implements ISANTreeNode {
    protected int childCount = 0;
    protected List<ISANTreeNode> childList = new ArrayList<ISANTreeNode>();

    public SANTreeNode(String nodeId, String nodeName, int childCount) {
        this.name = nodeName;
        this.id = nodeId;
        this.setChildCount(childCount);
    }

    public int getChildCount() {
        return this.childCount;
    }

    protected void setChildCount(int children) {
        this.childCount = children <= 0 ? 0 : children;
    }

    public TreeNode[] getChildren() {
        TreeNode[] result = this.childList.toArray(new TreeNode[0]);
        return result;
    }

    public boolean hasChildren() {
        return this.childCount > 0;
    }

    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public List<ISANTreeNode> getSANChildren() {
        return this.childList;
    }

    @Override
    public void setSANChildren(List<? extends ISANTreeNode> childNodes) {
        this.childList.clear();
        if (childNodes != null) {
            this.childList.addAll(childNodes);
        }
    }

    @Override
    public void addSANChildNode(ISANTreeNode childNode) {
        if (childNode != null) {
            this.childList.add(childNode);
        }
    }

    @Override
    public void removeAllSANChildren() {
        this.childList.clear();
    }
}

