/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.entities.santree;

import java.net.URLEncoder;
import org.webtree.TreeNode;
import org.webtree.TreeRenderer;
import org.webtree.TreeView;
import org.webtree.renderer.HtmlRenderer;

public class SANTreeRenderer
extends HtmlRenderer
implements TreeRenderer {
    private static final String URL_VAR_SEPARATOR = "&";
    private static final String URL_VAR_SELECT = "select=";
    private static final String URL_VAR_COLLAPSE = "collapse=";
    private static final String URL_VAR_EXPAND = "expand=";
    private static final String URL_CHARACTER_ENCODING = "UTF8";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public StringBuffer showNavigation(TreeNode current, TreeView tview, int level, int childOrder, int totalSiblings, String background) throws Exception {
        String iconImage;
        String iconFile;
        StringBuffer result = new StringBuffer();
        int childCount = current.getChildCount();
        String currentNodeId = current.getId();
        boolean selected = tview.isNodeSelected(currentNodeId);
        boolean open = tview.isNodeOpen(currentNodeId);
        boolean descend = childCount > 0 && open;
        boolean lastChild = childOrder == totalSiblings - 1;
        StringBuilder selectURL = new StringBuilder();
        selectURL.append("<a href=\"");
        selectURL.append(tview.getSelfHref());
        selectURL.append(URL_VAR_SEPARATOR).append(URL_VAR_SELECT);
        selectURL.append(URLEncoder.encode(currentNodeId, URL_CHARACTER_ENCODING));
        selectURL.append("\">");
        StringBuilder branchURL = new StringBuilder();
        branchURL.append("<a href=\"");
        branchURL.append(tview.getSelfHref());
        if (descend) {
            branchURL.append(URL_VAR_SEPARATOR).append(URL_VAR_COLLAPSE);
        } else {
            branchURL.append(URL_VAR_SEPARATOR).append(URL_VAR_EXPAND);
        }
        branchURL.append(URLEncoder.encode(currentNodeId, URL_CHARACTER_ENCODING));
        branchURL.append("\">");
        int currentIndent = 0;
        result.append(this.getIndentString(currentIndent));
        result.append("<table width=100% cellspacing=0 cellpadding=0 border=0>");
        result.append(this.getIndentString(++currentIndent));
        result.append("<tr>");
        ++currentIndent;
        for (int i = 0; i < background.length(); ++i) {
            result.append(this.getIndentString(currentIndent));
            result.append("<td>");
            result.append("<img src=\"");
            if (background.charAt(i) == 'I') {
                result.append(this.getIconPath(tview, this.I_ICON));
            } else {
                result.append(this.getIconPath(tview, this.EMPTY_ICON));
            }
            result.append("\"");
            result.append(" width=").append(this.ICONWIDTH);
            result.append(" height=").append(this.ICONHEIGHT);
            result.append(" border=0 />");
            result.append("</td>");
        }
        result.append(this.getIndentString(currentIndent));
        result.append("<td>");
        if (childCount > 0) {
            result.append((CharSequence)branchURL);
            result.append("<img src=\"");
            if (level == 0) {
                iconFile = descend ? this.MINUS_ICON : this.PLUS_ICON;
                result.append(this.getIconPath(tview, iconFile));
            } else if (descend) {
                iconFile = lastChild ? this.LMINUS_ICON : this.TMINUS_ICON;
                result.append(this.getIconPath(tview, iconFile));
            } else {
                iconFile = lastChild ? this.LPLUS_ICON : this.TPLUS_ICON;
                result.append(this.getIconPath(tview, iconFile));
            }
            result.append("\"");
            result.append(" width=").append(this.ICONWIDTH);
            result.append(" height=").append(this.ICONHEIGHT);
            result.append(" border=0 />");
            result.append("</a>");
        } else {
            result.append("<img src=\"");
            iconFile = lastChild ? this.L_ICON : this.T_ICON;
            result.append(this.getIconPath(tview, iconFile));
            result.append("\"");
            result.append(" width=").append(this.ICONWIDTH);
            result.append(" height=").append(this.ICONHEIGHT);
            result.append(" border=0 />");
        }
        result.append("</td>");
        result.append(this.getIndentString(currentIndent));
        result.append("<td>");
        result.append((CharSequence)selectURL);
        result.append("<img src=\"");
        if (descend) {
            iconImage = selected ? this.FOLDERHIGH_ICON : this.FOLDER_ICON;
            result.append(this.getIconPath(tview, iconImage));
        } else {
            iconImage = selected ? this.MINUSFOLDERHIGH_ICON : this.MINUSFOLDER_ICON;
            result.append(this.getIconPath(tview, iconImage));
        }
        result.append("\"");
        result.append(" width=").append(this.ICONWIDTH);
        result.append(" height=").append(this.ICONHEIGHT);
        result.append(" border=0 />");
        result.append("</a>");
        result.append("</td>");
        result.append(this.getIndentString(currentIndent));
        result.append("<td width=100% class=\"");
        String cellStyle = selected ? this.SELECT_CELLSTYLE : this.CELLSTYLE;
        result.append(cellStyle);
        result.append("\">");
        result.append(this.TEXTSPACE);
        result.append((CharSequence)selectURL);
        result.append(current.getName());
        result.append("</a>");
        result.append("</td>");
        result.append(this.getIndentString(--currentIndent));
        result.append("</tr>");
        result.append(this.getIndentString(--currentIndent));
        result.append("</table>");
        if (descend) {
            String dropDownI = " ";
            if (level > 0 && !lastChild) {
                dropDownI = "I";
            }
            TreeNode[] children = current.getChildren();
            for (int i = 0; i < children.length; ++i) {
                result.append(this.showNavigation(children[i], tview, level + 1, i, childCount, background + dropDownI));
            }
        }
        return result;
    }

    private String getIconPath(TreeView view, String iconName) {
        String themeValue = view.getTheme() != null ? "/" + view.getTheme() : "";
        return view.getImagePath() + themeValue + "/" + iconName;
    }

    private String getIndentString(int indent) {
        StringBuilder result = new StringBuilder();
        result.append(LINE_SEPARATOR);
        for (int i = 0; i < indent; ++i) {
            result.append("\t");
        }
        return result.toString();
    }
}

