/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.formbeans;

import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import com.tandbergtv.workflow.web.formbeans.BaseForm;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.util.CommonUtils;
import java.util.ResourceBundle;

public abstract class PaginationAndSortingForm
extends BaseForm {
    private int totalRecords;
    private int numberOfPages;
    private final int defaultPageNo;
    private final int defaultPageSize;
    private final String pageSizes;
    private int maximumPageNumber;
    private SearchCriteria searchCriteria = new SearchCriteria();

    public PaginationAndSortingForm() {
        ResourceBundle rbPaginationConstants = CommonUtils.getApplicationUIResourceBundle();
        this.defaultPageNo = Integer.parseInt(rbPaginationConstants.getString("defaultPageNo"));
        this.defaultPageSize = Integer.parseInt(rbPaginationConstants.getString("defaultPageSize"));
        this.pageSizes = rbPaginationConstants.getString("pageSizes");
    }

    public SearchCriteria getSearchCriteria() {
        if (this.getSortingColumnType() == null || this.getSortingColumnType().trim().equals("")) {
            this.searchCriteria.addParameter(new SortParameter(this.getSortingColumnName(), SortingOrder.valueOf(this.getSortingOrder())));
        } else {
            this.searchCriteria.addParameter(new SortParameter(this.getSortingColumnName(), SortingOrder.valueOf(this.getSortingOrder()), SearchType.valueOf(this.getSortingColumnType())));
        }
        this.searchCriteria.setStartingRecordNumber((this.getCurrentPageNo() - 1) * this.getRecordsPerPage());
        this.searchCriteria.setRecordsCount(this.getRecordsPerPage());
        return this.searchCriteria;
    }

    @Override
    public int getCurrentPageNo() {
        if (super.getCurrentPageNo() <= 0) {
            this.setCurrentPageNo(this.defaultPageNo);
        } else if (this.getMaximumPageNumber() != 0 && super.getCurrentPageNo() > this.getMaximumPageNumber()) {
            this.setCurrentPageNo(this.getMaximumPageNumber());
        }
        return super.getCurrentPageNo();
    }

    private int getRecordsPerPage() {
        if (this.getPageSize() == 0) {
            return this.defaultPageSize;
        }
        return this.getPageSize();
    }

    public int getNumberOfPages() {
        this.numberOfPages = (int)Math.ceil((double)this.getTotalRecords() / (double)this.getRecordsPerPage());
        this.setMaximumPageNumber(this.numberOfPages);
        return this.numberOfPages;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
    }

    public String[] getPageSizes() {
        return this.pageSizes.split(",");
    }

    @Override
    public int getPageSize() {
        if (super.getPageSize() == 0) {
            return this.defaultPageSize;
        }
        return super.getPageSize();
    }

    public abstract Table getTable();

    protected abstract void setTable(String var1);

    public String getActionPath() {
        if (this.getTable() != null) {
            return this.getTable().getActionPath();
        }
        return null;
    }

    public int getMaximumPageNumber() {
        return this.maximumPageNumber;
    }

    public void setMaximumPageNumber(int maximumPageNumber) {
        this.maximumPageNumber = maximumPageNumber;
    }

    @Override
    public String getSortingColumnName() {
        if (super.getSortingColumnName().equals("") && this.getTable() != null) {
            return this.getTable().getDefaultSortingColumn();
        }
        return super.getSortingColumnName();
    }

    @Override
    public String getSortingOrder() {
        if (super.getSortingOrder().equals("") && this.getTable() != null) {
            return this.getTable().getDefaultSortingOrder();
        }
        return super.getSortingOrder();
    }
}

