/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.formbeans;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.web.actions.UserTasksAction;
import com.tandbergtv.workflow.web.formbeans.BaseForm;
import com.tandbergtv.workflow.web.formbeans.UserTaskGroup;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import com.tandbergtv.workflow.web.util.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserTasksForm
extends BaseForm {
    private static final Logger logger = Logger.getLogger(UserTasksAction.class);
    private static final String GROUPED = "userTasks.grouped";
    private static final boolean DEFAULT_GROUPING = false;
    private static final String TABLE_NAME = "UserTasksTable";
    private static boolean configuredGrouping;
    private Collection<UserTaskGroup> userTaskGroups;
    private Set<Resource> resourceList = new HashSet<Resource>();
    private Collection<String> templateNames = new HashSet<String>();
    private Collection<String> taskNames = new HashSet<String>();
    private String templateName = "";
    private String taskName = "";
    private String resource = null;
    private boolean grouped = configuredGrouping;
    private String groupKey;
    private Table table = TableConfig.getInstance().getTable("UserTasksTable");

    public Collection<UserTaskGroup> getUserTaskGroups() {
        return this.userTaskGroups;
    }

    public void setUserTaskGroups(Collection<UserTaskGroup> userTaskGroups) {
        this.userTaskGroups = this.insertionSort(userTaskGroups);
    }

    private List<UserTaskGroup> insertionSort(Collection<UserTaskGroup> userTaskGroups) {
        LinkedList<UserTaskGroup> sortedGroupsList = new LinkedList<UserTaskGroup>();
        for (UserTaskGroup groupInGivenCollection : userTaskGroups) {
            boolean added = false;
            for (int i = 0; i < sortedGroupsList.size(); ++i) {
                UserTaskGroup groupInSortedList = (UserTaskGroup)sortedGroupsList.get(i);
                int comparisonValue = this.compare(groupInGivenCollection, groupInSortedList);
                if (comparisonValue > 0) continue;
                sortedGroupsList.add(i, groupInGivenCollection);
                added = true;
                break;
            }
            if (added) continue;
            sortedGroupsList.add(groupInGivenCollection);
        }
        return sortedGroupsList;
    }

    private int compare(UserTaskGroup g1, UserTaskGroup g2) {
        return g1.getName().compareTo(g2.getName());
    }

    public Set<Resource> getResourceList() {
        return this.resourceList;
    }

    public void setResourceList(Set<Resource> resourceList) {
        this.resourceList = resourceList;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Collection<String> getTaskNames() {
        return this.taskNames;
    }

    public void setTaskNames(Collection<String> taskNames) {
        this.taskNames = taskNames;
    }

    public void addTaskName(String taskName) {
        if (this.taskNames == null) {
            this.taskNames = new ArrayList<String>();
        }
        this.taskNames.add(taskName);
    }

    public Collection<String> getTemplateNames() {
        return this.templateNames;
    }

    public void setTemplateNames(Collection<String> templateNames) {
        this.templateNames = templateNames;
    }

    public void addTemplateName(String templateName) {
        if (this.templateNames == null) {
            this.templateNames = new ArrayList<String>();
        }
        this.templateNames.add(templateName);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    static {
        try {
            ResourceBundle bundle = CommonUtils.getApplicationUIResourceBundle();
            configuredGrouping = Boolean.parseBoolean(bundle.getString(GROUPED));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in setting userTasks.grouped property. Setting grouping to: false", (Throwable)e);
            configuredGrouping = false;
        }
    }
}

