/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.formbeans;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.util.CaseInsensitiveComparator;
import com.tandbergtv.workflow.web.formbeans.BaseForm;
import com.tandbergtv.workflow.web.util.CommonUtils;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class WorkOrderForm
extends BaseForm {
    private static final long serialVersionUID = -3330630882508991353L;
    private WorkflowProcess process;
    private long id;
    private Date duration;
    private String priority = "";
    private List<ProcessPriority> priorityList = null;
    private String text;
    private static final Logger logger = Logger.getLogger(WorkOrderForm.class);

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }

    public String getDuration() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(this.duration);
        long hours = this.duration.getTime() / 3600000L;
        String value = hours + "h:" + c.get(12) + "m:" + c.get(13) + "s";
        return value;
    }

    public void setDuration(Date duration) {
        this.duration = duration;
    }

    public String getProcessDefinitionName() {
        return this.process.getProcessDefinition().getFullName();
    }

    public String getEnd() {
        return CommonUtils.formatTime(this.process.getEnd());
    }

    public Map getParameters() {
        Map parameters = this.process.getContextInstance().getVariables();
        if (parameters == null) {
            return new HashMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object o : parameters.keySet()) {
            Object value = parameters.get(o);
            if (value instanceof Date) {
                String dateValue = CommonUtils.formatDate((Date)value);
                hashMap.put((String)o, dateValue);
                logger.debug((Object)("Date Value: " + dateValue));
                continue;
            }
            hashMap.put((String)o, (String)value);
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(new CaseInsensitiveComparator());
        sortedMap.putAll(hashMap);
        return sortedMap;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getRequestedStatus() {
        return this.process.getRootToken().getRequestedStatus().toString();
    }

    public String getStart() {
        return CommonUtils.formatTime(this.process.getStart());
    }

    public String getStatus() {
        return this.process.getRootToken().getStatus().toString();
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public List<ProcessPriority> getPriorityList() {
        return this.priorityList;
    }

    public void setPriorityList(List<ProcessPriority> priorityList) {
        this.priorityList = priorityList;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

