/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.page;

import com.tandbergtv.workflow.auth.AuthorizationManager;
import com.tandbergtv.workflow.auth.ProtectionKey;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.web.page.Field;
import com.tandbergtv.workflow.web.page.Page;
import com.tandbergtv.workflow.web.util.CommonUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageConfig
implements Serializable {
    private static final long serialVersionUID = -4093319842848673616L;
    private static PageConfig pageConfig = null;
    private static final Logger logger = Logger.getLogger(PageConfig.class);
    private static final String PAGE_CONFIG_FILE_NAME = "search-page-config.xml";
    private static String PAGE_TAG_NAME = "page";
    private static String PAGE_NAME = "name";
    private HashMap<String, Page> pages = new HashMap();

    private PageConfig() {
    }

    public static synchronized PageConfig getInstance() throws Exception {
        if (pageConfig == null) {
            pageConfig = new PageConfig();
        }
        return pageConfig;
    }

    public Page getPage(String pageName) throws Exception {
        this.getPages();
        return this.pages.get(pageName);
    }

    private void getPages() throws Exception {
        String dir = ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath");
        String filename = dir + System.getProperty("file.separator") + PAGE_CONFIG_FILE_NAME;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(filename));
        Element element = doc.getDocumentElement();
        NodeList pageNodeList = element.getElementsByTagName(PAGE_TAG_NAME);
        Page page = null;
        ArrayList<Field> fields = null;
        HashMap<String, Field> fieldsMap = null;
        for (int i = 0; i < pageNodeList.getLength(); ++i) {
            page = new Page();
            page.setName(pageNodeList.item(i).getAttributes().getNamedItem(PAGE_NAME).getNodeValue());
            fields = new ArrayList<Field>();
            fieldsMap = new HashMap<String, Field>();
            if (pageNodeList.item(i).hasChildNodes()) {
                NodeList fieldNodeList = pageNodeList.item(i).getChildNodes();
                Field field = null;
                HashMap<String, String> hmFieldAttributes = new HashMap<String, String>();
                Map<String, String> hmOptions = null;
                for (int j = 0; j < fieldNodeList.getLength(); ++j) {
                    NamedNodeMap fieldAttributesMap;
                    field = new Field();
                    Node fieldNode = fieldNodeList.item(j);
                    NamedNodeMap namedNodeMap = fieldAttributesMap = fieldNode == null ? null : fieldNode.getAttributes();
                    if (field == null || fieldAttributesMap == null) continue;
                    hmFieldAttributes = new HashMap();
                    for (int m = 0; m < fieldAttributesMap.getLength(); ++m) {
                        hmFieldAttributes.put(fieldAttributesMap.item(m).getNodeName(), fieldAttributesMap.item(m).getNodeValue());
                    }
                    field.setAttributesMap(hmFieldAttributes);
                    if (fieldAttributesMap.getNamedItem("type").getNodeValue().equals("dropdown") || fieldAttributesMap.getNamedItem("type").getNodeValue().equals("list")) {
                        hmOptions = new LinkedHashMap<String, String>();
                        if (fieldAttributesMap.getNamedItem("source").getNodeValue().equals("xml")) {
                            NodeList optionsNodeList = fieldNode.getChildNodes();
                            for (int n = 0; n < optionsNodeList.getLength(); ++n) {
                                if (!optionsNodeList.item(n).getNodeName().equals("option")) continue;
                                hmOptions.put(optionsNodeList.item(n).getAttributes().getNamedItem("value").getNodeValue(), optionsNodeList.item(n).getAttributes().getNamedItem("text").getNodeValue());
                            }
                            field.setValuesMap(hmOptions);
                        } else if (fieldAttributesMap.getNamedItem("source").getNodeValue().equals("db")) {
                            hmOptions = this.getOptionsMap(fieldAttributesMap.getNamedItem("name").getNodeValue().trim());
                            field.setValuesMap(hmOptions);
                        }
                    }
                    fields.add(field);
                    fieldsMap.put(fieldAttributesMap.getNamedItem("name").getNodeValue().trim(), field);
                }
                page.setFields(fields);
                page.setFieldsMap(fieldsMap);
            }
            this.pages.put(page.getName(), page);
        }
        for (Map.Entry<String, Page> entry : this.pages.entrySet()) {
            logger.debug((Object)("Page Name-->" + entry.getKey()));
            for (Field element1 : this.pages.get(entry.getKey()).getFields()) {
                logger.debug((Object)("Attributes maps-->" + element1.getAttributesMap()));
                logger.debug((Object)("Option Values Map-->" + element1.getValuesMap()));
            }
        }
    }

    private Map<String, String> getOptionsMap(String fieldName) {
        Map<String, String> hmOptions = new LinkedHashMap<String, String>();
        if (fieldName.equals("workOrderTemplate")) {
            ITemplateLoaderService service = ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
            for (WorkflowTemplate template : service.getAllProcessDefinitions()) {
                hmOptions.put(String.valueOf(template.getId()), template.getFullName());
            }
            hmOptions = CommonUtils.sort(hmOptions);
        } else if (fieldName.equals("priority")) {
            List<ProcessPriority> lsProcessPriorities = Arrays.asList(ProcessPriority.values());
            for (ProcessPriority procPriority : lsProcessPriorities) {
                hmOptions.put(String.valueOf(procPriority.ordinal()), procPriority.toString().substring(0, 1).toUpperCase() + procPriority.toString().substring(1).toLowerCase());
            }
        } else if (fieldName.equals("resourceGroup")) {
            ResourceManagement resourceManagement = ResourceManager.getInstance();
            List<ResourceGroup> lsResourceGroups = resourceManagement.getAllResourceGroups();
            for (ResourceGroup group : lsResourceGroups) {
                hmOptions.put(String.valueOf(group.getId()), group.getName());
            }
            hmOptions = CommonUtils.sort(hmOptions);
        } else if (fieldName.equals("protectionKey")) {
            List<ProtectionKey> protectionKeys = AuthorizationManager.getInstance().getAllProtectionKeys();
            for (ProtectionKey protectionKey : protectionKeys) {
                hmOptions.put(String.valueOf(protectionKey.getId()), protectionKey.getName().substring(0, 1).toUpperCase() + protectionKey.getName().substring(1).toLowerCase());
            }
            hmOptions = CommonUtils.sort(hmOptions);
        }
        return hmOptions;
    }
}

