/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.repositorybrowser;

import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.ExtensionClassLoaderUtil;
import com.tandbergtv.workflow.web.repositorybrowser.FileNameToIDConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class RepositoryBrowserConfig {
    private static final Logger logger = Logger.getLogger(RepositoryBrowserConfig.class);
    private static final String CONFIG_FILE = "repositorybrowser-config.properties";
    private static final String PROPERTY_URL_PREFIX = "urlPrefix";
    private static final String PROPERTY_FILENAME_TO_ID_CONVERTER = "converterClass";
    private static final String PROPERTY_DIRS = "directories";
    private static RepositoryBrowserConfig _instance;
    private String urlPrefix;
    private String converterClassName;
    private FileNameToIDConverter converter;
    private List<String> directories = new ArrayList<String>();

    private RepositoryBrowserConfig() {
        try {
            this.loadConfiguration();
        }
        catch (Exception e) {
            logger.error((Object)"Configuration was not loaded properly. Search URLs will not be generated for repository browser files.", (Throwable)e);
        }
    }

    public static synchronized RepositoryBrowserConfig getInstance() {
        if (_instance == null) {
            _instance = new RepositoryBrowserConfig();
        }
        return _instance;
    }

    public String getSearchURL(String filePath) throws Exception {
        logger.debug((Object)("File Path: " + filePath));
        int fileSepLastIndex = filePath.lastIndexOf(File.separatorChar);
        String fileName = filePath.substring(fileSepLastIndex + 1);
        logger.debug((Object)("File Name: " + fileName));
        if (this.converter == null) {
            this.instantiateConverter();
        }
        String id = this.converter.convertToID(fileName);
        logger.debug((Object)("ID from converter: " + id));
        if (id == null) {
            return null;
        }
        return this.urlPrefix + id;
    }

    public boolean isLinkEnabled(String directory) {
        if ((directory = directory.toLowerCase()).endsWith(File.separator)) {
            directory = directory.substring(0, directory.length() - 1);
        }
        for (String configDir : this.directories) {
            if (configDir.endsWith("*")) {
                if (!directory.startsWith(configDir = configDir.substring(0, configDir.length() - 2))) continue;
                logger.debug((Object)("Directory: " + directory + " | Link Enabled: true"));
                return true;
            }
            if (!directory.equals(configDir)) continue;
            logger.debug((Object)("Directory: " + directory + " | Link Enabled: true"));
            return true;
        }
        logger.debug((Object)("Directory: " + directory + " | Link Enabled: false"));
        return false;
    }

    private void loadConfiguration() throws IOException {
        String dir = ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath");
        String filename = dir + System.getProperty("file.separator") + CONFIG_FILE;
        Properties props = new Properties();
        props.loadFromXML(new FileInputStream(new File(filename)));
        this.urlPrefix = props.getProperty(PROPERTY_URL_PREFIX);
        this.converterClassName = props.getProperty(PROPERTY_FILENAME_TO_ID_CONVERTER);
        this.directories = this.getDirectories(props.getProperty(PROPERTY_DIRS));
    }

    private List<String> getDirectories(String dirList) {
        ArrayList<String> directories = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(dirList, ",");
        while (st.hasMoreTokens()) {
            String directory = st.nextToken().trim().toLowerCase();
            if (directory.endsWith(File.separator)) {
                directory = directory.substring(0, directory.length() - 1);
            }
            logger.debug((Object)("Directory: " + directory));
            directories.add(directory);
        }
        return directories;
    }

    private synchronized void instantiateConverter() throws Exception {
        if (this.converter == null) {
            this.converter = (FileNameToIDConverter)ExtensionClassLoaderUtil.loadClass(this.converterClassName).newInstance();
        }
    }
}

