/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class CommonUtils {
    private static final Logger logger = Logger.getLogger(CommonUtils.class);
    private static final String FILE_NAME = "ApplicationUI";
    public static final String TIME_FORMAT = "timeFormat";
    public static final String DATE_FORMAT = "dateFormat";

    public static Map<String, String> sort(Map<String, String> map) {
        Map.Entry[] entries = new Map.Entry[map.entrySet().size()];
        entries = map.entrySet().toArray(entries);
        Arrays.sort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> lhs, Map.Entry<String, String> rhs) {
                return lhs.getValue().toUpperCase().compareTo(rhs.getValue().toString().toUpperCase());
            }
        });
        logger.debug((Object)("Before Sorting ---->" + map));
        map.clear();
        map = new LinkedHashMap<String, String>();
        for (int i = 0; i < entries.length; ++i) {
            map.put(((String)entries[i].getKey()).toString(), ((String)entries[i].getValue()).toString());
        }
        logger.debug((Object)("After Sorting---->" + map));
        return map;
    }

    public static String formatTime(Date date) {
        ResourceBundle rbTimeFormat = ResourceBundle.getBundle(FILE_NAME);
        String format = rbTimeFormat.getString(TIME_FORMAT);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        if (date != null) {
            return dateFormat.format(date);
        }
        return "";
    }

    public static synchronized ResourceBundle getApplicationUIResourceBundle() {
        return ResourceBundle.getBundle(FILE_NAME);
    }

    public static String formatDate(Date date) {
        ResourceBundle rbTimeFormat = ResourceBundle.getBundle(FILE_NAME);
        String format = rbTimeFormat.getString(DATE_FORMAT);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        if (date != null) {
            return dateFormat.format(date);
        }
        return "";
    }
}

