/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.core.graph.Graph;
import com.tandbergtv.workflow.web.formbeans.WorkOrderTaskForm;
import com.tandbergtv.workflow.web.util.BranchAndLoopNodePainter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;

public class GraphPainter {
    private Graph graph;

    public void paint(Graph graph, List<WorkOrderTaskForm> forms) {
        this.graph = graph;
        this.searchForLoopTraversal(new BranchAndLoopNodePainter(forms));
    }

    private void searchForLoopTraversal(BranchAndLoopNodePainter painter) {
        Queue<Node> roots = this.graph.getRoots();
        HashMap<Object, Boolean> traversed = new HashMap<Node, Boolean>();
        HashMap<Node, List<Node>> adjacencyMap = new HashMap<Node, List<Node>>();
        for (Node root : roots) {
            this.buildAdjacencyMap(root, traversed, adjacencyMap, painter);
        }
        painter.reorderTheForms(adjacencyMap);
        painter.populateAdjacencyMatrix(adjacencyMap);
        painter.findLongestPaths();
        for (Node node : adjacencyMap.keySet()) {
            traversed = new HashMap();
            List reachableNodeListPerNode = (List)adjacencyMap.get(node);
            if (reachableNodeListPerNode.size() != 2) continue;
            String loopName = "";
            this.iterateThroughNodes(node, traversed, adjacencyMap, painter, loopName);
        }
    }

    private void buildAdjacencyMap(Node node, Map<Node, Boolean> traversed, Map<Node, List<Node>> reachables, BranchAndLoopNodePainter painter) {
        traversed.put(node, true);
        painter.visit(node);
        if (node.getSuperState() == null) {
            List<Object> reachableNodeListPerNode = !reachables.containsKey(node) ? new ArrayList() : reachables.get(node);
            List transitions = node.getLeavingTransitions();
            reachables.put(node, reachableNodeListPerNode);
            if (transitions == null) {
                return;
            }
            for (Transition t : transitions) {
                Boolean visited;
                Node destination = t.getTo();
                if (destination.getSuperState() != null) {
                    reachableNodeListPerNode.add(destination.getSuperState());
                } else {
                    reachableNodeListPerNode.add(destination);
                }
                if ((visited = traversed.get(destination)) != null && visited.booleanValue()) continue;
                this.buildAdjacencyMap(destination, traversed, reachables, painter);
            }
        } else {
            SuperState superState = node.getSuperState();
            List transitions = node.getLeavingTransitions();
            List<Object> reachableNodeListPerNode = !reachables.containsKey(superState) ? new ArrayList() : reachables.get(superState);
            for (Transition t : transitions) {
                Node destination = t.getTo();
                if (destination.getSuperState() != null) {
                    if (!destination.getSuperState().getName().equals(superState.getName())) {
                        reachableNodeListPerNode.add(destination.getSuperState());
                    }
                } else if (!reachableNodeListPerNode.contains(destination)) {
                    reachableNodeListPerNode.add(destination);
                }
                reachables.put((Node)superState, reachableNodeListPerNode);
                Boolean visited = traversed.get(destination);
                if (visited != null && visited.booleanValue()) continue;
                this.buildAdjacencyMap(destination, traversed, reachables, painter);
            }
        }
    }

    private void iterateThroughNodes(Node node, Map<Node, Boolean> traversed, Map<Node, List<Node>> reachables, BranchAndLoopNodePainter painter, String loopName) {
        traversed.put(node, true);
        List<Node> reachableNodeListPerNode = reachables.get(node);
        if (reachableNodeListPerNode != null) {
            for (Node destination : reachableNodeListPerNode) {
                Boolean visited;
                String transitionName = this.getTransitionName(node, destination);
                String localLoopName = new String(loopName);
                if (transitionName != null && !transitionName.equals("")) {
                    localLoopName = localLoopName + "," + transitionName;
                }
                if ((visited = traversed.get(destination)) == null || !visited.booleanValue()) {
                    this.iterateThroughNodes(destination, traversed, reachables, painter, localLoopName);
                    continue;
                }
                ArrayList<Node> loopNodes = new ArrayList<Node>();
                this.checkForLoop(node, destination, traversed, painter, reachables, localLoopName, loopNodes);
            }
        }
    }

    private void checkForLoop(Node node, Node destination, Map<Node, Boolean> traversed, BranchAndLoopNodePainter painter, Map<Node, List<Node>> reachables, String loopNames, List<Node> loopNodes) {
        ArrayList<Node> loopNodeCopy = new ArrayList<Node>();
        loopNodeCopy.addAll(loopNodes);
        loopNodeCopy.add(destination);
        if (node.getId() != destination.getId()) {
            List<Node> reachableNodeListPerNode = reachables.get(destination);
            if (reachableNodeListPerNode != null) {
                for (Node nodeIter : reachableNodeListPerNode) {
                    if (loopNodeCopy.contains(nodeIter)) continue;
                    this.checkForLoop(node, nodeIter, traversed, painter, reachables, loopNames, loopNodeCopy);
                }
            }
        } else {
            painter.addLoopInfo(loopNames, loopNodeCopy);
        }
    }

    private String getTransitionName(Node source, Node destination) {
        String result;
        block2: {
            block3: {
                result = null;
                List transitions = source.getLeavingTransitions();
                if (transitions == null || transitions.size() <= 0) break block3;
                for (Transition t : transitions) {
                    Node iterNode = t.getTo();
                    if (destination.getId() != iterNode.getId()) continue;
                    result = t.getName();
                    break block2;
                }
                break block2;
            }
            Set arrivingTransitions = destination.getArrivingTransitions();
            if (arrivingTransitions == null) break block2;
            for (Transition t : arrivingTransitions) {
                SuperState iterNode = t.getFrom().getSuperState();
                if (iterNode == null || iterNode.getId() != source.getId()) continue;
                result = t.getName();
                break;
            }
        }
        return result;
    }
}

