/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.pluginmanager.WatchPointPluginManager;
import com.tandbergtv.workflow.pluginmanager.entities.FailureDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.web.entities.PluginDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PluginInfoHelper {
    private static final Logger logger = Logger.getLogger(PluginInfoHelper.class);
    private static final String ERROR_STATUS = "Error";
    private static final String ONLINE_STATUS = "Online";

    public static List<PluginDTO> getResourceTypePlugins() {
        ArrayList<PluginDTO> plugins = new ArrayList<PluginDTO>();
        List<ResourceTypeDescriptor> rtDescriptors = WatchPointPluginManager.getInstance().getResourceTypeDescriptors();
        for (ResourceTypeDescriptor descriptor : rtDescriptors) {
            PluginDTO pluginDTO = new PluginDTO();
            pluginDTO.setPluginId(descriptor.getPluginId());
            pluginDTO.setSystemId(descriptor.getSystemId());
            pluginDTO.setPluginName(descriptor.getName());
            pluginDTO.setDescription(descriptor.getDescription());
            pluginDTO.setStatus(ONLINE_STATUS);
            pluginDTO.setErrorMessages(new ArrayList<String>());
            plugins.add(pluginDTO);
        }
        List<FailureDescriptor> failedDescriptors = WatchPointPluginManager.getInstance().getFailureDescriptors();
        for (FailureDescriptor failedDescriptor : failedDescriptors) {
            PluginDTO pluginDTO = PluginInfoHelper.convert(failedDescriptor);
            plugins.add(pluginDTO);
        }
        List<ResourceTypeDescriptor> nonLicDescriptors = WatchPointPluginManager.getInstance().getNonLicensedDescriptors();
        for (ResourceTypeDescriptor nonLicDescriptor : nonLicDescriptors) {
            PluginDTO pluginDTO = new PluginDTO();
            pluginDTO.setPluginId(nonLicDescriptor.getPluginId());
            pluginDTO.setSystemId(nonLicDescriptor.getSystemId());
            pluginDTO.setPluginName(nonLicDescriptor.getName());
            pluginDTO.setDescription(nonLicDescriptor.getDescription());
            pluginDTO.setErrorSummary(nonLicDescriptor.getSummaryMessage());
            pluginDTO.setStatus(ERROR_STATUS);
            pluginDTO.setErrorMessages(new ArrayList<String>());
            plugins.add(pluginDTO);
        }
        return plugins;
    }

    public static List<PluginDTO> getResourceGroupPlugins() {
        ArrayList<PluginDTO> plugins = new ArrayList<PluginDTO>();
        List<FailureDescriptor> failedDescriptors = WatchPointPluginManager.getInstance().getFailedResourceGroupDescriptors();
        logger.debug((Object)("Failed Resource Group Descriptors Size: " + failedDescriptors.size()));
        for (FailureDescriptor failedDescriptor : failedDescriptors) {
            PluginDTO pluginDTO = PluginInfoHelper.convert(failedDescriptor);
            plugins.add(pluginDTO);
        }
        List<FailureDescriptor> missingDescriptors = WatchPointPluginManager.getInstance().getMissingResourceGroups();
        logger.debug((Object)("Missing Resource Group Descriptors Size: " + missingDescriptors.size()));
        for (FailureDescriptor descriptor : missingDescriptors) {
            if (!PluginInfoHelper.isFound(failedDescriptors, descriptor.getName())) {
                PluginDTO pluginDTO = PluginInfoHelper.convert(descriptor);
                plugins.add(pluginDTO);
                continue;
            }
            logger.debug((Object)("Ignoring missing resource group: " + descriptor.getName() + " as it is found to be failed loading"));
        }
        List<FailureDescriptor> unacceptedDescriptors = WatchPointPluginManager.getInstance().getUnacceptedResourceGroupDescriptors();
        logger.debug((Object)("Unaccepted Resource Group Descriptors Size: " + unacceptedDescriptors.size()));
        for (FailureDescriptor descriptor : unacceptedDescriptors) {
            PluginDTO pluginDTO = PluginInfoHelper.convert(descriptor);
            plugins.add(pluginDTO);
        }
        List<ResourceGroupDescriptor> rgDescriptors = WatchPointPluginManager.getInstance().getResourceGroupDescriptors();
        logger.debug((Object)("Resource Group Descriptors Size: " + rgDescriptors.size()));
        for (ResourceGroupDescriptor descriptor : rgDescriptors) {
            if (!PluginInfoHelper.isFound(unacceptedDescriptors, descriptor.getName())) {
                PluginDTO pluginDTO = new PluginDTO();
                pluginDTO.setPluginId(descriptor.getPluginId());
                pluginDTO.setSystemId(descriptor.getSystemId());
                pluginDTO.setPluginName(descriptor.getName());
                pluginDTO.setDescription(descriptor.getDescription());
                pluginDTO.setStatus(ONLINE_STATUS);
                pluginDTO.setErrorMessages(new ArrayList<String>());
                logger.debug((Object)("PluginDTO Name: " + pluginDTO.getPluginName()));
                plugins.add(pluginDTO);
                continue;
            }
            logger.debug((Object)("Ignoring successfully loaded descriptor: " + descriptor.getName() + "as it is found to be in unaccepted descriptors"));
        }
        logger.debug((Object)("PluginDTO List Size: " + plugins.size()));
        return new ArrayList<PluginDTO>(plugins);
    }

    private static boolean isFound(List<FailureDescriptor> descriptors, String name) {
        for (FailureDescriptor descriptor : descriptors) {
            if (descriptor == null || descriptor.getName() == null || !descriptor.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static PluginDTO convert(FailureDescriptor failedDescriptor) {
        PluginDTO pluginDTO = new PluginDTO();
        pluginDTO.setPluginId(failedDescriptor.getPluginId());
        pluginDTO.setSystemId(failedDescriptor.getId());
        pluginDTO.setPluginName(failedDescriptor.getName());
        pluginDTO.setErrorSummary(failedDescriptor.getSummaryMessage());
        pluginDTO.setErrorMessages(failedDescriptor.getErrorMessages());
        pluginDTO.setStatus(ERROR_STATUS);
        logger.debug((Object)("PluginDTO Name: " + pluginDTO.getPluginName()));
        return pluginDTO;
    }
}

