/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.util.ResourceConnectionTypeValidator;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.web.common.StaticCodes;
import com.tandbergtv.workflow.web.formbeans.BaseForm;
import com.tandbergtv.workflow.web.formbeans.ResourceForm;
import com.tandbergtv.workflow.web.formbeans.SearchForm;
import com.tandbergtv.workflow.web.formbeans.TaskForm;
import com.tandbergtv.workflow.web.formbeans.WorkOrderTemplateForm;
import com.tandbergtv.workflow.web.page.Page;
import com.tandbergtv.workflow.web.page.PageConfig;
import com.tandbergtv.workflow.web.util.TaskFormParameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.Resources;
import org.jbpm.taskmgmt.def.Task;

public class WebValidator {
    private static final String MESSAGE_RESOURCES_FILE = "./WorkFlowMessageResources.properties";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final char[] RESTRICTED_CHARS_IN_STRING_DATATYPE = new char[]{'\''};
    private static final String RESOURCE_CREATE_METHOD = "method=createResource";
    private static final String RESOURCE_UPDATE_METHOD = "method=updateResource";
    private static final String WORKORDER_SEARCH_METHOD = "method=getWorkOrdersBySearch";
    private static final String durationFormat = WebValidator.getDurationFormat();
    private static Properties PROPERTIES = null;
    private static final Logger logger = Logger.getLogger(WebValidator.class);
    private static List<TaskFormParameter> paramList = null;

    public static boolean validateWorkorderParams(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (request.getQueryString().equals("method=selectTemplate") || request.getQueryString().contains("method=selectTaskInstance")) {
            return true;
        }
        WebValidator.setupFormLists(obj, request);
        if (paramList == null) {
            return true;
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<String> paramValues = new ArrayList<String>();
        for (TaskFormParameter formParameter : paramList) {
            if (formParameter.isRequired) {
                if (formParameter.getParamValue() != null) {
                    paramValues.add(formParameter.getParamValue().toString());
                } else {
                    paramValues.add(null);
                }
                paramNames.add(formParameter.getLabel());
                logger.debug((Object)("adding for check: " + formParameter.getLabel() + " with value " + formParameter.getParamValue()));
                continue;
            }
            logger.debug((Object)("ignoring: " + formParameter.getLabel()));
        }
        boolean isValid = WebValidator.validateRequiredSet(paramValues, paramNames, field, msgs, obj);
        isValid = WebValidator.validateDataTypeSet(field, msgs) && isValid;
        return isValid;
    }

    public static boolean validateMaxLengthSet(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        boolean result = true;
        if (request.getQueryString().equals("method=selectTemplate") || request.getQueryString().contains("method=selectTaskInstance")) {
            return result;
        }
        WebValidator.setupFormLists(obj, request);
        if (paramList == null) {
            return result;
        }
        int max = Integer.parseInt(field.getVarValue("maxlength"));
        for (TaskFormParameter formParameter : paramList) {
            if (formParameter.getParamValue() == null || formParameter.getParamValue().toString().trim().length() <= max) continue;
            msgs.add(field.getKey(), new ActionMessage(formParameter.getLabel() + " cannot be greater than " + max + " characters.", false));
            logger.warn((Object)("Adding error message:" + formParameter.getLabel() + " cannot be greater than " + max + " characters."));
            result = false;
        }
        return result;
    }

    public static boolean validateStringArray(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (request.getQueryString().equals(RESOURCE_CREATE_METHOD) || request.getQueryString().equals(RESOURCE_UPDATE_METHOD)) {
            logger.debug((Object)"Validating the String Array lenth");
            ResourceForm form = (ResourceForm)((Object)obj);
            String[] strArrGroups = form.getResourceGroupIds();
            if (strArrGroups.length == 0) {
                logger.warn((Object)("Validation is  failed for the field-->" + field.getKey()));
                msgs.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)action, (Field)field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateConnectionType(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (request.getQueryString().equals(RESOURCE_CREATE_METHOD) || request.getQueryString().equals(RESOURCE_UPDATE_METHOD)) {
            try {
                ResourceForm form = (ResourceForm)((Object)obj);
                ResourceManagement resourceManager = ResourceManager.getInstance();
                ResourceType resourceType = resourceManager.getResourceType(Long.parseLong(form.getResourceTypeId()));
                boolean typeStatus = ResourceConnectionTypeValidator.validateConnectionString(form.getConnectionString().trim(), resourceType.getConnectionType());
                if (!typeStatus) {
                    msgs.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)action, (Field)field));
                    return false;
                }
            }
            catch (FinderException e) {
                logger.warn((Object)"while validating Connection Type-->", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static boolean validateHeartbeatConnectionTypeRequired(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (request.getQueryString().equals(RESOURCE_CREATE_METHOD) || request.getQueryString().equals(RESOURCE_UPDATE_METHOD)) {
            try {
                ResourceForm form = (ResourceForm)((Object)obj);
                ResourceManagement resourceManager = ResourceManager.getInstance();
                ResourceType resourceType = resourceManager.getResourceType(Long.parseLong(form.getResourceTypeId()));
                ResourceConnectionType heartBeatConnectionType = resourceType.getHeartbeatConnectionType();
                if (heartBeatConnectionType != null && (form.getHeartBeatConnectionString() == null || form.getHeartBeatConnectionString().trim().equals(""))) {
                    msgs.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)action, (Field)field));
                    return false;
                }
            }
            catch (FinderException e) {
                logger.warn((Object)"while validating  HeartbeatConnectionString -->", (Throwable)e);
            }
        }
        return true;
    }

    public static boolean validateHeartbeatConnectionTypeFormat(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (request.getQueryString().equals(RESOURCE_CREATE_METHOD) || request.getQueryString().equals(RESOURCE_UPDATE_METHOD)) {
            try {
                boolean typeStatus;
                ResourceForm form = (ResourceForm)((Object)obj);
                ResourceManagement resourceManager = ResourceManager.getInstance();
                ResourceType resourceType = resourceManager.getResourceType(Long.parseLong(form.getResourceTypeId()));
                ResourceConnectionType heartBeatConnectionType = resourceType.getHeartbeatConnectionType();
                if (heartBeatConnectionType != null && form.getHeartBeatConnectionString() != null && !(typeStatus = ResourceConnectionTypeValidator.validateConnectionString(form.getHeartBeatConnectionString().trim(), resourceType.getHeartbeatConnectionType()))) {
                    msgs.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)action, (Field)field));
                    return false;
                }
            }
            catch (FinderException e) {
                logger.warn((Object)"while validating  HeartbeatConnectionString -->", (Throwable)e);
            }
        }
        return true;
    }

    public static boolean validateHeartbeatFrequencyRequired(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (request.getQueryString().equals(RESOURCE_CREATE_METHOD) || request.getQueryString().equals(RESOURCE_UPDATE_METHOD)) {
            try {
                ResourceForm form = (ResourceForm)((Object)obj);
                ResourceManagement resourceManager = ResourceManager.getInstance();
                ResourceType resourceType = resourceManager.getResourceType(Long.parseLong(form.getResourceTypeId()));
                ResourceConnectionType heartBeatConnectionType = resourceType.getHeartbeatConnectionType();
                if (heartBeatConnectionType != null && (form.getHeartBeatFrequency() == null || form.getHeartBeatFrequency().trim().equals(""))) {
                    msgs.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)action, (Field)field));
                    return false;
                }
            }
            catch (FinderException e) {
                logger.warn((Object)"while validating  Heartbeat Frequency -->", (Throwable)e);
            }
        }
        return true;
    }

    public static boolean validateHeartbeatFrequencyRange(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        block6: {
            if (request.getQueryString().equals(RESOURCE_CREATE_METHOD) || request.getQueryString().equals(RESOURCE_UPDATE_METHOD)) {
                try {
                    ResourceForm form = (ResourceForm)((Object)obj);
                    ResourceManagement resourceManager = ResourceManager.getInstance();
                    ResourceType resourceType = resourceManager.getResourceType(Long.parseLong(form.getResourceTypeId()));
                    ResourceConnectionType heartBeatConnectionType = resourceType.getHeartbeatConnectionType();
                    if (heartBeatConnectionType == null || form.getHeartBeatFrequency() == null) break block6;
                    try {
                        int i = Integer.parseInt(form.getHeartBeatFrequency());
                        if (i < 1 || i > Integer.MAX_VALUE) {
                            msgs.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)action, (Field)field));
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        msgs.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)action, (Field)field));
                        return false;
                    }
                }
                catch (FinderException e) {
                    logger.warn((Object)"while validating  Heartbeat Frequency -->", (Throwable)e);
                }
            }
        }
        return true;
    }

    public static boolean validateSearchForm(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) throws Exception {
        boolean isValid = true;
        if (!request.getQueryString().equals(WORKORDER_SEARCH_METHOD)) {
            return isValid;
        }
        SearchForm searchForm = (SearchForm)((Object)obj);
        HashMap<String, Object> searchData = searchForm.getSearchData();
        Page page = PageConfig.getInstance().getPage(StaticCodes.WORKORDER_SEARCH_PAGE);
        for (com.tandbergtv.workflow.web.page.Field searchField : page.getFields()) {
            String paramName = searchField.getAttribute("name");
            String paramType = searchField.getAttribute("paramType");
            String dataType = searchField.getAttribute("dataType");
            String label = searchField.getAttribute("label");
            if (paramType.equals("value")) {
                isValid = WebValidator.validateSearchField(paramName, dataType, searchData.get(paramName), field, label, msgs) && isValid;
                continue;
            }
            if (!paramType.equals("range")) continue;
            String[] value = (String[])searchData.get(paramName);
            boolean isFirstValid = WebValidator.validateSearchField(paramName, dataType, value[0], field, label, msgs);
            boolean isSecondValid = WebValidator.validateSearchField(paramName, dataType, value[1], field, label, msgs);
            boolean isRangeValid = WebValidator.isValidRange(value[0], value[1], dataType, field, label, msgs);
            isValid = isValid && isFirstValid && isSecondValid && isRangeValid;
        }
        return isValid;
    }

    private static boolean validateSearchField(String paramName, String dataType, Object value, Field field, String label, ActionMessages msgs) {
        boolean isValid = true;
        if (dataType == null || dataType.equals("")) {
            msgs.add(field.getKey(), new ActionMessage(WebValidator.getProperty(label) + " does not have a datatype associated with it.", false));
            logger.warn((Object)("Adding error message:" + WebValidator.getProperty(label) + " does not have a datatype associated with it."));
            isValid = false;
        } else {
            if (value == null || value.toString().trim().equals("")) {
                value = "";
                return isValid;
            }
            if (dataType.equalsIgnoreCase(SearchType.STRING.name())) {
                String valueStr = value.toString();
                for (char restrictedChar : RESTRICTED_CHARS_IN_STRING_DATATYPE) {
                    if (valueStr.indexOf(restrictedChar) <= -1) continue;
                    msgs.add(field.getKey(), new ActionMessage(WebValidator.getProperty(label) + " contains restricted character: " + restrictedChar, false));
                    logger.warn((Object)("Adding error message:" + WebValidator.getProperty(label) + " contains restricted character: " + restrictedChar));
                    isValid = false;
                    break;
                }
            } else if (dataType.equalsIgnoreCase(SearchType.NUMERIC.toString())) {
                try {
                    double num = Double.parseDouble(value.toString());
                    if (num < 1.0 && num > 1.0E18) {
                        msgs.add(field.getKey(), new ActionMessage(WebValidator.getProperty(label) + " must be between 1 and 999999999999999999.", false));
                        logger.warn((Object)("Adding error message:" + WebValidator.getProperty(label) + " must be between 1 and 999999999999999999."));
                    }
                }
                catch (NumberFormatException ex) {
                    msgs.add(field.getKey(), new ActionMessage(WebValidator.getProperty(label) + " must be a valid integer.", false));
                    logger.warn((Object)("Adding error message:" + WebValidator.getProperty(label) + " must be a valid integer."));
                    isValid = false;
                }
            } else if (dataType.equalsIgnoreCase(SearchType.DATE.toString()) && !WebValidator.isValidDate(value.toString())) {
                msgs.add(field.getKey(), new ActionMessage(WebValidator.getProperty(label) + " should be a valid date in the correct format(" + DATE_FORMAT + ").", false));
                logger.warn((Object)("Adding error message:" + WebValidator.getProperty(label) + " should be a valid date in the correct format(" + DATE_FORMAT + ")."));
                isValid = false;
            }
        }
        return isValid;
    }

    private static String getProperty(String key) {
        if (PROPERTIES == null) {
            try {
                PROPERTIES = new Properties();
                PROPERTIES.load(WebValidator.class.getClassLoader().getResourceAsStream(MESSAGE_RESOURCES_FILE));
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"Could not find properties file ./WorkFlowMessageResources.properties", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"Error reading from ./WorkFlowMessageResources.properties", (Throwable)e);
            }
        }
        return PROPERTIES.getProperty(key);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean validateRequiredSet(List<String> params, List<String> paramNames, Field field, ActionMessages msgs, Object obj) {
        logger.debug((Object)("list of paramnNmes: " + paramNames));
        logger.debug((Object)("list of params: " + params));
        boolean noErrors = true;
        int i = 0;
        while (true) {
            block5: {
                block2: {
                    block3: {
                        block4: {
                            if (i >= paramNames.size()) {
                                return noErrors;
                            }
                            if (params.get(i) == null || params.get(i).trim().equals("")) break block2;
                            if (!(obj instanceof TaskForm)) break block3;
                            TaskForm taskForm = (TaskForm)((Object)obj);
                            if (!taskForm.getMultipleSelected()) break block4;
                            String applyToAll = taskForm.getApplyToAll(paramNames.get(i));
                            if (applyToAll == null || !applyToAll.equalsIgnoreCase("true")) break block2;
                            logger.debug((Object)(paramNames.get(i) + " = " + params.get(i) + "."));
                            break block5;
                        }
                        logger.debug((Object)(paramNames.get(i) + " = " + params.get(i) + "."));
                        break block5;
                    }
                    logger.debug((Object)(paramNames.get(i) + " = " + params.get(i) + "."));
                    break block5;
                }
                msgs.add(field.getKey(), new ActionMessage(paramNames.get(i) + " is required.", false));
                logger.warn((Object)("Adding error message:" + paramNames.get(i) + " is required."));
                noErrors = false;
            }
            ++i;
        }
    }

    private static boolean validateDataTypeSet(Field field, ActionMessages msgs) {
        boolean noErrors = true;
        for (int i = 0; i < paramList.size(); ++i) {
            noErrors = WebValidator.validateField(paramList.get(i), field, msgs) && noErrors;
        }
        return noErrors;
    }

    private static List<TaskFormParameter> setupFormLists(Object obj, HttpServletRequest request) {
        BaseForm form;
        if (request.getRequestURI().equals("/workflow/wfsprocess.do")) {
            form = (WorkOrderTemplateForm)((Object)obj);
            paramList = new ArrayList<TaskFormParameter>();
            String[] values = ((WorkOrderTemplateForm)form).getParamValue();
            String name = ((WorkOrderTemplateForm)form).getTemplateName();
            WorkflowTemplate template = ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class).getProcessDefinitionByName(name);
            Task task = template.getTaskMgmtDefinition().getStartTask();
            if (task != null) {
                List variables = task.getTaskController().getVariableAccesses();
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    TaskVariable variable = (TaskVariable)((Object)variables.get(i));
                    TaskFormParameter parameter = new TaskFormParameter(variable, value);
                    paramList.add(parameter);
                }
            }
            ((WorkOrderTemplateForm)form).setTemplateName(name);
            ((WorkOrderTemplateForm)form).setPriority(((WorkOrderTemplateForm)form).getPriority());
            ((WorkOrderTemplateForm)form).setWorkOrderParams(paramList);
        }
        if (request.getRequestURI().equals("/workflow/wfstask.do")) {
            form = (TaskForm)((Object)obj);
            paramList = ((TaskForm)form).getTaskFormParameters();
        }
        return null;
    }

    private static boolean validateField(TaskFormParameter param, Field field, ActionMessages msgs) {
        boolean isValid = true;
        if (param.getType() == null || param.getType().equals("")) {
            msgs.add(field.getKey(), new ActionMessage(param.getLabel() + " does not have a datatype associated with it.", false));
            logger.warn((Object)("Adding error message:" + param.getLabel() + " does not have a datatype associated with it."));
            isValid = false;
        } else {
            if (param.getParamValue() == null || param.getParamValue().toString().equals("")) {
                return isValid;
            }
            if (param.getType().equalsIgnoreCase(Datatype.INT.toString())) {
                try {
                    Integer.parseInt(param.getParamValue().toString());
                }
                catch (NumberFormatException ex) {
                    msgs.add(field.getKey(), new ActionMessage(param.getLabel() + " must be a valid integer.", false));
                    logger.warn((Object)("Adding error message:" + param.getLabel() + " must be a valid integer."));
                    isValid = false;
                }
            } else if (param.getType().equalsIgnoreCase(Datatype.BOOLEAN.toString())) {
                if (!param.getParamValue().toString().equals("true") && !param.getParamValue().toString().equals("false")) {
                    msgs.add(field.getKey(), new ActionMessage(param.getLabel() + " must be true or false.", false));
                    logger.warn((Object)("Adding error message:" + param.getLabel() + " must be true or false."));
                    isValid = false;
                }
            } else if (param.getType().equalsIgnoreCase(Datatype.DESTINATION.toString())) {
                if (!WebValidator.folderExists(param.getParamValue().toString())) {
                    msgs.add(field.getKey(), new ActionMessage(param.getLabel() + " is incorrect. " + param.getParamValue() + " is an invalid file or path.", false));
                    logger.warn((Object)("Adding error message:" + param.getLabel() + " is incorrect. " + param.getParamValue() + " is an invalid file or path."));
                    isValid = false;
                }
            } else if (param.getType().equalsIgnoreCase(Datatype.DATE.toString())) {
                if (!WebValidator.isValidDate(param.getParamValue().toString())) {
                    msgs.add(field.getKey(), new ActionMessage(param.getLabel() + " should be a valid date in the correct format(" + DATE_FORMAT + ").", false));
                    logger.warn((Object)("Adding error message:" + param.getLabel() + " should be a valid date in the correct format(" + DATE_FORMAT + ")."));
                    isValid = false;
                }
            } else if (param.getType().equalsIgnoreCase(Datatype.DURATION.toString()) && !WebValidator.isValidDuration(param.getParamValue().toString())) {
                msgs.add(field.getKey(), new ActionMessage(param.getLabel() + " is not in the correct format(" + durationFormat + ").", false));
                logger.warn((Object)("Adding error message:" + param.getLabel() + " is not in the correct format(" + durationFormat + ")."));
                isValid = false;
            }
        }
        return isValid;
    }

    private static boolean folderExists(String filePath) {
        File file = new File(filePath);
        if (filePath.length() > 2 && (filePath.substring(2).lastIndexOf("//") != -1 || filePath.substring(2).lastIndexOf("\\\\") != -1)) {
            return false;
        }
        if (file.getParent() == null) {
            return false;
        }
        File dir = new File(file.getParent());
        return !file.isDirectory() && dir.isDirectory() && dir.exists() && dir.canRead();
    }

    private static boolean isValidDuration(String duration) {
        SimpleDateFormat format = new SimpleDateFormat(durationFormat);
        format.setLenient(false);
        try {
            format.parse(duration);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    private static boolean isValidDate(String value) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            df.setLenient(false);
            df.parse(value);
        }
        catch (ParseException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private static boolean isValidRange(String val1, String val2, String dataType, Field field, String label, ActionMessages msgs) {
        block8: {
            if (dataType.equalsIgnoreCase(SearchType.DATE.toString())) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                    df.setLenient(false);
                    Date date1 = df.parse(val1);
                    Date date2 = df.parse(val2);
                    if (date1.after(date2)) {
                        msgs.add(field.getKey(), new ActionMessage(WebValidator.getProperty(label) + " range is not valid.", false));
                        logger.warn((Object)("Adding error message:" + WebValidator.getProperty(label) + " range is not valid."));
                        return false;
                    }
                    break block8;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (dataType.equalsIgnoreCase(SearchType.NUMERIC.toString())) {
                try {
                    if (Double.parseDouble(val1.toString()) > Double.parseDouble(val2.toString())) {
                        msgs.add(field.getKey(), new ActionMessage(WebValidator.getProperty(label) + " range is not valid.", false));
                        logger.warn((Object)("Adding error message:" + WebValidator.getProperty(label) + " range is not valid."));
                        return false;
                    }
                }
                catch (Exception e) {
                    msgs.add(field.getKey(), new ActionMessage(WebValidator.getProperty(label) + " range is not valid.", false));
                    logger.warn((Object)("Adding error message:" + WebValidator.getProperty(label) + " range is not valid."));
                    return false;
                }
            }
        }
        return true;
    }

    private static String getDurationFormat() {
        ApplicationProperties properties = null;
        try {
            properties = ApplicationProperties.getInstance();
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException("Duration property not specified properly in the Application.properties file.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read from the Application.properties file.", e);
        }
        String format = properties.getProperty("Duration.Format");
        return format;
    }
}

