/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LogModule;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

public class N2BB_LogClient {
    public static final int LOG_EMERGENCY = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRITICAL = 2;
    public static final int LOG_ERROR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_CORBAMETHOD = 7;
    public static final int LOG_STACKTRACE = 8;
    public static final int LOG_DEBUG = 9;
    public static final int LOG_ALL = 10;
    public static final int SETTINGSSERVER_INITFAILED = 0;
    public static final int SETTINGSSERVER_NOTFOUND = 1;
    public static final int SETTINGSSERVER_INVALIDNAME = 2;
    public static final int SETTINGSSERVER_CONFLICTINGSETTING = 3;
    public static final int SETTINGSSERVER_READONLY = 4;
    public static final int SETTINGSSERVER_UNSUPPORTEDSETTING = 5;
    public static final int SETTINGSSERVER_WRONGTYPE = 6;
    public static final int SETTINGSSERVER_FIXEDSETTING = 7;
    public static final int CREATEORBFAILED = 8;
    public static final int DESTROYORBFAILED = 9;
    public static final int INVALIDROOTPOANAME = 10;
    public static final int RESOLVEROOTPOAFAILED = 11;
    public static final int NARROWFAILED = 12;
    public static final int FACTORYCREATED = 13;
    public static final int FACTORYCREATEFAILED = 14;
    public static final int FACTORYDESTROYED = 15;
    public static final int FACTORYDESTROYFAILED = 16;
    public static final int FACTORYNAMEREGISTERED = 17;
    public static final int FACTORYOUTOFSERVICE = 18;
    public static final int CHANNELNAMEREGISTERED = 19;
    public static final int SERVANTCREATED = 20;
    public static final int DUPLICATESERVANT = 21;
    public static final int SERVANTDESTROYED = 22;
    public static final int CREATEFAILED = 23;
    public static final int NOTFOUND = 24;
    public static final int OUTOFSERVICE = 25;
    public static final int NONEXISTENT = 26;
    public static final int PROVISIONSUCCESS = 27;
    public static final int PROVISIONFAILED = 28;
    public static final int NOTPROVISIONED = 29;
    public static final int ISNULL = 30;
    public static final int READY = 31;
    public static final int UNKNOWNHOST = 32;
    public static final int ADMINISTRATIVESTATECHANGED = 33;
    public static final int OPERATIONALSTATECHANGED = 34;
    public static final int PROVISIONALSTATECHANGED = 35;
    public static final int INVALIDSTATECHANGE = 36;
    public static final int ORACLECONNECTIONFAILED = 37;
    public static final int ORACLEPREPARESTATEMENTSFAILED = 38;
    public static final int ORACLEREADFAILED = 39;
    public static final int ORACLEWRITEFAILED = 40;
    public static final int ORACLEDELETEFAILED = 41;
    public static final int PERSISTENCEUSINGDEFAULT = 42;
    public static final int PBISTATE = 43;
    public static final int RPCTIMEOUT = 44;
    public static final int RPCSERVERERROR = 45;
    public static final int RPCEXCEPTION = 46;
    public static final int RETRYFAILED = 47;
    public static final int METHODENTRY = 48;
    public static final int METHODEXIT = 49;
    public static final int NOTIMPLEMENTED = 50;
    public static final int ELAPSEDTIME = 51;
    public static final int SERVERSTARTUP = 52;
    public static final int SERVERSHUTDOWN = 53;
    public static final int UNSPECIFIEDEXCEPTION = 54;
    public static final int CBIUPSTREAMFAILED = 55;
    public static final int CBIUPSTREAMSUCCEEDED = 56;
    public static final int NOTIFICATIONCHANNELCREATED = 57;
    public static final int NOTIFICATIONCHANNELCREATEFAILED = 58;
    public static final int SETFACTORYOBJECTSUCCEEDED = 59;
    public static final int SETFACTORYOBJECTFAILED = 60;
    public static final int THREADPOOLCREATED = 61;
    public static final int THREADPOOLCREATEFAILED = 62;
    public static final int RPCHANDLESCREATED = 63;
    public static final int RPCHANDLESCREATEFAILED = 64;
    public static final int PERSISTFAILED = 65;
    public static final int UNPERSISTFAILED = 66;
    public static final int PUBLISHNOTIFICATIONFAILED = 67;
    private static final String[] MESSAGETABLE = new String[]{"Failed to initialize SClient", "Setting not found: $(1)", "Invalid setting name: $(1)", "Conflicting setting: $(1)", "Read-only setting: $(1)", "Unsupported setting: $(1)", "Wrong type: $(1)", "Setting has fixed value: $(1)", "Create ORB failed: $(1)", "Destory ORB failed: $(1)", "Invalid name for Root POA: $(1)", "Resolving Root POA failed.", "Failed to narrow object to $(1): $(2)", "$(1) Factory created named '$(2)'", "Unable to create $(1) factory named '$(2)'", "$(1) Factory destroyed named '$(2)'", "Unable to destroy $(1) factory named '$(2)'", "$(1) Factory '$(2)' is registered with Naming Service as $(3)", "$(1) Factory '$(2)' is out of service; can't $(3)", "Notification Channel '$(1)' registered with Naming Service as $(2)", "Created $(1) servant named '$(2)'", "Duplicate $(1) servant named '$(2)'", "Destroyed $(1) servant named '$(2)'", "Unable to create $(1): $(2)", "$(1) not found.", "$(1) is out of service.", "$(1) does not exist.", "$(1) Successfully provisioned", "Unable to  provision $(2)", "Object $(1) is not provisioned.", "$(1) is null: $(2)", "$(1) is ready.", "Unknown host: $(1)", "Published AdministrativeStateChangeEvent $(1) from $(2)", "Published OperationalStateChangeEvent $(1) from $(2)", "Published ProvisionalStateChangeEvent $(1) from $(2)", "Invalid state change in $(1): cannot change $(2) state to $(3)", "Oracle: connection failed: $(1)", "Oracle: Unable to prepare SQL statements: $(1)", "Oracle: Unable to read object $(1): $(2)", "Oracle: Unable to write object $(1): $(2)", "Oracle: Unable to delete object $(1): $(2)", "Unable to determine requested persistence method in $(1): $(2). Defaulting to $(3)", "CBI is $(1)", "CBI RPC call $(1) timed out: $(2)", "CBI RPC call $(1) received Server Error: $(2)", "CBI RPC call $(1) raised exception: $(2)", "CBI RPC call $(1) failed.  Number of retries attempted: $(2)", "Method Entered", "Method Exited", "$(1) not implemented", "Total time (msecs) to $(1): $(2)", "$(1) Server started.", "$(1) Server stopped.", "Caught Unspecified Exception while $(1):  $(2)", "CBI $(1) for ID='$(2)' with sequence number $(3) failed with reason='$(4)'", "CBI $(1) for $(2) succeeded", "Notification Channel created named %s", "Failed to create Notification Channel named %s", "Set factory object for %s to %s", "Failed to set Factory object for %s to %s: %s", "Created %s threadpool containing %s threads", "Failed to create %s threadpool containing %s threads: %s", "Created %s RPC Handles", "Failed to create %s RPC Handles: %s", "Failed to persist object %s: %s", "Failed to unpersist object %s: %s", "Failed to publish Notification event %s: %s"};
    private static final String UNKNOWN = "Unknown";
    private DatagramSocket m_dgSocket = null;
    private int m_logServerPort = 60101;
    private InetAddress m_logServerAddress = null;
    private String m_ipAddress = null;
    private String m_facility = null;
    private int m_bufferSize = 65535;
    private Vector m_messageQueue;
    private static N2BB_LogClient m_instance = null;

    public static N2BB_LogClient instance() {
        if (m_instance == null) {
            m_instance = new N2BB_LogClient("DEFAULT");
        }
        return m_instance;
    }

    public static N2BB_LogClient instance(String string) {
        if (m_instance == null) {
            m_instance = new N2BB_LogClient(string);
        } else {
            m_instance.setFacility(string);
        }
        return m_instance;
    }

    public static N2BB_LogClient instance(String string, int n) {
        N2BB_LogClient.instance(string).setBufferSize(n);
        return m_instance;
    }

    protected N2BB_LogClient(String string) {
        this.m_facility = string;
        this.m_messageQueue = new Vector();
        this.initSocket();
    }

    public void setFacility(String string) {
        this.m_facility = string;
    }

    public void setBufferSize(int n) {
        try {
            this.m_bufferSize = n;
            if (this.m_dgSocket != null) {
                this.m_dgSocket.setSendBufferSize(this.m_bufferSize);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public boolean logMessage(String string, String string2, String string3, int n, String string4) {
        int n2;
        boolean bl = true;
        String string5 = n < 10 ? "    0" + Integer.toString(n) : "    " + Integer.toString(n);
        StringBuffer stringBuffer = new StringBuffer(string4 + " ");
        for (n2 = 0; n2 < 10 - string4.length(); ++n2) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string5 + " ");
        stringBuffer.append(string + "." + string2 + "(): " + string3);
        this.m_messageQueue.add(stringBuffer.toString());
        n2 = 1;
        if (this.m_dgSocket == null || this.m_ipAddress == null) {
            n2 = this.initSocket() ? 1 : 0;
        }
        if (n2 != 0) {
            String string6 = "";
            while (this.m_messageQueue.size() > 0) {
                try {
                    string6 = (String)this.m_messageQueue.remove(0);
                    DatagramPacket datagramPacket = new DatagramPacket(string6.getBytes(), string6.length(), this.m_logServerAddress, this.m_logServerPort);
                    this.m_dgSocket.send(datagramPacket);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (IOException iOException) {
                    System.out.println("N2BB_LogClient::logMessage: Unable to send message to the logger. Exception caught");
                    System.out.println("Exception : " + iOException.toString());
                    this.m_messageQueue.add(0, string6);
                    bl = false;
                }
            }
        }
        return bl;
    }

    public boolean logMessage(String string, String string2, String string3, int n) {
        return this.logMessage(string, string2, string3, n, this.m_facility);
    }

    public boolean logMessage(String string, String string2, String string3) {
        return this.logMessage(string, string2, string3, 9, this.m_facility);
    }

    public boolean LogSettingsServerFailed(String string, String string2, int n, String string3) {
        int n2 = 3;
        if (n == 0) {
            n2 = 2;
        }
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[n], stringArray), n2);
    }

    public boolean LogCreateOrbFailed(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[8], stringArray), 0);
    }

    public boolean LogDestroyOrbFailed(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[9], stringArray), 3);
    }

    public boolean LogInvalidRootPoaName(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[10], stringArray), 0);
    }

    public boolean LogResolveRootPoaFailed(String string, String string2) {
        return this.logMessage(string, string2, MESSAGETABLE[11], 0);
    }

    public boolean LogNarrowFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[12], stringArray), 3);
    }

    public boolean LogFactoryCreated(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[13], stringArray), 6);
    }

    public boolean LogFactoryCreateFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[14], stringArray), 0);
    }

    public boolean LogFactoryDestroyed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[15], stringArray), 6);
    }

    public boolean LogFactoryDestroyFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[16], stringArray), 3);
    }

    public boolean LogFactoryNameRegistered(String string, String string2, String string3, String string4, String string5) {
        String[] stringArray = new String[]{string3, string4, string5};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[17], stringArray), 6);
    }

    public boolean LogFactoryOutOfService(String string, String string2, String string3, String string4, String string5) {
        String[] stringArray = new String[]{string3, string4, string5};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[18], stringArray), 6);
    }

    public boolean LogChannelNameRegistered(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[19], stringArray), 6);
    }

    public boolean LogServantCreated(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[20], stringArray), 9);
    }

    public boolean LogDuplicateServant(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[21], stringArray), 3);
    }

    public boolean LogServantDestroyed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[22], stringArray), 9);
    }

    public boolean LogCreateFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[23], stringArray), 3);
    }

    public boolean LogNotFound(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[24], stringArray), 4);
    }

    public boolean LogOutOfService(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[25], stringArray), 4);
    }

    public boolean LogNonexistent(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[26], stringArray), 4);
    }

    public boolean LogProvisionSuccess(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[27], stringArray), 6);
    }

    public boolean LogProvisionFailed(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[28], stringArray), 3);
    }

    public boolean LogPackageProvisionSuccess(String string, String string2, String string3, String string4) {
        return this.logMessage(string, string2, string3 + " from " + string4 + " Successfully provisioned", 6);
    }

    public boolean LogPackageProvisionFailed(String string, String string2, String string3, String string4, String string5) {
        return this.logMessage(string, string2, "Unable to provision " + string3 + " from " + string4 + ": " + string5, 3);
    }

    public boolean LogNotProvisioned(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[29], stringArray), 4);
    }

    public boolean LogIsNull(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[30], stringArray), 3);
    }

    public boolean LogReady(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[31], stringArray), 6);
    }

    public boolean LogUnknownHost(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[32], stringArray), 2);
    }

    public boolean LogAdministrativeStateChanged(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[33], stringArray), 9);
    }

    public boolean LogOperationalStateChanged(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[34], stringArray), 9);
    }

    public boolean LogProvisioningStateChanged(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[35], stringArray), 9);
    }

    public boolean LogInvalidStateChange(String string, String string2, String string3, String string4, String string5) {
        String[] stringArray = new String[]{string3, string4, string5};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[36], stringArray), 3);
    }

    public boolean LogOracleConnectionFailed(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[37], stringArray), 0);
    }

    public boolean LogOraclePrepareStatementsFailed(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[38], stringArray), 0);
    }

    public boolean LogOracleReadFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[39], stringArray), 0);
    }

    public boolean LogOracleWriteFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[40], stringArray), 0);
    }

    public boolean LogOracleDeleteFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[41], stringArray), 0);
    }

    public boolean LogPersistenceUsingDefault(String string, String string2, String string3, String string4, String string5) {
        String[] stringArray = new String[]{string3, string4, string5};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[42], stringArray), 2);
    }

    public boolean LogCBIState(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[43], stringArray), 9);
    }

    public boolean LogRPCTimeout(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[44], stringArray), 3);
    }

    public boolean LogRPCServerError(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[45], stringArray), 3);
    }

    public boolean LogRPCException(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[46], stringArray), 3);
    }

    public boolean LogRetryFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[47], stringArray), 3);
    }

    public boolean LogMethodEntry(String string, String string2) {
        return this.logMessage(string, string2, MESSAGETABLE[48], 9);
    }

    public boolean LogMethodExit(String string, String string2) {
        return this.logMessage(string, string2, MESSAGETABLE[49], 9);
    }

    public boolean LogNotImplemented(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[50], stringArray), 3);
    }

    public boolean LogElapsedTime(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[51], stringArray), 9);
    }

    public boolean LogServerStartup(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[52], stringArray), 6);
    }

    public boolean LogServerShutdown(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[53], stringArray), 6);
    }

    public boolean LogUnspecifiedException(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[54], stringArray), 4);
    }

    public boolean LogCBIUpstreamFailed(String string, String string2, String string3, String string4, String string5, String string6) {
        String[] stringArray = new String[]{string3, string4, string5, string6};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[55], stringArray), 3);
    }

    public boolean LogCBIUpstreamSucceeded(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[56], stringArray), 6);
    }

    public boolean LogNotificationChannelCreated(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[57], stringArray), 6);
    }

    public boolean LogNotificationChannelCreateFailed(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[58], stringArray), 3);
    }

    public boolean LogSetFactoryObjectSucceeded(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[59], stringArray), 6);
    }

    public boolean LogSetFactoryObjectFailed(String string, String string2, String string3, String string4, String string5) {
        String[] stringArray = new String[]{string3, string4, string5};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[60], stringArray), 3);
    }

    public boolean LogThreadpoolCreated(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[61], stringArray), 6);
    }

    public boolean LogThreadpoolCreateFailed(String string, String string2, String string3, String string4, String string5) {
        String[] stringArray = new String[]{string3, string4, string5};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[62], stringArray), 3);
    }

    public boolean LogRPCHandlesCreated(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[63], stringArray), 6);
    }

    public boolean LogRPCHandlesCreateFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[64], stringArray), 3);
    }

    public boolean LogpersistFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[65], stringArray), 0);
    }

    public boolean LogUnPersistFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[66], stringArray), 0);
    }

    public boolean LogPublishNotificationFailed(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3, string4};
        return this.logMessage(string, string2, this.applyParams(MESSAGETABLE[67], stringArray), 4);
    }

    public boolean LogContentStoreFailed(String string, String string2, String string3, String string4, String string5, String string6) {
        return this.logMessage(string, string2, "Creation of content '" + string4 + "' associated with asset '" + string5 + "' on content store '" + string3 + "' failed: " + string6, 3);
    }

    public boolean logStackTrace(String string, String string2, String string3, Throwable throwable, int n) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        String string4 = string3 + "\n" + throwable.getMessage() + "\n" + stringWriter.toString();
        return this.logMessage(string, string2, string4, n);
    }

    private String applyParams(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((n = stringBuffer.toString().indexOf("$(")) != -1) {
            Integer n2;
            int n3 = stringBuffer.toString().indexOf(")", n);
            String string2 = stringBuffer.substring(n + 2, n3);
            try {
                n2 = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = new Integer(Integer.MAX_VALUE);
            }
            stringBuffer.delete(n, n3 + 1);
            if (n2 - 1 < stringArray.length) {
                stringBuffer.insert(n, stringArray[n2 - 1]);
                continue;
            }
            stringBuffer.insert(n, "");
        }
        return stringBuffer.toString();
    }

    private boolean initSocket() {
        boolean bl = true;
        try {
            this.m_dgSocket = new DatagramSocket();
            this.m_dgSocket.setSendBufferSize(this.m_bufferSize);
            this.m_logServerAddress = InetAddress.getLocalHost();
            if (this.m_logServerAddress != null) {
                this.m_ipAddress = this.m_logServerAddress.getHostAddress();
            }
        }
        catch (SocketException socketException) {
            System.out.println("N2BB_LogClient::initSocket: Unable to open datagram socket--will retry later.  Caching log messages.");
            bl = false;
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("N2BB_LogClient::initSocket: Unable to determine host IP address--will retry later.  Caching log messages.");
            bl = false;
        }
        return bl;
    }

    public boolean logMessage(String string, int n, String string2) {
        return this.logMessage(UNKNOWN, UNKNOWN, string, n, string2);
    }

    public boolean logMessage(String string, int n) {
        return this.logMessage(string, n, this.m_facility);
    }

    public boolean logMessage(String string) {
        return this.logMessage(string, 9, this.m_facility);
    }

    public boolean LogSettingsServerFailed(int n, String string) {
        return this.LogSettingsServerFailed(UNKNOWN, UNKNOWN, n, string);
    }

    public boolean LogCreateOrbFailed(String string) {
        return this.LogCreateOrbFailed(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogDestroyOrbFailed(String string) {
        return this.LogDestroyOrbFailed(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogInvalidRootPoaName(String string) {
        return this.LogInvalidRootPoaName(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogResolveRootPoaFailed() {
        return this.LogResolveRootPoaFailed(UNKNOWN, UNKNOWN);
    }

    public boolean LogNarrowFailed(String string, String string2) {
        return this.LogNarrowFailed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogFactoryCreated(String string, String string2) {
        return this.LogFactoryCreated(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogFactoryCreateFailed(String string, String string2) {
        return this.LogFactoryCreateFailed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogFactoryDestroyed(String string, String string2) {
        return this.LogFactoryDestroyed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogFactoryDestroyFailed(String string, String string2) {
        return this.LogFactoryDestroyFailed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogFactoryNameRegistered(String string, String string2, String string3) {
        return this.LogFactoryNameRegistered(UNKNOWN, UNKNOWN, string, string2, string3);
    }

    public boolean LogFactoryOutOfService(String string, String string2, String string3) {
        return this.LogFactoryOutOfService(UNKNOWN, UNKNOWN, string, string2, string3);
    }

    public boolean LogChannelNameRegistered(String string, String string2) {
        return this.LogChannelNameRegistered(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogServantCreated(String string, String string2) {
        return this.LogServantCreated(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogDuplicateServant(String string, String string2) {
        return this.LogDuplicateServant(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogServantDestroyed(String string, String string2) {
        return this.LogServantDestroyed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogCreateFailed(String string, String string2) {
        return this.LogCreateFailed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogNotFound(String string) {
        return this.LogNotFound(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogOutOfService(String string) {
        return this.LogOutOfService(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogNonexistent(String string) {
        return this.LogNonexistent(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogProvisionSuccess(String string) {
        return this.LogProvisionSuccess(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogProvisionFailed(String string) {
        return this.LogProvisionFailed(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogNotProvisioned(String string, String string2) {
        return this.LogNotProvisioned(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogIsNull(String string, String string2) {
        return this.LogIsNull(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogReady(String string) {
        return this.LogReady(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogUnknownHost(String string) {
        return this.LogUnknownHost(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogAdministrativeStateChanged(String string, String string2) {
        return this.LogAdministrativeStateChanged(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogOperationalStateChanged(String string, String string2) {
        return this.LogOperationalStateChanged(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogProvisioningStateChanged(String string, String string2) {
        return this.LogProvisioningStateChanged(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogInvalidStateChange(String string, String string2, String string3) {
        return this.LogInvalidStateChange(UNKNOWN, UNKNOWN, string, string2, string3);
    }

    public boolean LogOracleConnectionFailed(String string) {
        return this.LogOracleConnectionFailed(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogOraclePrepareStatementsFailed(String string) {
        return this.LogOraclePrepareStatementsFailed(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogOracleReadFailed(String string, String string2) {
        return this.LogOracleReadFailed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogOracleWriteFailed(String string, String string2) {
        return this.LogOracleWriteFailed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogOracleDeleteFailed(String string, String string2) {
        return this.LogOracleDeleteFailed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogPersistenceUsingDefault(String string, String string2, String string3) {
        return this.LogPersistenceUsingDefault(UNKNOWN, UNKNOWN, string, string2, string3);
    }

    public boolean LogCBIState(String string) {
        return this.LogCBIState(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogRPCTimeout(String string, String string2) {
        return this.LogRPCTimeout(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogRPCServerError(String string, String string2) {
        return this.LogRPCServerError(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogRPCException(String string, String string2) {
        return this.LogRPCException(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogRetryFailed(String string, String string2) {
        return this.LogRetryFailed(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogMethodEntry(String string) {
        return this.LogMethodEntry(UNKNOWN, string);
    }

    public boolean LogMethodExit(String string) {
        return this.LogMethodExit(UNKNOWN, string);
    }

    public boolean LogNotImplemented(String string) {
        return this.LogNotImplemented(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogElapsedTime(String string, String string2) {
        return this.LogElapsedTime(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogServerStartup(String string) {
        return this.LogServerStartup(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogServerShutdown(String string) {
        return this.LogServerShutdown(UNKNOWN, UNKNOWN, string);
    }

    public boolean LogUnspecifiedException(String string, String string2) {
        return this.LogUnspecifiedException(UNKNOWN, UNKNOWN, string, string2);
    }

    public boolean LogCBIUpstreamFailed(String string, String string2, String string3, String string4) {
        return this.LogCBIUpstreamFailed(UNKNOWN, UNKNOWN, string, string2, string3, string4);
    }

    public boolean LogCBIUpstreamSucceeded(String string, String string2) {
        return this.LogCBIUpstreamSucceeded(UNKNOWN, UNKNOWN, string, string2);
    }
}

