/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule;

import com.n2bb.AlertsModule.Alert;
import com.n2bb.AlertsModule.AlertData;
import com.n2bb.AlertsModule.AlertDataHelper;
import com.n2bb.AlertsModule.AlertDataListHelper;
import com.n2bb.AlertsModule.AlertHelper;
import com.n2bb.AlertsModule.AlertHistoryFilter;
import com.n2bb.AlertsModule.AlertHistoryFilterHelper;
import com.n2bb.AlertsModule.AlertHistoryListHelper;
import com.n2bb.AlertsModule.AlertName;
import com.n2bb.AlertsModule.AlertNameHelper;
import com.n2bb.AlertsModule.AlertNameListHelper;
import com.n2bb.AlertsModule.AlertOperations;
import com.n2bb.AlertsModule.AlertPackage.StringListHelper;
import com.n2bb.AlertsModule.BadValue;
import com.n2bb.AlertsModule.BadValueHelper;
import com.n2bb.AlertsModule.DuplicateAlert;
import com.n2bb.AlertsModule.DuplicateAlertHelper;
import com.n2bb.AlertsModule.DuplicateAlertName;
import com.n2bb.AlertsModule.DuplicateAlertNameHelper;
import com.n2bb.AlertsModule.InUse;
import com.n2bb.AlertsModule.InUseHelper;
import com.n2bb.AlertsModule.NotFound;
import com.n2bb.AlertsModule.NotFoundHelper;
import com.n2bb.AlertsModule.SNMPTrapListHelper;
import com.n2bb.AlertsModule.UnspecifiedException;
import com.n2bb.AlertsModule.UnspecifiedExceptionHelper;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class AlertPOA
extends Servant
implements InvokeHandler,
AlertOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:n2bb.com/AlertsModule/Alert:1.0", "IDL:omg.org/CORBA/Object:1.0"};

    public Alert _this() {
        return AlertHelper.narrow(this._this_object());
    }

    public Alert _this(ORB oRB) {
        return AlertHelper.narrow(this._this_object(oRB));
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (null == n) {
            throw new BAD_OPERATION(string + " not found");
        }
        switch (n) {
            case 0: {
                try {
                    AlertData alertData = AlertDataHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.defineAlertConfiguration(alertData);
                }
                catch (BadValue badValue) {
                    outputStream = responseHandler.createExceptionReply();
                    BadValueHelper.write(outputStream, badValue);
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
                catch (DuplicateAlert duplicateAlert) {
                    outputStream = responseHandler.createExceptionReply();
                    DuplicateAlertHelper.write(outputStream, duplicateAlert);
                }
                break;
            }
            case 1: {
                try {
                    outputStream = responseHandler.createReply();
                    SNMPTrapListHelper.write(outputStream, this.getSNMPTraps());
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                break;
            }
            case 2: {
                try {
                    AlertName alertName = AlertNameHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.defineAlertName(alertName);
                }
                catch (DuplicateAlertName duplicateAlertName) {
                    outputStream = responseHandler.createExceptionReply();
                    DuplicateAlertNameHelper.write(outputStream, duplicateAlertName);
                }
                catch (BadValue badValue) {
                    outputStream = responseHandler.createExceptionReply();
                    BadValueHelper.write(outputStream, badValue);
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
                break;
            }
            case 3: {
                try {
                    String string2 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    AlertNameHelper.write(outputStream, this.getAlertName(string2));
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                break;
            }
            case 4: {
                try {
                    String string3 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    AlertDataHelper.write(outputStream, this.getAlertDetail(string3));
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                break;
            }
            case 5: {
                try {
                    outputStream = responseHandler.createReply();
                    AlertHistoryListHelper.write(outputStream, this.getAlertHistory());
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
                break;
            }
            case 6: {
                try {
                    outputStream = responseHandler.createReply();
                    StringListHelper.write(outputStream, this.getAlertHistoryNames());
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
                break;
            }
            case 7: {
                try {
                    AlertName alertName = AlertNameHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.updateAlertName(alertName);
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                catch (BadValue badValue) {
                    outputStream = responseHandler.createExceptionReply();
                    BadValueHelper.write(outputStream, badValue);
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
                break;
            }
            case 8: {
                try {
                    String string4 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    this.deleteAlertName(string4);
                }
                catch (InUse inUse) {
                    outputStream = responseHandler.createExceptionReply();
                    InUseHelper.write(outputStream, inUse);
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
                break;
            }
            case 9: {
                try {
                    outputStream = responseHandler.createReply();
                    AlertDataListHelper.write(outputStream, this.listAlerts());
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                break;
            }
            case 10: {
                try {
                    AlertHistoryFilter alertHistoryFilter = AlertHistoryFilterHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    AlertHistoryListHelper.write(outputStream, this.getAlertHistoryWithFilter(alertHistoryFilter));
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
                break;
            }
            case 11: {
                try {
                    outputStream = responseHandler.createReply();
                    AlertNameListHelper.write(outputStream, this.getAlertNames());
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                break;
            }
            case 12: {
                try {
                    outputStream = responseHandler.createReply();
                    StringListHelper.write(outputStream, this.getAlertHistoryIdentifiers());
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
                break;
            }
            case 13: {
                try {
                    AlertData alertData = AlertDataHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.updateAlertConfiguration(alertData);
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                }
                catch (BadValue badValue) {
                    outputStream = responseHandler.createExceptionReply();
                    BadValueHelper.write(outputStream, badValue);
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
                break;
            }
            case 14: {
                try {
                    String string5 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    this.deleteAlertConfiguration(string5);
                    break;
                }
                catch (NotFound notFound) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFoundHelper.write(outputStream, notFound);
                    break;
                }
                catch (UnspecifiedException unspecifiedException) {
                    outputStream = responseHandler.createExceptionReply();
                    UnspecifiedExceptionHelper.write(outputStream, unspecifiedException);
                }
            }
        }
        return outputStream;
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    static {
        m_opsHash.put("defineAlertConfiguration", new Integer(0));
        m_opsHash.put("getSNMPTraps", new Integer(1));
        m_opsHash.put("defineAlertName", new Integer(2));
        m_opsHash.put("getAlertName", new Integer(3));
        m_opsHash.put("getAlertDetail", new Integer(4));
        m_opsHash.put("getAlertHistory", new Integer(5));
        m_opsHash.put("getAlertHistoryNames", new Integer(6));
        m_opsHash.put("updateAlertName", new Integer(7));
        m_opsHash.put("deleteAlertName", new Integer(8));
        m_opsHash.put("listAlerts", new Integer(9));
        m_opsHash.put("getAlertHistoryWithFilter", new Integer(10));
        m_opsHash.put("getAlertNames", new Integer(11));
        m_opsHash.put("getAlertHistoryIdentifiers", new Integer(12));
        m_opsHash.put("updateAlertConfiguration", new Integer(13));
        m_opsHash.put("deleteAlertConfiguration", new Integer(14));
    }
}

