/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule;

import com.n2bb.AlertsModule.Alert;
import com.n2bb.AlertsModule.AlertHelper;
import com.n2bb.AlertsModule.Alerts_impl;
import com.n2bb.AlertsModule.actions.AlertHistActionManager;
import com.n2bb.AlertsModule.actions.EmailActionManager;
import com.n2bb.AlertsModule.actions.SNMPActionManager;
import com.n2bb.AlertsModule.consumers.EventsUDPConsumer;
import com.n2bb.AlertsModule.consumers.LogUDPConsumer;
import com.n2bb.AlertsModule.consumers.UDPConsumerBase;
import com.n2bb.AlertsModule.db.AlertHistPersist;
import com.n2bb.AlertsModule.db.AlertsPersist;
import com.n2bb.AlertsModule.util.SettingsClient;
import com.n2bb.LogModule.N2BB_LogClient;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class AlertServer {
    private Logger n2bbLog = Logger.getLogger(AlertServer.class);
    private ORB m_orb = null;
    private SettingsClient m_SClient = null;
    private LogUDPConsumer m_LogConsumer = null;
    private EventsUDPConsumer m_EventsConsumer = null;
    private UDPConsumerBase m_SmpUDPConsumer = null;
    public static SNMPActionManager sNMPActionManager;
    public static EmailActionManager emailActionManager;
    public static AlertHistActionManager alertHistActionManager;

    private void init(int rcvBufferSize, String nameServiceCorbaloc, String alertHost, String alertPort) throws Exception {
        this.n2bbLog.info((java.lang.Object)("name service corbaloc... " + nameServiceCorbaloc));
        this.n2bbLog.info((java.lang.Object)("OAHost... " + alertHost));
        this.n2bbLog.info((java.lang.Object)("OAPort... " + alertPort));
        N2BB_LogClient.instance((String)"ALERTS");
        try {
            Properties props = new Properties();
            props.setProperty("ORBInitRef.NameService", nameServiceCorbaloc);
            props.setProperty("OAHost", alertHost);
            props.setProperty("OAPort", alertPort);
            this.m_orb = ORB.init((String[])new String[0], (Properties)props);
            this.m_SClient = new SettingsClient(this.m_orb);
            AlertsPersist.getInstance(SettingsClient.dbDriver, SettingsClient.dbURL, SettingsClient.dbUser, SettingsClient.dbPwd);
            AlertHistPersist.getInstance(SettingsClient.dbDriverRpt, SettingsClient.dbURLRpt, SettingsClient.dbUserRpt, SettingsClient.dbPwdRpt, SettingsClient.alertHistMaxThreads);
            Alerts_impl.getInstance();
            this.n2bbLog.info((java.lang.Object)"starting central logger UDP consumer");
            this.m_LogConsumer = new LogUDPConsumer(SettingsClient.centralLoggerListenPort, rcvBufferSize, SettingsClient.centralLoggerConsumerThreads);
            this.n2bbLog.info((java.lang.Object)"starting events UDP consumer");
            this.m_EventsConsumer = new EventsUDPConsumer(SettingsClient.eventsListenPort, rcvBufferSize, SettingsClient.eventsConsumerThreads);
            this.n2bbLog.info((java.lang.Object)"starting SMP UDP consumer");
            try {
                Class<?> c = Class.forName(SettingsClient.smpArg4);
                Class[] cc = new Class[]{Class.forName("com.n2bb.AlertsModule.util.SettingsClient"), Class.forName("java.lang.Integer")};
                Constructor<?> f = c.getConstructor(cc);
                java.lang.Object[] args = new java.lang.Object[]{this.m_SClient, new Integer(rcvBufferSize)};
                this.m_SmpUDPConsumer = (UDPConsumerBase)f.newInstance(args);
            }
            catch (Exception e) {
                this.n2bbLog.error((java.lang.Object)"Error loading SMP UDP consumer", (Throwable)e);
            }
            sNMPActionManager = new SNMPActionManager("SNMPActionManager", SettingsClient.snmpMaxThreads);
            emailActionManager = new EmailActionManager("EmailActionManager", SettingsClient.emailMaxThreads);
            alertHistActionManager = new AlertHistActionManager("AlertHistActionManager", SettingsClient.alertHistMaxThreads);
            this.initCORBA();
            this.n2bbLog.info((java.lang.Object)"alerts is initialized");
            N2BB_LogClient.instance().logMessage("AlertServer", "init", "alerts is initialized", 6);
        }
        catch (Exception e) {
            this.n2bbLog.error((java.lang.Object)e.getMessage(), (Throwable)e);
            N2BB_LogClient.instance().logStackTrace("AlertServer", "init", "initialization exception", (Throwable)e, 3);
            throw e;
        }
    }

    private void initCORBA() throws Exception {
        this.n2bbLog.debug((java.lang.Object)"enter");
        POA rootPOA = POAHelper.narrow((Object)this.m_orb.resolve_initial_references("RootPOA"));
        Policy[] policies = new Policy[]{rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
        POA alertsPOA = rootPOA.create_POA("Alerts", rootPOA.the_POAManager(), policies);
        for (int i = 0; i < policies.length; ++i) {
            policies[i].destroy();
        }
        rootPOA.the_POAManager().activate();
        alertsPOA.activate_object_with_id("Alerts".getBytes(), (Servant)Alerts_impl.getInstance());
        Alert alert = AlertHelper.narrow(alertsPOA.servant_to_reference((Servant)Alerts_impl.getInstance()));
        NameComponent[] nc = new NameComponent[]{new NameComponent("Alerts", "")};
        Object nsObj = this.m_orb.resolve_initial_references("NameService");
        this.n2bbLog.debug((java.lang.Object)("resolved object = " + nsObj.toString()));
        NamingContext ns = NamingContextHelper.narrow((Object)nsObj);
        ns.rebind(nc, (Object)alert);
        N2BB_LogClient.instance().LogFactoryNameRegistered("AlertServer", "initCORBA", "Alerts", "Alerts", "");
        N2BB_LogClient.instance().LogServerStartup("AlertServer", "initCORBA", "Alerts");
    }

    private void run() {
        this.n2bbLog.debug((java.lang.Object)"enter");
        this.m_orb.run();
    }

    private static void usage() {
        System.out.println("Usage:  Alerts rcvBufferSize nameServiceCorbaloc OAHost OAPort");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            AlertServer.usage();
            return;
        }
        AlertServer as = new AlertServer();
        as.init(Integer.parseInt(args[0]), args[1], args[2], args[3]);
        as.run();
    }
}

