/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule.containers;

import com.n2bb.AlertsModule.ActionType;
import com.n2bb.AlertsModule.AlertData;
import com.n2bb.AlertsModule.AlertServer;
import com.n2bb.AlertsModule.containers.AlertContainer;
import com.n2bb.AlertsModule.util.SettingsClient;
import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.util.CircularArray;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbsAlertContainer
implements AlertContainer {
    private static Logger log = Logger.getLogger(AbsAlertContainer.class);
    protected AlertData alertdata;
    protected CircularArray events = null;
    protected CircularArray alerts = null;

    public AbsAlertContainer(AlertData ad) {
        log.debug((Object)"enter");
        this.setAlertData(ad);
        this.events = new CircularArray(ad.threshold.count);
        this.alerts = new CircularArray(ad.frequency.count);
    }

    public abstract void setAlertData(AlertData var1);

    public abstract void addEvent(Long var1, String var2) throws Exception;

    public AlertData getAlertData() {
        return this.alertdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMatch(Long timeInMillis, String msg) throws Exception {
        log.info((Object)("alert match... " + this.alertdata.identifier + " msg... " + msg));
        boolean logHistory = false;
        boolean takeAction = false;
        CircularArray circularArray = this.events;
        synchronized (circularArray) {
            this.events.add((Object)timeInMillis);
            if (this.events.size() == this.events.getMaxSize() && (Long)this.events.get(this.events.size() - 1) - (Long)this.events.get(0) < (long)(this.alertdata.threshold.seconds * 1000)) {
                logHistory = true;
                this.events.clear();
                if (this.alerts.size() < this.alerts.getMaxSize() || this.alertdata.frequency.seconds == 1 || timeInMillis - (Long)this.alerts.get(0) >= (long)(this.alertdata.frequency.seconds * 1000)) {
                    this.alerts.add((Object)timeInMillis);
                    takeAction = true;
                }
            }
        }
        if (logHistory) {
            Date date = new Date(timeInMillis);
            this.sendAlertHist(date, this.alertdata, msg, takeAction);
            if (takeAction) {
                for (int i = 0; i < this.alertdata.action.length; ++i) {
                    if (this.alertdata.action[i].type == ActionType.a_email) {
                        this.sendEmail(this.alertdata.action[i].detail, msg, date);
                        continue;
                    }
                    if (this.alertdata.action[i].type != ActionType.a_snmp) continue;
                    this.sendSNMP(this.alertdata.action[i].detail, msg);
                }
            }
        }
    }

    private void sendSNMP(String trap, String message) {
        log.debug((Object)"enter");
        try {
            AlertServer.sNMPActionManager.doAction(new String[]{SettingsClient.snmpExec, "-v", "1", "-c", SettingsClient.snmpTrapSendCommunity, SettingsClient.snmpTrapDestination, SettingsClient.snmpEnterpriseOID, SettingsClient.snmpAgent, "6", trap, "\"\"", SettingsClient.snmpTrapMessageOID, "s", message});
        }
        catch (Exception e) {
            log.error((Object)("snmp error - message... " + e.getMessage()), (Throwable)e);
            N2BB_LogClient.instance().logStackTrace("AlertContainer", "sendSNMP", "error sending snmp", (Throwable)e, 3);
        }
        log.debug((Object)"exit");
    }

    private void sendEmail(String address, String message, Date date) {
        log.debug((Object)"enter");
        try {
            AlertServer.emailActionManager.doAction(new Object[]{SettingsClient.emailHost, SettingsClient.emailFromAddr, address, this.alertdata.identifier, this.alertdata.name.name, message, date});
        }
        catch (Exception e) {
            log.error((Object)("email error - message... " + e.getMessage()), (Throwable)e);
            N2BB_LogClient.instance().logStackTrace("AlertContainer", "sendEmail", "error sending email", (Throwable)e, 3);
        }
        log.debug((Object)"exit");
    }

    private void sendAlertHist(Date date, AlertData alertdata, String msg, boolean actionTaken) {
        log.debug((Object)"enter");
        try {
            AlertServer.alertHistActionManager.doAction(new Object[]{date, alertdata, msg, new Boolean(actionTaken)});
        }
        catch (Exception e) {
            log.error((Object)("alert history error - message... " + e.getMessage()), (Throwable)e);
            N2BB_LogClient.instance().logStackTrace("AlertContainer", "sendAlertHist", "error sending alert history", (Throwable)e, 3);
        }
        log.debug((Object)"exit");
    }
}

