/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.adi;

import com.tandbergtv.workflow.util.adi.Asset;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADI11Parser {
    private Document adi;
    private static final String ASSET_CLASS_XPATH = "//Asset/Asset/Metadata/AMS";
    private static final String TITLE_BRIEF_XPATH = "//App_Data[@Name='Title_Brief']";
    private static final String RUN_TIME_XPATH = "//App_Data[@Name='Run_Time']";
    private static final String APP_DATA_VALUE = "Value";
    private static final String PACKAGE_XPATH = "//ADI/Metadata/AMS";
    private static final String PROVIDER_ID = "Provider_ID";
    private static final String PROVIDER = "Provider";
    private static final String ASSET_ID = "Asset_ID";
    private static final String ASSET_CLASS = "Asset_Class";
    private static final String ADI_XSD = "com/tandbergtv/workflow/util/adi/adi.xsd";
    private static final String PKG_DESC_XPATH = "//AMS[@Asset_Class='package']/@Description";
    private static final Logger logger = Logger.getLogger(ADI11Parser.class);

    private ADI11Parser() {
    }

    public static ADI11Parser newInstance() {
        return new ADI11Parser();
    }

    public void load(String path) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Schema schema = this.loadSchema();
            factory.setSchema(schema);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setEntityResolver(new MyEntityResolver());
            this.adi = docBuilder.parse(new File(path));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read ADI file " + path, e);
        }
    }

    public void load(InputStream in) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Schema schema = this.loadSchema();
            factory.setSchema(schema);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setEntityResolver(new MyEntityResolver());
            this.adi = docBuilder.parse(in);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read the input stream for ADI file", e);
        }
    }

    public List<Asset> extractAssets() {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(ASSET_CLASS_XPATH, this.adi, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Asset asset = new Asset();
                asset.setContentType(nodes.item(i).getAttributes().getNamedItem(ASSET_CLASS).getTextContent());
                asset.setAssetId(nodes.item(i).getAttributes().getNamedItem(ASSET_ID).getTextContent());
                assets.add(asset);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load the set of assets from adi.xml", (Throwable)e);
        }
        return assets;
    }

    public String getBriefTitle() {
        return this.getAttributeValue(TITLE_BRIEF_XPATH, APP_DATA_VALUE);
    }

    public String getPackageDescription() {
        return this.evaluate(PKG_DESC_XPATH);
    }

    public String getTitle() {
        throw new UnsupportedOperationException();
    }

    public String getPackageAssetID() {
        return this.getAttributeValue(PACKAGE_XPATH, ASSET_ID);
    }

    public String getAssetID(String asset) {
        throw new UnsupportedOperationException();
    }

    public String getAssetType(String asset) {
        throw new UnsupportedOperationException();
    }

    public String getProviderID() {
        return this.getAttributeValue(PACKAGE_XPATH, PROVIDER_ID);
    }

    public String getProvider() {
        return this.getAttributeValue(PACKAGE_XPATH, PROVIDER);
    }

    public String getRunTime() {
        return this.getAttributeValue(RUN_TIME_XPATH, APP_DATA_VALUE);
    }

    public NodeList getNodes(String xpathStr) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate(xpathStr, this.adi, XPathConstants.NODESET);
        return nodes;
    }

    private String getAttributeValue(String xpath, String attribute) {
        try {
            Node node = (Node)XPathFactory.newInstance().newXPath().evaluate(xpath, this.adi, XPathConstants.NODE);
            if (node != null) {
                return node.getAttributes().getNamedItem(attribute).getTextContent();
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException();
        }
        return null;
    }

    private String evaluate(String xpath) {
        try {
            return (String)XPathFactory.newInstance().newXPath().evaluate(xpath, this.adi, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException();
        }
    }

    private Schema loadSchema() throws Exception {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(ADI_XSD);
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(stream));
    }

    class MyEntityResolver
    implements EntityResolver {
        private static final String DTD_FILE_PATH = "com/tandbergtv/workflow/util/adi/ADI.DTD";

        MyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputStream fs = this.getClass().getClassLoader().getResourceAsStream(DTD_FILE_PATH);
            return new InputSource(fs);
        }
    }
}

